﻿using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;
using System.Text.RegularExpressions;

public partial class UserDefinedFunctions
{
    [Microsoft.SqlServer.Server.SqlFunction(
        IsDeterministic=true, 
        DataAccess=DataAccessKind.None, 
        Name="ufnValidateString")]
    public static SqlBoolean ValidateString(SqlString input, SqlString template)
    {
        if (input.IsNull || template.IsNull)
	    {
		 return SqlBoolean.Null;
	    }
        return (SqlBoolean)Regex.IsMatch(
            input.Value, 
            template.Value, 
            RegexOptions.CultureInvariant);
    }
};