﻿using System;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;
using System.Text;

[Serializable]
[Microsoft.SqlServer.Server.SqlUserDefinedAggregate(
    Format.UserDefined, MaxByteSize=-1, 
    IsNullIfEmpty=true, Name="ufnConcatenate")]
public struct Concatenate : IBinarySerialize
{
    StringBuilder result;

    public void Init()
    {
        result = new StringBuilder();
        result.Append("");
    }

    public void Accumulate([SqlFacet(MaxSize=-1)] SqlString Value)
    {
        if (Value.IsNull)
        {
            return;
        }
        result.Append(Value.Value);
    }

    public void Merge(Concatenate Group)
    {
        result.Append(Group.result);
    }

    [return: SqlFacet(MaxSize=-1)]
    public SqlString Terminate()
    {
        return result.ToString();
    }

    public void Read(System.IO.BinaryReader r)
    {
        result = new StringBuilder();
        result.Append(r.ReadString());
    }

    public void Write(System.IO.BinaryWriter w)
    {
        w.Write(result.ToString());
    }
}


