DROP TABLE autorzy;
CREATE TABLE autorzy
  (
  id_au       CHAR(3)     NOT NULL,
  imie_au     VARCHAR(15) NOT NULL,
  nazwisko_au VARCHAR(15) NOT NULL,
  telefon     VARCHAR(12) NULL    ,
  adres       VARCHAR(20) NULL    ,
  miasto      VARCHAR(15) NULL    ,
  woj         CHAR(2)     NULL    ,
  kod         CHAR(5)     NULL    ,
  CONSTRAINT autorzy_kg PRIMARY KEY (id_au)
  );

DROP TABLE wydawcy;
CREATE TABLE wydawcy
  (
  id_wyd      CHAR(3)     NOT NULL,
  nazwa_wyd   VARCHAR(30) NOT NULL,
  miasto      VARCHAR(15) NOT NULL,
  woj         CHAR(2)     NULL    ,
  kraj        VARCHAR(15) NOT NULL,
  CONSTRAINT wydawcy_kg PRIMARY KEY (id_wyd)
  );

DROP TABLE tytuly;
CREATE TABLE tytuly
  (
  id_tytulu   CHAR(3)      NOT NULL,
  tytul       VARCHAR(40)  NOT NULL,
  rodzaj      VARCHAR(12)  NULL    ,
  id_wyd      CHAR(3)      NOT NULL,
  stron       INTEGER      NULL    ,
  cena        DECIMAL(5,2) NULL    ,
  sprzedanych INTEGER      NULL    ,
  data_wyd    DATE         NULL    ,
  kontrakt    SMALLINT     NOT NULL,
  CONSTRAINT tytuly_kg PRIMARY KEY (id_tytulu)
  );

DROP TABLE autorzy_tytulow;
CREATE TABLE autorzy_tytulow
  (
  id_tytulu         CHAR(3)      NOT NULL,
  id_au             CHAR(3)      NOT NULL,
  pozycja_au        SMALLINT     NOT NULL,
  procent_tantiem   DECIMAL(5,2) NOT NULL,
  CONSTRAINT autorzy_tytulow_kg PRIMARY KEY (id_tytulu, id_au)
  );

DROP TABLE tantiemy;
CREATE TABLE tantiemy
  (
  id_tytulu     CHAR(3)      NOT NULL,
  zaliczka      DECIMAL(9,2) NULL    ,
  stawka        DECIMAL(5,2) NULL    ,
  CONSTRAINT tantiemy_kg PRIMARY KEY (id_tytulu)
  );

INSERT INTO autorzy VALUES('A01','Sylwia','Jaworek','46-35-32-135',
  'ul. Zachodnia 75','Sochaczew','MZ','96500');
INSERT INTO autorzy VALUES('A02','Wanda','Karwowska','13-63-74-642',
  'ul. Szkolna 29','Sanok','PD','38500');
INSERT INTO autorzy VALUES('A03','Halina','Krysiak','32-90-02-371',
  'al. Korfantego 38/14','Katowice','SL','40098');
INSERT INTO autorzy VALUES('A04','Ryszard','Krysiak','32-90-02-371',
  'al. Korfantego 38/14','Katowice','SL','40098');
INSERT INTO autorzy VALUES('A05','Zbigniew','Sitko','22-86-24-190',
  'ul. Norwida 114','Warszawa','MZ','02304');
INSERT INTO autorzy VALUES('A06',' ','Sitkowski','32-16-47-989',
  'ul. Dworcowa 39','Rybnik','SL','44200');
INSERT INTO autorzy VALUES('A07','Kazimierz','Wojtowicz','62-75-33-325',
  'Rynek 8','Kalisz','WL','62800');

INSERT INTO wydawcy VALUES('W01','Dom Wydawniczy Barykada','Warszawa','MZ','Polska');
INSERT INTO wydawcy VALUES('W02','Oficyna Wydawnicza Reset','Katowice','SL','Polska');
INSERT INTO wydawcy VALUES('W03','Wydawnictwo Schadenfreude','Hamburg',NULL,'Niemcy');
INSERT INTO wydawcy VALUES('W04','Wydawnictwo Formy','Bytom','SL','Polska');

INSERT INTO tytuly VALUES('T01','1977!','historia','W01',
  107,21.99,566,DATE '2000-08-01',1);
INSERT INTO tytuly VALUES('T02','200 lat niemieckiego humoru','historia','W03',
  14,19.95,9566,DATE '1998-04-01',1);
INSERT INTO tytuly VALUES('T03','Spytaj administratora','komputery','W02',
  1226,39.95,25667,DATE '2000-09-01',1);
INSERT INTO tytuly VALUES('T04','Nieprzytomny - co to znaczy?','psychologia','W04',
  510,12.99,13001,DATE '1999-05-31',1);
INSERT INTO tytuly VALUES('T05','Walka na frazesy','psychologia','W04',
  201,6.95,201440,DATE '2001-01-01',1);
INSERT INTO tytuly VALUES('T06','Czy na pewno nigdy?','biografia','W01',
  473,19.95,11320,DATE '2000-07-31',1);
INSERT INTO tytuly VALUES('T07','Winna jest moja matka','biografia','W03',
  333,23.95,1500200,DATE '1999-10-01',1);
INSERT INTO tytuly VALUES('T08','Poczekaj na koniec lekcji','dzieci','W04',
  86,10.00,4095,DATE '2001-06-01',1);
INSERT INTO tytuly VALUES('T09','Daj buzi','dzieci','W04',
  22,13.95,5000,DATE '2002-05-31',1);
INSERT INTO tytuly VALUES('T10','Nie bez ikry','biografia','W01',
  NULL,NULL,NULL,NULL,0);
INSERT INTO tytuly VALUES('T11','Zachowania sterowane hormonami','psychologia','W04',
  826,7.99,94123,DATE '2000-11-30',1);
INSERT INTO tytuly VALUES('T12','Spontaniczny, ale nie dokuczliwy','biografia','W01',
  507,12.99,100001,DATE '2000-08-31',1);
INSERT INTO tytuly VALUES('T13','Zastosowania cywilne','historia','W03',
  802,29.99,10467,DATE '1999-05-31',1);

INSERT INTO autorzy_tytulow VALUES('T01','A01',1,1.0);
INSERT INTO autorzy_tytulow VALUES('T02','A01',1,1.0);
INSERT INTO autorzy_tytulow VALUES('T03','A05',1,1.0);
INSERT INTO autorzy_tytulow VALUES('T04','A03',1,0.6);
INSERT INTO autorzy_tytulow VALUES('T04','A04',2,0.4);
INSERT INTO autorzy_tytulow VALUES('T05','A04',1,1.0);
INSERT INTO autorzy_tytulow VALUES('T06','A02',1,1.0);
INSERT INTO autorzy_tytulow VALUES('T07','A02',1,0.5);
INSERT INTO autorzy_tytulow VALUES('T07','A04',2,0.5);
INSERT INTO autorzy_tytulow VALUES('T08','A06',1,1.0);
INSERT INTO autorzy_tytulow VALUES('T09','A06',1,1.0);
INSERT INTO autorzy_tytulow VALUES('T10','A02',1,1.0);
INSERT INTO autorzy_tytulow VALUES('T11','A03',2,0.3);
INSERT INTO autorzy_tytulow VALUES('T11','A04',3,0.3);
INSERT INTO autorzy_tytulow VALUES('T11','A06',1,0.4);
INSERT INTO autorzy_tytulow VALUES('T12','A02',1,1.0);
INSERT INTO autorzy_tytulow VALUES('T13','A01',1,1.0);

INSERT INTO tantiemy VALUES('T01',10000,0.05);
INSERT INTO tantiemy VALUES('T02',1000,0.06);
INSERT INTO tantiemy VALUES('T03',15000,0.07);
INSERT INTO tantiemy VALUES('T04',20000,0.08);
INSERT INTO tantiemy VALUES('T05',100000,0.09);
INSERT INTO tantiemy VALUES('T06',20000,0.08);
INSERT INTO tantiemy VALUES('T07',1000000,0.11);
INSERT INTO tantiemy VALUES('T08',0,0.04);
INSERT INTO tantiemy VALUES('T09',0,0.05);
INSERT INTO tantiemy VALUES('T10',NULL,NULL);
INSERT INTO tantiemy VALUES('T11',100000,0.07);
INSERT INTO tantiemy VALUES('T12',50000,0.09);
INSERT INTO tantiemy VALUES('T13',20000,0.06);