CREATE TABLE tytuly
  (
  id_tytulu   CHAR(3)      NOT NULL,
  tytul       VARCHAR(40)  NOT NULL,
  rodzaj      VARCHAR(12)  NULL
    CONSTRAINT rodzaj_wer
      CHECK (rodzaj IN ('biografia',
        'dzieci','komputery',
        'historia','psychologia'))  ,
  id_wyd      CHAR(3)      NOT NULL,
  stron       INTEGER      NULL
    CHECK (stron > 0)             ,
  cena        DECIMAL(5,2) NULL    ,
  sprzedanych INTEGER      NULL    ,
  data_wyd    DATE         NULL    ,
  kontrakt    SMALLINT     NOT NULL,
  CONSTRAINT tytuly_kg
    PRIMARY KEY (id_tytulu),
  CONSTRAINT tytuly_id_wyd_ko
    FOREIGN KEY (id_wyd)
    REFERENCES wydawcy(id_wyd),
  CONSTRAINT id_tytulu_wer
    CHECK (
    (SUBSTRING(id_tytulu FROM 1 FOR 1) = 'T')
    AND
    (CAST(SUBSTRING(id_tytulu FROM 2 FOR 2)
    AS INTEGER) BETWEEN 0 AND 99)),
  CONSTRAINT cena_wer
    CHECK (cena >= 0.00
      AND cena < 100.00),
  CONSTRAINT sprzedanych_wer
    CHECK (sprzedanych >= 0),
  CONSTRAINT data_wyd_wer
    CHECK (data_wyd >= DATE '1950-01-01'),
  CONSTRAINT tytul_kontrakt_wer
    CHECK (tytul <> ''
      AND kontrakt >= 0),
  CONSTRAINT dochod_wer
    CHECK (cena * sprzedanych >= 0.00)
  );