SELECT
    t.id_wyd,
    ta.id_au,
    COUNT(*) AS "Lb ksiazek",
    SUM(t.sprzedanych * t.cena * n.stawka * ta.procent_tantiem) AS "Calkowite tantiemy au",
    SUM(n.zaliczka * ta.procent_tantiem) AS "Calkowite zaliczki au",
    SUM((t.sprzedanych * t.cena * n.stawka * ta.procent_tantiem) -
      (n.zaliczka * ta.procent_tantiem)) AS "Dla autora"
  FROM autorzy_tytulow ta
  INNER JOIN tytuly t
    ON t.id_tytulu = ta.id_tytulu
  INNER JOIN tantiemy n
    ON n.id_tytulu = t.id_tytulu
  INNER JOIN wydawcy w
    ON w.id_wyd = t.id_wyd
  WHERE t.sprzedanych IS NOT NULL
    AND w.kraj IN ('Polska')
  GROUP BY t.id_wyd, ta.id_au
  HAVING SUM((t.sprzedanych * t.cena * n.stawka * ta.procent_tantiem) -
      (n.zaliczka * ta.procent_tantiem)) > 0
  ORDER BY t.id_wyd ASC, ta.id_au ASC;