SELECT
    a.id_au,
    a.imie_au,
    a.nazwisko_au,
    t.tytul,
    (t.sprzedanych * t.cena * n.stawka * ta.procent_tantiem) -
      (n.zaliczka * ta.procent_tantiem) AS "Dla autora"
  FROM autorzy a
  INNER JOIN autorzy_tytulow ta
    ON a.id_au = ta.id_au
  INNER JOIN tytuly t
    ON t.id_tytulu = ta.id_tytulu
  INNER JOIN tantiemy n
    ON n.id_tytulu = t.id_tytulu
  WHERE t.sprzedanych IS NOT NULL
    AND (t.sprzedanych * t.cena * n.stawka * ta.procent_tantiem) -
      (n.zaliczka * ta.procent_tantiem) > 0
  ORDER BY a.id_au ASC, t.id_tytulu ASC;