SELECT
    ta.id_au,
    t.id_tytulu,
    t.id_wyd,
    t.sprzedanych * t.cena * n.stawka * ta.procent_tantiem AS "Czesc tantiem",
    n.zaliczka * ta.procent_tantiem AS "Czesc zaliczki",
    (t.sprzedanych * t.cena * n.stawka * ta.procent_tantiem) -
      (n.zaliczka * ta.procent_tantiem) AS "Dla autora"
  FROM autorzy_tytulow ta
  INNER JOIN tytuly t
    ON t.id_tytulu = ta.id_tytulu
  INNER JOIN tantiemy n
    ON n.id_tytulu = t.id_tytulu
  WHERE t.sprzedanych IS NOT NULL
  ORDER BY ta.id_au ASC, t.id_tytulu ASC;