SELECT
    CASE
      WHEN sprzedanych IS NULL
        THEN 'Nieznana'
      WHEN sprzedanych <= 1000
        THEN 'Mniej ni 1 000'
      WHEN sprzedanych <= 10000 
        THEN 'Pomiedzy 1 001 a 10 000'
      WHEN sprzedanych <= 100000
        THEN 'Pomiedzy 10 001 a 100 000'
      WHEN sprzedanych <= 1000000
        THEN 'Pomiedzy 100 001 a 1 000 000'
      ELSE 'Ponad 1 000 000'
    END
      AS "Kategoria sprzedazy",
    COUNT(*) AS "Liczba tytulow"
  FROM tytuly
  GROUP BY
    CASE
      WHEN sprzedanych IS NULL
        THEN 'Nieznana'
      WHEN sprzedanych <= 1000
        THEN 'Mniej ni 1 000'
      WHEN sprzedanych <= 10000 
        THEN 'Pomiedzy 1 001 a 10 000'
      WHEN sprzedanych <= 100000
        THEN 'Pomiedzy 10 001 a 100 000'
      WHEN sprzedanych <= 1000000
        THEN 'Pomiedzy 100 001 a 1 000 000'
      ELSE 'Ponad 1 000 000'
    END
  ORDER BY MIN(sprzedanych) ASC;