--utworzenie indeksu online

CREATE INDEX ix_Table
ON Table (Column)
WITH (ONLINE = ON)




--utworzenie indeksu i zablokowanie blokad na wierszach

CREATE INDEX ix_Table
ON Table (Column)
WITH (ALLOW_ROW_LOCKS = OFF)




--utworzenie indeksu i zablokowanie blokad na stronach

CREATE INDEX ix_Table
ON Table (Column)
WITH (ALLOW_PAGE_LOCKS = OFF)




--utworzenie indeksu online i zablokowanie blokad na stronach i wierszach

CREATE INDEX ix_Table
ON Table (Column)
WITH (ONLINE = ON, ALLOW_ROW_LOCKS = OFF, ALLOW_PAGE_LOCKS = OFF)




--utworzenie tabeli testowej dla indeksw

CREATE TABLE DatabaseSystems
(
  DatabaseSystemId INT,
  Name VARCHAR(35),
  IsRelational CHAR(1),
  IsObjectOriented CHAR(1),
  SupportsXML CHAR(1),
  FullSpecifications VARCHAR(MAX)
)

CREATE NONCLUSTERED INDEX IX_Name
ON DatabaseSystems (Name)





--zapytanie testowe dla planu wykonania


SELECT Name, SupportsXML
FROM DatabaseSystems
WHERE Name LIKE S%
AND SupportsXML = Y




--typowy indeks pokrywajcy

DROP INDEX IX_Name
CREATE NONCLUSTERED INDEX IX_Name_SupportsXML
ON DatabaseSystems(Name, SupportsXML)




--indeks zawierajcy jedn kolumn niekluczow

CREATE UNIQUE NONCLUSTERED INDEX IX_Name
ON DatabaseSystems(Name)
INCLUDE (SupportsXML)




--indeks zawierajcy dwie kolumny niekluczowe

CREATE UNIQUE NONCLUSTERED INDEX IX_Name
ON DatabaseSystems(Name)
INCLUDE (SupportsXML, FullSpecifications)





--wyszukiwanie pofragmentowanych indeksw

SELECT
  OBJECT_NAME(i.object_id) AS TableName, 
  i.name AS IndexName,
  ips.avg_fragmentation_in_percent
FROM sys.dm_db_index_physical_stats(DB_ID(), NULL, NULL, NULL, 'DETAILED') ips
JOIN sys.indexes i ON 
  i.object_id = ips.object_id 
  AND i.index_id = ips.index_id
WHERE ips.avg_fragmentation_in_percent > 10




--defragmentacja indeksu

ALTER INDEX IX_CustomerName
ON Customers
REORGANIZE





--przebudowa indeksu

ALTER INDEX IX_CustomerName
ON Customers
REBUILD
WITH (ONLINE=ON)





--zablokowanie indeksu

ALTER INDEX IX_CustomerName
ON Customers
DISABLE





--odblokowanie indeksu

ALTER INDEX IX_CustomerName
ON Customers
REBUILD





