using System;
using System.Data;
using System.Data.Sql;
using Microsoft.SqlServer.Server;
using System.Data.SqlClient;

public partial class Triggers
{
    // wpisz nazw istniejcej docelowej tabeli lub widoku i odkomentuj wiersz atrybutu
    [Microsoft.SqlServer.Server.SqlTrigger(
        Name = "ValidateYear",
        Target = "HumanResources.Department",
        Event = "FOR INSERT")]
    public static void ValidateYear()
    {
        SqlConnection conn = new SqlConnection("context connection=true");

        // zdefiniowanie zapytania
        string sql =
            "SELECT COUNT(*) " +
            "FROM INSERTED " +
            "WHERE YEAR(ModifiedDate) <> 2005";

        SqlCommand comm = new SqlCommand(sql, conn);

        // otwarcie poczenia
        conn.Open();

        // odczytanie liczby nieprawidowych wierszy
        int numBadRows = (int)comm.ExecuteScalar();

        if (numBadRows > 0)
        {
            // pobranie SqlPipe
            SqlPipe pipe = SqlContext.Pipe;

            // wycofanie transakcji i wygenerowanie bdu
            comm.CommandText = "RAISERROR('Data ModifiedDate musi nalee do roku 2005', 11, 1)";

            // wysanie bdu
            try
            {
                pipe.ExecuteAndSend(comm);
            }
            catch
            {
                // brak czynnoci
            }

            System.Transactions.Transaction.Current.Rollback();
        }

        // zamknicie poczenia
        conn.Close();
    }
}
