--wczenie poziomu SNAPSHOT

ALTER DATABASE Sales
SET ALLOW_SNAPSHOT_ISOLATION ON




--wczenie poziomu READ COMMITTED SNAPSHOT

ALTER DATABASE Sales
SET READ_COMMITTED_SNAPSHOT ON




--zablokowanie poziomu izolacji SNAPSHOT

ALTER DATABASE Sales
SET ALLOW_SNAPSHOT_ISOLATION OFF




--odczytanie baz danych z wczonym poziomem izolacji SNAPSHOT

SELECT
    name,
  snapshot_isolation_state,
  is_read_committed_snapshot_on
FROM sys.databases





--utworzenie tabeli do przetestowania poziomu SNAPSHOT

CREATE TABLE TestSnapshot
(
  ColA INT,
  ColB VARCHAR(20)
)

INSERT TestSnapshot (ColA, ColB)
VALUES (1, 'Warto pocztkowa')





--rozpoczcie transakcji SNAPSHOT w jednym poczeniu

SET TRANSACTION ISOLATION LEVEL SNAPSHOT

BEGIN TRANSACTION

SELECT ColB
FROM TestSnapshot
WHERE ColA = 1





--UPDATE w innym poczeniu

UPDATE TestSnapshot
SET ColB = 'Nowa warto'
WHERE ColA = 1





--wczytanie danych do tabeli temp w transakcji SNAPSHOT

SET TRANSACTION ISOLATION LEVEL SNAPSHOT

BEGIN TRANSACTION

SELECT ColB
INTO #Temp
FROM TestSnapshot
WHERE ColA = 1




--uaktualnienie tabeli po SELECT w innym poczeniu

UPDATE TestSnapshot
SET ColB = 'Nowa warto'
WHERE ColA = 1





--powrt do pierwszego poczenia, wystpienie bdu

UPDATE TestSnapshot
SET ColB = 'Jeszcze nowsza warto'
WHERE ColA = 1





