--utworzenie funkcji partycjonowania

CREATE PARTITION FUNCTION pf_FiscalQuarter2005 (DATETIME)
AS RANGE RIGHT FOR VALUES
('20050401', '20050701', '20051001', '20060101')





--utworzenie schematu partycjonowania, odwzorowanie wszystkich partycji na PRIMARY

CREATE PARTITION SCHEME ps_FiscalQuarter2005_PRIMARY
AS PARTITION pf_FiscalQuarter2005
ALL TO ([PRIMARY])





--kolejny schemat partycjonowania, odwzorowanie partycji na rne grupy plikw

CREATE PARTITION SCHEME ps_FiscalQuarter2005_Split
AS PARTITION pf_FiscalQuarter2005
TO (Q1Q2_2005, Q1Q2_2005, Q3Q4_2005, Q3Q4_2005, Q3Q4_2005)





--utworzenie tabeli partycjonowanej

CREATE TABLE SalesAmounts
(
  SalesAmountId INT NOT NULL PRIMARY KEY NONCLUSTERED,
  SalesAmount NUMERIC(9,2) NOT NULL,
  SalesDate DATETIME NOT NULL
)
GO

CREATE CLUSTERED INDEX IX_SalesAmounts_SalesDate
ON SalesAmounts (SalesDate)
  ON ps_FiscalQuarter2005_Split (SalesDate)





--utworzenie indeksu partycjonowanego

CREATE INDEX IX_Amount
ON SalesAmounts
(
  SalesAmount
)
ON ps_FiscalQuarter2005_PRIMARY (SalesDate)





--utworzenie tabeli Visitors

CREATE TABLE Visitors
(
  VisitorId INT NOT NULL,
  VisitDate DATETIME NOT NULL,
  CONSTRAINT PK_Visitors
    PRIMARY KEY (VisitorId, VisitDate)
)





--modyfikacja schematu partycjonowania na tabeli Visitors

SET XACT_ABORT ON

BEGIN TRANSACTION
  ALTER TABLE Visitors
  DROP CONSTRAINT PK_Visitors

  ALTER TABLE Visitors
  ADD CONSTRAINT PK_Visitors
    PRIMARY KEY (VisitorId, VisitDate)
  ON ps_FiscalQuarter2005_Split (VisitDate)
COMMIT





--zczenie zakresu partycji

ALTER PARTITION FUNCTION
pf_FiscalQuarter2005()
MERGE RANGE ('20051001') 





--zmiana schematu partycjonowania

ALTER PARTITION SCHEME ps_FiscalQuarter2005_Split
NEXT USED [PRIMARY]





--zmiana funkcji partycjonowania

ALTER PARTITION FUNCTION
pf_FiscalQuarter2005()
SPLIT RANGE ('20070101')





--utworzenie tabeli VisitorStaging_2006

CREATE TABLE VisitorStaging_2006
(
  VisitorId INT NOT NULL,
  VisitDate DATETIME NOT NULL
)




--tabela musi mie taki sam PK jak tabela partycjonowana

ALTER TABLE VisitorStaging_2006
ADD CONSTRAINT PK_Visitors_2006
  PRIMARY KEY (VisitorId, VisitDate)





--trzeba rwnie utworzy CHECK, aby zapobiec wstawieniu nieprawidowych danych

ALTER TABLE VisitorStaging_2006
ADD CONSTRAINT CK_Visitors_06012006_12012007
  CHECK (VisitDate >= '20060101' AND VisitDate < '20070101')





--odszukanie nastpnej wartoci granicznej

SELECT rv.boundary_id
FROM sys.partition_functions f
JOIN sys.partition_range_values rv ON f.function_id = rv.function_id
WHERE rv.value = CONVERT(datetime, '20070101')
  AND f.name = 'pf_FiscalQuarter2005'




--przeczenie w nowej partycji

ALTER TABLE VisitorStaging_2006
SWITCH TO Visitors PARTITION 4




--wyczenie partycji

ALTER TABLE Visitors
SWITCH PARTITION 4 TO VisitorStaging_2006





--przebudowa tylko jednej partycji

ALTER INDEX PK_Visitors
ON Visitors
REBUILD
PARTITION = 4

