/* */
Exec sp_addtype postal_code_datatype, 'char(10)'

/* */
Exec sp_addtype state_code_type, 'char(2)', 'not null'
Go

/* */
Create Table mytable2 (col1 state_code_type)

/* */
Use pubs
Go
Exec sp_addtype my_uddt_type, 'money'
Go
CREATE DEFAULT intdefault as 0
Go
CREATE DEFAULT char5default as 'Hello'
Go
CREATE DEFAULT moneydefault as $10.00
Go
CREATE TABLE mytab
(intcol int not null,
 char5col char(5) not null,
 uddtcol my_uddt_type not null)
Go

/* */
Exec sp_bindefault moneydefault, 'my_uddt_type'
Exec sp_bindefault intdefault, 'mytab.intcol'
Exec sp_bindefault char5default, 'mytab.char5col'
Go

/* */
INSERT mytab DEFAULT VALUES
Go
SELECT * FROM mytab
Go

/* */
CREATE RULE myrule AS @myvar like 'p%' OR @myvar like 't%'

/* */
create table testtab (c1 char(10) not null)
go
exec sp_bindrule 'myrule','testtab.c1'
go
insert testtab values ('hello')

/* */
CREATE RULE char5rule AS @col LIKE 'h%'
Go
CREATE RULE intrule AS @intval < 100
Go
CREATE RULE moneyrule AS @moneyval BETWEEN $5.00 AND $10.00
Go
Exec sp_bindrule 'char5rule', 'mytab.char5col'
Exec sp_bindrule 'intrule', 'mytab.intcol'
Exec sp_bindrule 'moneyrule', 'my_uddt_type'
Go

/* */
INSERT mytab VALUES (90,'Howdy',$6.00)
Go

/* */
INSERT mytab DEFAULT VALUES
Go

/* */
INSERT mytab VALUES (101,'Ralph',$20.00)
Go

/* */
CREATE TABLE mytable5
(col1 int not null IDENTITY(1,100),
 col2 char(5) not null)

/* */
CREATE TABLE myidenttab
(col1 int not null IDENTITY(1,100),
 col2 char(5) not null)
Go
INSERT myidenttab (col2) VALUES ('howdy')
    SELECT @@identity


/* */
INSERT myidenttab(col2) VALUES ('Movie')
SELECT @@identity

/* */
DELETE myidenttab
Go
INSERT myidenttab (col2) VALUES ('Zebra')
SELECT @@identity

/* */
TRUNCATE TABLE myidenttab
Go
INSERT myidenttab (col2) VALUES ('howdy')
SELECT @@identity

/* */
Create table triggertab (col1 int not null identity(1,1), col2 char(5) null)
Create table othertab (cola int not null identity(100,1))
go
Create trigger mytrigger on triggertab for insert as
Insert othertab DEFAULT VALUES
go
insert triggertab (col2) values ('howdy')
select @@identity
select scope_identity()

/* */
SET identity_insert myidenttab ON
Go
INSERT myidenttab (col1, col2) VALUES (2,'jolly')
Go
SET identity_insert myidenttab OFF
Go
SELECT * FROM myidenttab


/* */
CREATE TABLE mytablea
(col1 int not null CONSTRAINT DF_a_col1 DEFAULT (0))

/* */
CREATE TABLE mytableb
(col1 int not null)
ALTER TABLE mytableb ADD
CONSTRAINT DF_b_col1 DEFAULT (0) FOR col1


/* */
CREATE TABLE defaulttab1
( intcol int NOT NULL CONSTRAINT df_intcol DEFAULT 0,
  char5col char(5) NOT NULL DEFAULT 'Hello',
  anumber numeric(10,0) NOT NULL
)
Go

/* */
ALTER TABLE defaulttab1
ADD moneycol money NULL CONSTRAINT df_moneycol DEFAULT $2.00,
CONSTRAINT df_anumber DEFAULT 100 FOR anumber
Go

/* */
exec sp_help defaulttab1 

/* */
CREATE TABLE checktable
(col1 int not null CONSTRAINT ck_col1
     CHECK (col1 between 1 and 100),
 col2 char(5) null,
 zip_code char(5) null,
 col4 int not null,
 CONSTRAINT ck_col4 CHECK (col4 > col1),
 CONSTRAINT ck_zip_code CHECK
(zip_code like '[0-9][0-9][0-9][0-9][0-9]')
)

ALTER TABLE checktable
ADD CONSTRAINT ck_col2 CHECK (col2 like 'H%')
Go

/* */
INSERT checktable VALUES (1,'Howdy','99901',2)

/* */
INSERT checktable VALUES (2,'Howdy','8834A',3)

/* */
CREATE TABLE pktable
(col1 int not null CONSTRAINT pk_col1 PRIMARY KEY,
 col2 char(5) null
)

/* */
CREATE TABLE pktable2
(col1 int not null CONSTRAINT pk2_col1
     PRIMARY KEY nonclustered (col1),
 col2 char(5) null
)

/* */
CREATE TABLE pktable3
(col1 int not null,
 col2 char(2) not null,
 col3 int null,
 CONSTRAINT pk3_col1col2 PRIMARY KEY (col1, col2)
)

/* */
drop index pktable3.pk3_col1col2

/* */
CREATE TABLE myuniquetable
(col1 int not null CONSTRAINT pk_myuniquetable PRIMARY KEY,
 col2 char(20) NOT NULL CONSTRAINT u_myuniquetable UNIQUE
)


/* */
CREATE TABLE emp
(emp_id int not null CONSTRAINT pk_emp PRIMARY KEY,
 emp_name char(30) not null)
Go
CREATE TABLE orders
(order_id int not null CONSTRAINT pk_order PRIMARY KEY,
 emp_id int not null CONSTRAINT fk_order
FOREIGN KEY (emp_id) REFERENCES emp (emp_id)ON DELETE NO ACTION ON UPDATE NO ACTION
)
Go
INSERT emp VALUES (1,'Joe Smith')
INSERT emp VALUES (2,'Ann Jones')
INSERT orders VALUES (1,1)
INSERT orders VALUES (2,2)
Go

/* */
INSERT orders VALUES (3,3)
Go

/* */
DELETE emp WHERE emp_id = 1
Go

/* */
CREATE TABLE emp_manager
(emp_id int not null CONSTRAINT pk_emp_mgr PRIMARY KEY,
 mgr_id int not null CONSTRAINT fk_emp_mgr FOREIGN KEY
REFERENCES emp_manager (emp_id),
  emp_name char(30) not null)

/* */
INSERT emp_manager VALUES (1,1,'Ann Jones')
INSERT emp_manager VALUES (2,1,'Tom Smith')

/* */
INSERT emp_manager VALUES (3,4,'Bob Newett')

/* */
CREATE TABLE order_detail
(order_id int not null CONSTRAINT pk_order_detail PRIMARY KEY (order_id, line_no),
 line_no int not null,
 part_no int not null,
 price money not null,
CONSTRAINT fk_order_detail FOREIGN KEY (order_id) REFERENCES orders (order_id) ON DELETE CASCADE ON UPDATE CASCADE
)
-- Load some data into the table
INSERT order_detail VALUES (1,1,1,$5.00)
INSERT order_detail VALUES (1,2,2,$15.00)
INSERT order_detail VALUES (1,3,9,$2.95)
INSERT order_detail VALUES (2,1,1,$5.00)
INSERT order_detail VALUES (2,2,8,$8.00)
INSERT order_detail VALUES (2,3,4,$29.00)
-- Now delete order number 2.
DELETE orders where order_id = 2
--select * from order_detail to verify the rows for order #2 were deleted
select * from order_detail

-- Now update order #1 to be order #5 and watch it cascade to order_detail
update orders set order_id = 5 where order_id = 1
--select * from order_detail to verify the rows for order #1 were updated to be order #5
select * from order_detail

/* */
ALTER TABLE emp_manager DROP CONSTRAINT fk_emp_mgr

/* */
ALTER TABLE emp_manager DROP CONSTRAINT pk_emp_mgr

/* */
exec sp_help constrainttab

/* */
CREATE TABLE mytesttable
(col1 char(5) not null
)
Go
INSERT mytesttable VALUES ('Howdy')
INSERT mytesttable VALUES ('Grant')

/* */
ALTER TABLE mytesttable
ADD CONSTRAINT ck_mytest CHECK (col1 like 'h%')

/* */
ALTER TABLE mytesttable
WITH NOCHECK
ADD CONSTRAINT ck_mytest CHECK (col1 like 'h%')

/* */
ALTER TABLE mytesttable
NOCHECK CONSTRAINT ALL

/* */
ALTER TABLE mytesttable
CHECK CONSTRAINT ALL
