/* */
USE PUBS
-- CREATE THE TABLE
CREATE TABLE dbo.myauthors (
    au_id id NOT NULL ,
    au_lname varchar (40) NOT NULL ,
    au_fname varchar (20) NOT NULL ,
    phone char (12) NOT NULL ,
    address varchar (40) NULL ,
    city varchar (20) NULL ,
    state char (2) NULL ,
    zip char (5) NULL ,
    contract bit NOT NULL)
-- Copy the data from the authors table into myauthors
INSERT myauthors select * from authors
-- create the unique clustered index on the myauthors table
Create unique clustered index myauind on myauthors (au_id)

/* */
Use pubs
Create index mynamindex on myauthors (au_fname DESC)

/* */
Use pubs
Create nonclustered index mynameindex on myauthors (au_fname)


/* */
EXEC sp_configure
GO

/* */
CREATE INDEX aunameindex on authors (au_fname)
WITH FILLFACTOR = 50
GO

/* */
DROP INDEX authors.aunameindex
GO
CREATE INDEX aunameindex on authors (au_fname)
WITH FILLFACTOR = 50, PAD_INDEX
GO

/* */
create table t1 (col1 int not null, col2 char(5) not null)
go
create unique clustered index myind on t1 (col1) with ignore_dup_key
go
create table t2 (col1 int not null, col2 char(5) not null)
go
insert t2 values (1, 'abcde')
insert t2 values (2, 'abcde')
insert t2 values (2, 'abcde')
insert t2 values (3, 'abcde')

insert t1 select * from t2


/* */
SELECT au_id, au_fname, au_lname
FROM pubs..authors
WHERE state = 'CA'
GO

/* */
SELECT au_id, au_fname, au_lname
FROM pubs..authors
WHERE au_id = '341-22-1782'

/* */
USE PUBS
    CREATE TABLE PUBS..INDEXTAB
    (col1 int not null,
     col2 varchar(250) not null,
     col3 varchar(250) not null,
     col4 varchar(250) not null,
     col5 varchar(250) not null)

    insert indextab values (1,'adam','col3','col4','col5')
    insert indextab values (2,'bob','col3','col4','col5')
    insert indextab values (3,'charles','col3','col4','col5')
    insert indextab values (4,'david','col3','col4','col5')
    insert indextab values (5,'edward','col3','col4','col5')
    insert indextab values (6,'frank','col3','col4','col5')
    insert indextab values (7,'george','col3','col4','col5')
    insert indextab values (8,'hank','col3','col4','col5')
    insert indextab values (9,'ida','col3','col4','col5')
    insert indextab values (10,'john','col3','col4','col5')
    insert indextab values (11,'kim','col3','col4','col5')
    insert indextab values (12,'loni','col3','col4','col5')
    insert indextab values (13,'mike','col3','col4','col5')
    insert indextab values (14,'nikki','col3','col4','col5')
    insert indextab values (15,'oprah','col3','col4','col5')
    insert indextab values (16,'paul','col3','col4','col5')
    insert indextab values (17,'quan','col3','col4','col5')
    insert indextab values (18,'richard','col3','col4','col5')
    insert indextab values (19,'sam','col3','col4','col5')
    insert indextab values (20,'tom','col3','col4','col5')
    insert indextab values (21,'uma','col3','col4','col5')
    insert indextab values (22,'vera','col3','col4','col5')
    insert indextab values (23,'walter','col3','col4','col5')
    insert indextab values (24,'xray','col3','col4','col5')
    insert indextab values (25,'yuma','col3','col4','col5')
    insert indextab values (26,'zane','col3','col4','col5')
    insert indextab values (27,'ann','col3','col4','col5')
    insert indextab values (28,'bill','col3','col4','col5')
    insert indextab values (29,'cathy','col3','col4','col5')
    insert indextab values (30,'dawn','col3','col4','col5')
    insert indextab values (31,'ellen','col3','col4','col5')
    insert indextab values (32,'fran','col3','col4','col5')
    insert indextab values (33,'grant','col3','col4','col5')
    insert indextab values (34,'helen','col3','col4','col5')
    insert indextab values (35,'irwin','col3','col4','col5')
    insert indextab values (36,'jack','col3','col4','col5')
    insert indextab values (37,'kathy','col3','col4','col5')
    insert indextab values (38,'lance','col3','col4','col5')
    insert indextab values (39,'molly','col3','col4','col5')
    insert indextab values (40,'nancy','col3','col4','col5')
    CREATE CLUSTERED INDEX CL_MYINDEX on indextab (col1)

/* */
USE PUBS
GO
SET SHOWPLAN_TEXT ON
GO
select col1, col2 from indextab
where col2 = 'ann'
GO

SET SHOWPLAN_TEXT OFF
GO

/* */
USE PUBS
GO
SET SHOWPLAN_ALL ON
GO
select col1, col2 from indextab
where col2 = 'ann'

/* */
set showplan_all off -- or turn off any other showplan options first
GO
exec sp_helpindex indextab
GO


CREATE INDEX NONCL_MYINDEX on indextab (col2)
GO
SET SHOWPLAN_TEXT ON
GO
select col1, col2 from indextab
where col2 = 'ann'
GO

/* */
SET STATISTICS IO ON
GO
SELECT col1,col2
FROM indextab
where col1 < 3
GO


/* */
SET STATISTICS IO OFF
GO

/* */
SELECT col1, col2
FROM indextab (index = noncl_myindex)

/* */
SELECT col1, col2
FROM indextab (INDEX = 3)

/* */
SET SHOWPLAN_TEXT ON
GO
SELECT col1, col2
FROM indextab (INDEX = 0)
WHERE col1 < 3

/* */
set showplan_text off
go
drop index indextab.cL_MYINDEX
GO
SET SHOWPLAN_TEXT ON
GO
SELECT col1, col2
FROM indextab (INDEX = 0)
WHERE col1 < 3


/* */
UPDATE STATISTICS authors

/* */
use pubs
exec sp_autostats 'authors','Off'

/* */
UPDATE STATISTICS authors (city) WITH COLUMNS

/* */
Use pubs
Go
Declare @tabid int
Declare @indid int
Select @tabid = object_id ('indextab')
Select @indid = 2 /* the non-clustered index */
SELECT STATS_DATE (@tabid, @indid)

/* */
USE PUBS
DBCC SHOWCONTIG ('indextab')
GO

/* */
USE PUBS
DBCC SHOWCONTIG ('indextab') with tableresults
GO

/* */
DBCC DBREINDEX ('authors','', 0)
GO

/* */
DBCC DBREINDEX ('indextab')
GO

/* */
CREATE INDEX noncl_col2_indextab on indextab (col4)
GO
DBCC DBREINDEX ('indextab','noncl_col2_indextab')

/* */
Create view myauthorview
With schemabinding
As
Select a.au_lname, a.au_fname, t.title, ta.royaltyper
From dbo.authors a inner join dbo.titleauthor ta on a.au_id = ta.au_id inner join dbo.titles t on t.title_id = ta.title_id

/* */
select * from myauthorview

/* */
select * from myauthorview (NOEXPAND)


/* */
select pub_id, substring(pr_info,1,100) from pub_info
where CONTAINS (pr_info, 'sample')
