/* */
USE PUBS
SELECT au_id, au_lname FROM authors
SELECT pub_id, pub_name FROM publishers
INSERT publishers VALUES ('9998','SAMS Publishing', 'Seattle', 'WA','USA')
GO

/* */
USE PUBS
SELECT au_id, au_lname FROM authors
SELECT pub_id, pub_name FROM publishers
INSERT publishers VALUES ('9997','SAMS Publishing', 'Seattle', 'WA','USA')
GO

SELECT * FROM stores
GO

DELETE publishers WHERE pub_id = '9997'
GO

/* */
BEGIN TRAN
UPDATE authors
SET city= 'San Jose' WHERE au_lname = 'Smith'
INSERT titles
VALUES ('BU1122', 'Teach Yourself SQL Server 2000 in 21 days', 'business','9998'. $35.00, $1000.00, 10,4501, 'A great book!', '8/1/2000')

SELECT * from titleauthor

COMMIT TRAN

/* */
BEGIN TRAN
	Delete sales where title_id = 'BU1032'
	IF @@ERROR >0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN

/* */
BEGIN TRAN
	UPDATE table1 SET col1 = 5 WHERE col2 = 14
	SAVE TRAN savepoint1
	INSERT table2 values (3,16)
	IF @@error > 0
	ROLLBACK TRAN savepoint1
	DELETE table3 WHERE col1 > 2
IF @@eerror > 0
	ROLLBACK TRAN
	ELSE
		COMMIT TRAN

/* */
SELECT @@TRANCOUNT -- It should return 0.
BEGIN TRAN t1
SELECT @@TRANCOUNT -- It should return 1. 
SAVE TRAN savepoint1
SELECT @@TRANCOUNT -- It still is set to 1.
ROLLBACK TRAN savepoint1
SELECT @@TRANCOUNT -- It still is set to 1.
BEGIN TRAN t2
SELECT @@TRANCOUNT -- It should return 2.
ROLLBACK TRAN
SELECT @@TRANCOUNT - It's back to 0.


BEGIN TRANSACTION
UPDATE table1 SET col1 = 5 WHERE col1 = 1
DELETE table1 WHERE col1 = 5
EXEC server2.pubs..usp_insertpublisher parm1 parm2 parm3
COMMIT TRAN

/* */
EXEC sp_configure "REMOTE_PROC_TRANSACTIONS", 1
RECONFIGURE WITH OVERRIDE

/* */
INSERT table1 values (1,'abcde')
UPDATE table1 SET col1 = 5 WHERE col1 = 1
DELETE FROM table1 WHERE col1 = 5
GO

/* */
BEGIN TRAN
INSERT table1 VALUES (1,'abcde')
UPDATE table1 SET col1 = 5 WHERE col1 = 1
DELETE FROM table1 WHERE col1 = 5
COMMIT TRAN

/* */
CREATE TABLE table1 (col1 int not null)
BEGIN TRAN
INSERT table1 VALUES (1)
SELECT @@trancount
COMMIT TRAN

SET IMPLICIT_TRANSACTIONS ON
INSERT table1 values (2)
SELECT @@trancount
COMMIT TRAN

/* */
BEGIN TRAN
INSERT table1 VALUES (1,'abcde')
UPDATE table1 SET col1 = 5 WHERE col1 = 1
DELETE FROM table1 WHERE col1 = 5
COMMIT TRAN

/* */
BEGIN DISTRIBUTED TRANSACTION
UPDATE table1 SET col1= 5 WHERE col1 = 1
DELETE table1 WHERE col1 = 5
EXEC server2.pubs..usp_insertpublisher parm1 parm2 parm3
COMMIT TRAN

/* */
BEGIN DISTRIBUTED TRANSACTION
INSERT remoteserver.pubs..remotetable(col1, col2) VALUES (1,2)
UPDATE localtab SET col2= 5 WHERE col1 = 1
COMMIT TRAN

/* */
Select t1.title, t2.pub_name
From pubs..titles t1 -This is the local table
Inner Join remoteserver.pubs..publishers t2 -This is the remote table
ON t1.pub_id = t2.pub_id

/* */
PRINT "Hello"
PRINT @@version

/* */
USE pubs
DECLARE @msg varchar(50),
@numWA tinyint
SELECT @numWA = COUNT(*) FROM stores
WHERE state = 'WA'
SELECT @msg = 'There are ' + convert(varchar(3), @numWA) +
' stores in Washington'

PRINT @msg

/* */
IF (datename(dw, getdate()) = 'Friday')
	BEGIN
	PRINT 'Weekly raport'
	EXEC uspWeeklyReport
	END
ELSE
	BEGIN
	PRINT 'Daily Report'
	EXEC uspDailyReport
	END

/* */
IF (SELECT avg(price) FROM titles) > $15
    PRINT 'Hold a big sale'
ELSE
    PRINT 'Time to raise prices'

/* */
IF EXISTS
(SELECT * FROM titles WHERE pub_id = '9933')
BEGIN
    PRINT 'Here are the books: '
    SELECT * FROM titles WHERE pub_id = '9933'
END
ELSE
    PRINT 'No books from that publisher'

/* */
IF NOT EXISTS
(SELECT * FROM titles WHERE pub_id = '9933')
BEGIN
    PRINT 'No books from that publisher'
    RETURN
END
ELSE
BEGIN
    PRINT 'Here are the books'
    SELECT * FROM titles WHERE pub_id = '9933'
END

/* */
SELECT title_id type = CASE type
    WHEN 'business' THEN 'Business Book'
    WHEN 'psychology' THEN 'Psychology Book'
    WHEN 'mod_cook' THEN 'Modern Cooking Book'
    WHEN 'trad_cook' THEN 'Traditional Cooking Book'
    WHEN 'popular_comp' THEN 'Popular Computing Book'
    WHEN 'undecided' THEN 'No type determined yet'
    END
FROM titles


/* */
SELECT title_id, cost = CASE
    WHEN price < 10 THEN 'Cheap'
    WHEN price BETWEEN 10 and 20 then 'Midrange'
    ELSE 'Expensive'
    END
FROM titles


/* */
SELECT title_id, type = case
    WHEN type = 'business' THEN 'Business Book'
    WHEN type = 'psychology' THEN 'Psychology Book'
    WHEN type = 'mod_cook' THEN 'Modern Cooking Book'
    WHEN type = 'trad_cook' THEN 'Traditional Cooking Book'
    WHEN type = 'popular_comp' THEN 'Popular Computing Book'
    ELSE 'No type determined yet'
    END
FROM titles


/* */
USE pubs
GO
CREATE TABLE tblWages (
intEmpID int NOT NULL,
curHourly money NULL,
curSalary money NULL,
curCommission money NULL,
bigNumSales bigint NULL)
GO
INSERT tblWages VALUES (111, NULL, 52000, NULL, NULL)
INSERT tblWages VALUES (112, 14, NULL, NULL, NULL)
INSERT tblWages VALUES (113, NULL, NULL, 0.15, 50000)
INSERT tblWages VALUES (114, NULL, 73000, NULL, NULL)
INSERT tblWAGES VALUES (115, 4.90, NULL, NULL, NULL)
INSERT tblWages VALUES (116, NULL, 28500, NULL, NULL)
GO

/* */
SELECT intEmpID as "Employee ID", "Total Salary" = Convert(money,
(COALESCE(curHourly * 40 * 52, curSalary, curCommission * bigNumSales)))
FROM tblWages

/* */
USE pubs
GO
UPDATE tblWages
	SET curHourly = ISNULL(curHourly, 0),
	curSalary = ISNULL(curSalary, 0),
	curCommission = ISNULL(curCommission, 0)
	bignumSales = ISNULL(bigNumSales, 0)

/* */
SELECT Hourly = COUNT(curHourly),
	Salary = COUNT(curSalary),
	Commission = COUNT(curCommission)
FROM tblWages

/* */
SELECT Hourly = COUNT(NULLIF(curHourly,0)),
	Salary = COUNT(NULLIF(curSalary,0)),
	Commission = COUNT(NULLIF(curCommission,0))
FROM tblWages

/* */
WHILE (SELECT AVG(price) FROM titles) < $20
BEGIN
    UPDATE titles SET price = price * 1.1
    PRINT 'all prices have been increased by 10%'
END

/* */
SELECT *
FROM authors (TABLOCKX)


/* */
EXEC sp_lock
GO

/* */ 
USE pubs
GO

CREATE TABLE tblChecking
(intAcctNum INT NOT NULL,
 strLastName CHAR(30) NOT NULL,
 curBalance MONEY NOT NULL
)
GO
CREATE TABLE tblSavings
(intAcctNum INT NOT NULL,
 strLastName CHAR(30) NOT NULL,
 curBalance MONEY NOT NULL
)
GO
INSERT tblChecking VALUES (1,'smith', $500.00)
INSERT tblChecking VALUES (2,'Jones', $300.00)
INSERT tblSavings VALUES (1,'smith', $100.00)
INSERT tblSavings VALUES (2,'Jones', $200.00)
GO


/* */
use pubs
GO
BEGIN TRAN
    UPDATE tblChecking
    SET curBalance = curBalance + $100.00
    WHERE intAcctNum = 1

/* */
USE pubs
GO
BEGIN TRAN
    UPDATE tblSavings
    SET curBalance = curBalance - $100.00
    WHERE intAcctNum = 2

/* */
UPDATE tblSavings
SET curBalance = curBalance - $100.00
WHERE intAcctNum = 1

/* */
UPDATE tblChecking
SET curBalance = curBalance + $100.00
WHERE intAcctNum = 2

/* */
COMMIT TRAN
GO
DROP TABLE tblChecking
DROP TABLE tblSavings
GO

/* */
DBCC USEROPTIONS
GO

/* */
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
GO
DBCC USEROPTIONS
GO