/* */
USE master
GO
CREATE DATABASE Frogger ON PRIMARY
( NAME = FroggerData,
  FILENAME = 
'D:\Program Files\Microsoft SQL Server\MSSQL\Data\FroggerData.mdf',
  SIZE = 20MB,
  MAXSIZE = 100MB,
  FILEGROWTH = 10MB  )
LOG ON
( NAME = FroggerLog,
  FILENAME = 
'D:\Program Files\Microsoft SQL Server\MSSQL\Data\FroggerLog.ldf',
  SIZE = 5MB,
  MAXSIZE = 15MB,
  FILEGROWTH = 1MB )
GO


/* */

USE master
GO
CREATE DATABASE Leap ON PRIMARY
( NAME = LeapData1,
  FILENAME = 
'D:\Program Files\Microsoft SQL Server\MSSQL\Data\LeapData1.mdf',
  SIZE = 5,
  MAXSIZE = 20,
  FILEGROWTH = 1 ),
( NAME = LeapData2,
  FILENAME = 
'D:\Program Files\Microsoft SQL Server\MSSQL\Data\LeapData2.ndf',
  SIZE = 5,
  MAXSIZE = 20,
  FILEGROWTH = 5 )
LOG ON
( NAME = LeapLog1,
  FILENAME = 
'D:\Program Files\Microsoft SQL Server\MSSQL\Data\LeapLog1.ldf',
  SIZE = 2,
  MAXSIZE = 20,
  FILEGROWTH = 1 ),
( NAME = LeapLog2,
  FILENAME = 
'D:\Program Files\Microsoft SQL Server\MSSQL\Data\LeapLog2.ldf',
  SIZE = 2,
  MAXSIZE = 10,
  FILEGROWTH = 2 )
GO

/* */

USE master
GO
CREATE DATABASE Swim ON PRIMARY
( NAME = SwimData,
  FILENAME = 
'D:\Program Files\Microsoft SQL Server\MSSQL\Data\SwimData.mdf',
  SIZE = 20MB,
  MAXSIZE = 100MB,
  FILEGROWTH = 10MB  )
LOG ON
( NAME = SwimLog,
  FILENAME = 
'D:\Program Files\Microsoft SQL Server\MSSQL\Data\SwimLog.ldf',
  SIZE = 5MB,
  MAXSIZE = 15MB,
  FILEGROWTH = 1MB )
COLLATE Latin1_General_CI_AI
GO

/* */

ALTER DATABASE croak
ADD FILE
( NAME = CroakData2,
  FILENAME = 
'D:\Program Files\Microsoft SQL Server\MSSQL\Data\CroakData2.ndf',
  SIZE = 2,
  MAXSIZE = 10,
  FILEGROWTH = 2)


/* */

ALTER DATABASE croak
ADD LOG FILE
( NAME = CroakLog2,
  FILENAME = 
'D:\Program Files\ Microsoft SQL Server\MSSQL\DATA\CroakLog2.ndf',
  SIZE = 2,
  MAXSIZE = 10,
  FILEGROWTH = 2)


/* */

USE frogger
GO
DBCC SHRINKFILE (FroggerData2,EMPTYFILE)
GO
ALTER DATABASE Frogger REMOVE FILE FroggerData2


/* */

USE master
GO
EXEC sp_dboption Frogger, 'Single User', True
EXEC sp_renamedb 'Frogger', 'TsingWa'
EXEC sp_dboption TsingWa, 'Single User', False
GO

/* */

ALTER DATABASE Leap
ADD FILEGROUP LeapGroup1
GO

/* */
use Leap
GO
EXEC sp_helpfilegroup

/* */

ALTER DATABASE Leap
ADD FILE
(Name = LeapDataG1,
 FILENAME = 
'D:\PROGRAM FILES\Microsoft SQL Server\MSSQL\DATA\LeapDataG1.ndf',
 SIZE = 2)
TO FILEGROUP LeapGroup1
GO

/* */

Use Leap
GO
ALTER DATABASE Leap
MODIFY FILEGROUP LeapGroup1 DEFAULT

/* */

USE pubs
GO
ALTER DATABASE Leap
ADD FILE
(NAME = LeapDataTest,
 FILENAME = 'D:\PROGRAM FILES\Microsoft SQL Server\MSSQL\DATA\LeapDataTest.ndf',
 SIZE = 2)
GO

/* */

USE Leap
GO

ALTER DATABASE Leap
MODIFY FILEGROUP [PRIMARY] DEFAULT
GO

ALTER DATABASE Leap
REMOVE FILE LeapDataG1
Go

ALTER DATABASE Leap
REMOVE FILE LeapDataTest
GO

ALTER DATABASE Leap
REMOVE FILEGROUP LeapGroup1
GO

/* */
USE MASTER
GO
DROP DATABASE TsingWa, Croak, Leap, Swim
GO


