/* */
CREATE VIEW dbo.vwAuthors AS
SELECT au_lname, au_fname FROM authors
WHERE au_lname LIKE 'M%'

/* */
CREATE VIEW vwAllAuthors
AS SELECT * FROM authors

/* */
SELECT * FROM vwAllAuthors

SELECT au_fname, au_lname
FROM vwAllAuthors

SELECT au_lname
FROM vwAllAuthors
WHERE au_lname like 'M%'

/* */
CREATE VIEW vwMyCheck
AS select * from authors
WITH CHECK OPTION
GO

CREATE VIEW vwMyEncrypt
WITH ENCRYPTION
AS select * from authors
GO

/* */
sp_helptext vwCheck

/* */
CREATE VIEW vwCheck AS
SELECT * FROM authors WITH CHECK OPTION

/* */
EXEC sp_depends vwCheck

/* */
CREATE VIEW vwMyView
AS SELECT au_lname, au_fname
FROM authors

/* */
SELECT * FROM vwMyView

/* */
CREATE VIEW vwAuthorsTitles
AS SELECT authors.au_lname, authors.au_fname, titles.title
FROM authors INNER JOIN titleauthor 
ON authors.au_id = titleauthor.au_id
INNER JOIN titles 
ON titles.title_id = titleauthor.title_id

/* */
SELECT * FROM vwAuthorsTitles
WHERE au_lname like 'M%'

/* */
CREATE VIEW vwBookTotals AS
SELECT title, (price * ytd_sales) 'Total'
FROM titles

/* */
Select * from vwBookTotals

/* */
DROP VIEW dbo.vwMyCheck

/* */
CREATE PROCEDURE pAuthors
AS SELECT au_fname, au_lname
FROM authors
ORDER BY au_lname DESC

/* */
EXEC pAuthors

/* */
EXEC sp_helptext pAuthors

/* */
EXEC sp_depends pAuthors

/* */
CREATE PROC group_sp;1
AS SELECT * FROM authors
GO
CREATE PROC group_sp;2
AS SELECT au_lname FROM authors
GO
CREATE PROC group_sp;3
AS SELECT DISTINCT city FROM authors
GO

/* */
EXEC group_sp;3

/* */
DROP PROCEDURE dbo.group_sp

/* */
CREATE PROCEDURE scores
@score1 smallint,
@score2 smallint,
@score3 smallint,
@score4 smallint,
@score5 smallint,
@myAvg smallint OUTPUT
AS SELECT @myAvg =
(@score1 + @score2 + @score3 + @score4 + @score5) / 5

/* */
DECLARE @AvgScore smallint
EXEC scores 10, 9, 8, 8, 10, @AvgScore OUTPUT
SELECT 'The Average Score is:  ', @AvgScore
GO

/* */
DECLARE @AvgScore smallint
EXEC scores
@score1 = 10, @score3 = 9,
@score2 = 8, @score4 = 8,
@score5 = 10, @myAvg = @AvgScore OUTPUT
SELECT 'The average score is:  ', @AvgScore
GO

/* */
CREATE PROC MyReturn
@t1 smallint, @t2 smallint, @retval smallint
AS SELECT @retval = @t1 + @t2
RETURN @retval

/* */
DECLARE @myReturnValue smallint
EXEC @myReturnValue = MyReturn 9, 9, 0
SELECT 'The return value is:  ', @myReturnValue

/* */
CREATE PROCEDURE MyRecompileProc
WITH RECOMPILE
AS SELECT * FROM authors
ORDER BY au_lname

/* */
EXEC pAuthors
WITH RECOMPILE

/* */
EXEC sp_recompile authors

/* */
CREATE PROC encrypted_proc
WITH ENCRYPTION
AS SELECT * FROM authors

/* */
USE pubs
GO
CREATE TRIGGER trAddAuthor
ON authors
FOR INSERT, UPDATE
AS raiserror ("'%d rows have been modified'", 0, 1, @@rowcount)
RETURN

/* */
USE pubs
GO
INSERT authors
(au_id, au_lname, au_fname, phone,
 address, city, state, zip, contract)
VALUES
('555-66-7777', 'Leap', 'Frog',
'800 444-5656', '123 Sesame Street',
'West EastBrooke', 'CA', '90221', 0)

/* */
INSERT authors
(au_id, au_lname, au_fname, phone, address, city, state, zip, contract)
VALUES 
('444-55-6666', 'Leap', 'Frog', '800 444-5656',
'123 Sesame Street', 'West EastBrooke', 'CA',
'90221', 0)

/* */
CREATE TRIGGER trDelAuthors
ON authors
FOR DELETE AS raiserror
("%d rows are going to be deleted from this table!",
0, 1, @@rowcount)

/* */
DELETE FROM authors
WHERE au_fname = "Leap"


/* */
EXEC sp_dboption pubs, 'Select Into', TRUE
GO
SELECT * INTO tblStores from pubs..stores
SELECT * INTO tblSales from pubs..sales

/* */
SELECT sa.stor_id, st.stor_name
FROM tblStores st, tblSales sa
WHERE st.stor_id = sa.stor_id

/* */
CREATE TRIGGER trDelSales
ON tblSales
FOR DELETE AS
raiserror('%d rows are going to be deleted from the sales table!',
 0, 1, @@rowcount)

/* */
CREATE TRIGGER trDelStore
ON tblStores
FOR DELETE AS
DELETE tblSales FROM deleted where deleted.stor_id =
tblSales.stor_id

/* */
DELETE FROM tblStores
WHERE tblStores.stor_id = '7067'

/* */
DROP TRIGGER trDelSales
GO
CREATE TRIGGER trDelSales
ON tblSales
FOR DELETE AS
IF (SELECT COUNT(*) FROM deleted
WHERE deleted.qty >= 20) > 0
BEGIN
PRINT 'You cannot delete any of these stores.'
PRINT 'Some stores have more than 20 sales!'
PRINT 'Rolling back your transaction!'
ROLLBACK TRANSACTION
END

/* */
DELETE FROM tblSales
WHERE stor_id = '7066'

/* */
SELECT stor_id, qty FROM tblSales

/* */
DELETE FROM tblSales
WHERE stor_id = '6380'

/* */
CREATE TRIGGER trInsUpdSales
ON tblSales
FOR INSERT, UPDATE AS
IF (SELECT COUNT(*) FROM tblStores, inserted
WHERE tblStores.stor_id = inserted.stor_id) = 0
BEGIN
PRINT 'The stor_id you have entered does not exist'
PRINT 'in the stores table!'
ROLLBACK TRANSACTION
END

/* */
DROP TRIGGER trInsUpdSales
GO
CREATE TRIGGER trInsUpdSales
ON tblSales
FOR INSERT, UPDATE AS
DECLARE @rc int
SELECT @rc = @@rowcount
IF (SELECT COUNT(*) FROM tblStores, inserted
WHERE tblStores.stor_id = inserted.stor_id) = 0
BEGIN
PRINT 'The stor_id you have entered does not exist'
PRINT 'in the stores table!'
ROLLBACK TRANSACTION
END
IF (SELECT COUNT(*) FROM tblSales, inserted
WHERE tblSales.stor_id = inserted.stor_id) <> @rc
BEGIN
PRINT 'Not all sales have a valid stor_id '
PRINT 'in the stores table!'
ROLLBACK TRANSACTION
END

/* */
USE pubs
GO
CREATE TRIGGER trIO_DelAuthors
ON authors INSTEAD OF DELETE AS
PRINT 'You cannot delete authors from the authors table.'


/* */
USE pubs
GO
DELETE authors WHERE au_lname = 'White'

/* */
CREATE FUNCTION dbo.fnLastDayOfMonth (@mydate datetime)
RETURNS datetime
AS
BEGIN
-- Declare variables to hold the various date components
  DECLARE @yy int
  DECLARE @mm int
  DECLARE @dd int
  DECLARE @tempdate datetime
  DECLARE @foo varchar(10)

-- Store the date components
  SET @yy = DATEPART(yy, @mydate)
  SET @mm = DATEPART(mm, @mydate)
  SET @dd = DATEPART(dd, @mydate)

-- If the month is December, then set the month to January
-- and the year to year + 1,  otherwise increment month by 1
  IF @mm = 12
    BEGIN
      SET @mm = 1
      SET @yy = @yy + 1
    END
  ELSE
    BEGIN
      SET @mm = @mm + 1
    END

--Set the day of the temporary string to the date with the day
--set to the first day of the following month.  Then convert the
--temporary string to a real date.  Then subtract one day from
--the date and return that value.
  SELECT @foo = CONVERT(varchar(2), @mm) + '/01/' + CONVERT(varchar(4), @yy)
  SET @tempdate = CONVERT(datetime, @foo)
  SET @tempdate = DATEADD(dd, -1, @tempdate)

  RETURN @tempdate
END

/* */
SELECT dbo.fnLastDayOfMonth('12/12/99')
SELECT dbo.fnLastDayOfMonth('02/02/99')
SELECT dbo.fnLastDayOfMonth('02/02/2000')

/* */
CREATE FUNCTION dbo.fnRoyaltiesByAuthor()
RETURNS TABLE AS
    RETURN (SELECT a.au_fname, a.au_lname, t.title,
    'RoyToDate' = (t.ytd_sales * t.price * t.royalty / 100)
    FROM authors a, titles t, titleauthor ta
    WHERE a.au_id = ta.au_id AND t.title_id = ta.title_id)
GO

SELECT * from dbo.fnRoyaltiesByAuthor
SELECT au_fname, RoyToDate FROM dbo.fnRoyaltiesByAuthor

/* */
CREATE FUNCTION dbo.fnRoyaltySplitByAuthor()
RETURNS @RoyByAuthor TABLE
  (au_lname varchar(40) NOT NULL,
   au_fname varchar(20) NULL,
   title varchar(80) NOT NULL,
   RoyToDate float)
AS
BEGIN
--Create a temp table to store my author count per title
    DECLARE @temptbl TABLE (title_id varchar(6) NOT NULL,
    num_authors tinyint NOT NULL)
    INSERT @temptbl
      SELECT title_id, COUNT(au_id) FROM titleauthor
      GROUP BY title_id

--Load my return table with a join between my temp table and all
--other appropriate tables.
    INSERT @RoyByAuthor
        SELECT a.au_fname, a.au_lname, t.title,
    'RoyToDate' = ((t.ytd_sales * t.price * t.royalty / 100)
          / tt.num_authors)
    FROM authors a, titles t, titleauthor ta, @temptbl tt
    WHERE a.au_id = ta.au_id AND t.title_id = ta.title_id
        AND t.title_id = tt.title_id
    RETURN
END

SELECT * FROM dbo.fnRoyaltySplitByAuthor



