/* */
USE pubs
GO
EXEC sp_dboption 'pubs', 'Select into/bulkcopy', TRUE
GO
SELECT * INTO tmpPublishers FROM publishers
SELECT * INTO tmpStores FROM stores
SELECT * INTO tmpTitles FROM titles
SELECT * INTO tmpSales FROM sales
GO
EXEC sp_dboption 'pubs', 'Select into/bulkcopy', FALSE
GO

/* */
USE pubs
go
EXEC sp_help publishers
go

/* */
USE pubs
GO
SELECT * FROM INFORMATION_SCHEMA.Columns
WHERE TABLE_NAME = 'publishers'
GO

/* */
USE pubs
GO
INSERT INTO tmpPublishers
VALUES('9956', 'A New Publisher', 'Poulsbo', 'WA', 'USA')

/* */
INSERT INTO tmpPublishers(state, pub_id)
VALUES('AK', '9932')

/* */
SELECT * FROM tmpPublishers
WHERE pub_id = '9932'

/* */
INSERT INTO tmpPublishers(pub_name, city, state)
VALUES('The Best Books', 'New Orleans', 'LA')

/* */
INSERT INTO tmpPublishers
VALUES('9950', DEFAULT, DEFAULT,'AK', DEFAULT)

/* */
INSERT INTO tmpPublishers DEFAULT VALUES

/* */
CREATE TABLE tblAddressList
(strName varchar(50) not null,
strAddress varchar(50) not null,
strCity varchar(20) not null,
strState char(2)  )

/* */
INSERT INTO tblAddressList
SELECT stor_name, stor_address, city, state
FROM tmpStores

/* */
INSERT INTO tblAddressList
SELECT au_lname + ', ' + au_fname, address, city, state
FROM authors

/* */
CREATE TABLE tblPublisherList
(strPubName varchar(40) NULL,
strTitle varchar(80) NULL)

/* */
INSERT INTO tblPublisherList
SELECT pub_name, title
FROM tmpPublishers LEFT OUTER JOIN tmpTitles
ON tmpPublishers.pub_id = tmpTitles.pub_id

/* */
EXEC sp_spaceused tmpPublishers

/* */
CREATE TABLE tblSpaceUsage
(strTableName varchar(30) not null,
strRows varchar(9),
strReserved varchar(10),
strData varchar(10),
strIndexSize varchar(10),
strUnused varchar(10)  )


/* */
INSERT INTO tblSpaceUsage
EXEC sp_spaceused 'tmpPublishers'

/* */
DELETE tmpSales

/* */
DELETE tmpPublishers
WHERE pub_name = 'New Moon Books'

/* */
DELETE FROM tblPublisherList
WHERE strPubName =
(SELECT pub_name FROM tmpPublishers
WHERE pub_id = '9956')

/* */
DELETE tblPublisherList
FROM tblPublisherList pl JOIN tmpPublishers p
ON pl.strPubName = p.pub_name
AND p.pub_id = '9956'

/* */
USE pubs
GO
DROP TABLE tmpSales
GO
SELECT * INTO tmpSales
FROM Sales
GO

/* */
DELETE tmpSales
WHERE title_id IN
(SELECT title_id FROM tmpTitles
WHERE type = 'business')

/* */
DELETE tmpSales
FROM tmpSales s JOIN tmpTitles t
ON s.title_id = t.title_id
WHERE t.type = 'business'

/* */
TRUNCATE TABLE tmpSales

/* */
USE pubs
GO
DROP TABLE tmpSales
DROP TABLE tmpPublishers
DROP TABLE tmpStores
DROP TABLE tmpTitles
GO
SELECT * INTO tmpPublishers FROM publishers
SELECT * INTO tmpSales FROM sales
SELECT * INTO tmpStores FROM stores
SELECT * INTO tmpTitles FROM titles
GO

/* */
UPDATE tmpTitles
SET ytd_sales = 0

/* */
UPDATE tmpPublishers
SET city = 'El Cerrito'
WHERE pub_name = 'Algodata Infosystems'

/* */
UPDATE tmpTitles
SET price = price * 0.90
WHERE type = 'psychology'

/* */
UPDATE tmpTitles
SET price = price * 1.2, notes = notes + ' (price increase)'
WHERE type = 'popular_comp'

/* */
UPDATE tmpTitles
SET pub_id =
(SELECT pub_id FROM tmpPublishers
WHERE pub_name = 'New Moon Books')
WHERE type = 'business'

/* */
UPDATE tmpTitles
SET tmpTitles.pub_id = p.pub_id
FROM tmpTitles t JOIN tmpPublishers p
ON t.pub_id = p.pub_id
WHERE p.pub_name = 'New Moon Books'
AND type = 'business'

/* */
UPDATE tmpTitles
SET pub_id =
    (SELECT pub_id FROM tmpPublishers
     WHERE pub_name = 'Binnet & Hardley')
WHERE type = 'psychology' AND pub_id =
    (SELECT pub_id FROM tmpPublishers
     WHERE pub_name = 'New Moon Books')


