SET ECHO ON
SET DEFINE OFF
SPOOL PrzykladoweDaneOracle

ALTER SESSION SET NLS_DATE_FORMAT = 'dd-Mon-yyyy';
ALTER SESSION SET NLS_DATE_LANGUAGE = 'English';

/*****************************************
 Tabele atrakcji
*****************************************/
DROP TABLE atrakcje;
DROP TABLE atrakcje_alger;
DROP TABLE atrakcje_marquette;
DROP TABLE attractions_inne;
DROP TABLE adresy_url_atrakcji;
DROP TABLE nazwy_atrakcji;
DROP TABLE miasta;
DROP TABLE hrabstwa;
DROP TABLE nowe_hrabstwa;
DROP VIEW atrakcje_miasta;

CREATE TABLE hrabstwa (
   id_hrabstwa NUMBER,
   nazwa_hrabstwa VARCHAR2(15),
   stan CHAR(2),
   CONSTRAINT hrabstwa_pkey
      PRIMARY KEY (id_hrabstwa))
   PARTITION BY RANGE (stan)
   SUBPARTITION BY HASH (id_hrabstwa) (
      PARTITION hrabstwa_01 VALUES LESS THAN ('MI'),
      PARTITION michigan VALUES LESS THAN ('MJ')
         (SUBPARTITION michigan01),
      PARTITION hrabstwa_02 VALUES LESS THAN (MAXVALUE));

CREATE TABLE nowe_hrabstwa (
   id_hrabstwa NUMBER,
   nazwa_hrabstwa VARCHAR2(15),
   stan CHAR(2));

CREATE TABLE miasta (
   id_miasta NUMBER,
   nazwa_miasta VARCHAR2(16),
   id_hrabstwa  NUMBER,
   CONSTRAINT miasta_pkey
      PRIMARY KEY (id_miasta),
   CONSTRAINT miasta_w_hrabstwie
      FOREIGN KEY (id_hrabstwa)
      REFERENCES hrabstwa);

CREATE TABLE atrakcje (
   id_atrakcji NUMBER,
   nazwa_atrakcji VARCHAR2(35),
   url_atrakcji VARCHAR2(40),
   wlasnosc_publiczna CHAR(1),
   id_miasta NUMBER,
   CONSTRAINT atrakcje_pkey
      PRIMARY KEY (id_atrakcji),
   CONSTRAINT atrakcje_w_miescie
      FOREIGN KEY (id_miasta)
      REFERENCES miasta,
   CONSTRAINT wlasnosc_publiczna_tn
      CHECK (wlasnosc_publiczna IN ('T','N')));

CREATE TABLE atrakcje_alger (
   id_atrakcji NUMBER,
   nazwa_atrakcji VARCHAR2(35),
   url_atrakcji VARCHAR2(40),
   wlasnosc_publiczna CHAR(1),
   id_miasta NUMBER);

CREATE TABLE atrakcje_marquette (
   id_atrakcji NUMBER,
   nazwa_atrakcji VARCHAR2(35),
   url_atrakcji VARCHAR2(40),
   wlasnosc_publiczna CHAR(1),
   id_miasta NUMBER);

CREATE TABLE atrakcje_inne (
   id_atrakcji NUMBER,
   nazwa_atrakcji VARCHAR2(35),
   url_atrakcji VARCHAR2(40),
   wlasnosc_publiczna CHAR(1),
   id_miasta NUMBER);

CREATE TABLE adresy_url_atrakcji (
   id NUMBER,
   url VARCHAR2(40));

CREATE TABLE nazwy_atrakcji (
   id NUMBER,
   nazwa VARCHAR2(35));

CREATE VIEW atrakcje_miasta
(nazwa_miasta, nazwa_atrakcji)
AS SELECT nazwa_miasta, nazwa_atrakcji
FROM miasta m INNER JOIN atrakcje a
     ON m.id_miasta = a.id_miasta;

INSERT INTO hrabstwa VALUES (1,'Alger','MI');
INSERT INTO hrabstwa VALUES (2,'Marquette','MI');
INSERT INTO hrabstwa VALUES (3,'Chippewa','MI');
INSERT INTO hrabstwa VALUES (4,'Mackinac','MI');
INSERT INTO hrabstwa VALUES (5, 'Delta','MI');
INSERT INTO hrabstwa VALUES (6, 'Luce','MI');
INSERT INTO hrabstwa VALUES (7, 'Schoolcraft','MI');
INSERT INTO hrabstwa VALUES (8, 'Menominee','MI');
INSERT INTO hrabstwa VALUES (9, 'Dickenson','MI');
INSERT INTO hrabstwa VALUES (10, 'Baraga','MI');
INSERT INTO hrabstwa VALUES (11, 'Houghton','MI');
INSERT INTO hrabstwa VALUES (12, 'Keweenaw','MI');
INSERT INTO hrabstwa VALUES (13, 'Ontonagon','MI');
INSERT INTO hrabstwa VALUES (14, 'Gogebic','MI');
INSERT INTO hrabstwa VALUES (15, 'Iron','MI');
INSERT INTO hrabstwa VALUES (16, 'Wane','MI');
INSERT INTO hrabstwa VALUES (18, 'McComb','MI');

INSERT INTO nowe_hrabstwa VALUES (1,'Alger','MI');
INSERT INTO nowe_hrabstwa VALUES (2,'Marquette','MI');
INSERT INTO nowe_hrabstwa VALUES (3,'Chippewa','MI');
INSERT INTO nowe_hrabstwa VALUES (16,'Wayne','MI');
INSERT INTO nowe_hrabstwa VALUES (17,'Oakland','MI');
INSERT INTO nowe_hrabstwa VALUES (18,'Macomb','MI');

INSERT INTO miasta VALUES (1,'Munising',1);
INSERT INTO miasta VALUES (2,'St. Ignace',4);
INSERT INTO miasta VALUES (3,'Marquette',2);
INSERT INTO miasta VALUES (4,'Iron River',15);
INSERT INTO miasta VALUES (5,'Bessemer',14);
INSERT INTO miasta VALUES (6,'Silver City',13);
INSERT INTO miasta VALUES (7,'Copper Harbor',12);
INSERT INTO miasta VALUES (8,'Hancock',11);
INSERT INTO miasta VALUES (9,'L''Anse',10);
INSERT INTO miasta VALUES (10,'Vulcan',9);
INSERT INTO miasta VALUES (11,'Carbondale',8);
INSERT INTO miasta VALUES (12,'Germfask',7);
INSERT INTO miasta VALUES (13,'Newberry',6);
INSERT INTO miasta VALUES (14,'Gladstone',5);
INSERT INTO miasta VALUES (15,'Sault Ste. Marie',3);
INSERT INTO miasta VALUES (16,'Ishpeming',2);
INSERT INTO miasta VALUES (17,NULL,1);
INSERT INTO miasta VALUES (18,'Brimley',3);

/* Hrabstwo Alger */
INSERT INTO atrakcje VALUES (1, 'Pictured Rocks',
                               'www.nps.gov/piro/',
                               'Y', 1);
INSERT INTO atrakcje VALUES (2, 'Valley Spur',
                               'www.valleyspur.com',
                               'Y', 1);
INSERT INTO atrakcje VALUES (3, 'Shipwreck Tours',
                               'www.shipwrecktours.com',
                               'N', 1);

INSERT INTO atrakcje VALUES (23, 'Grand Sable Dunes',
                               NULL, NULL, NULL);

/* Hrabstwo Marquette */
INSERT INTO atrakcje VALUES (4, 'Ski Hall of Fame',
                               'www.skihall.com',
                               'N', 16);
INSERT INTO atrakcje VALUES (5, 'Da Yoopers Tourist Trap',
                               'www.dayoopers.com',
                               'N', 16);
INSERT INTO atrakcje VALUES (6, 'Marquette County Historical Museum',
                               'www.marquettecohistory.org',
                               'N', 3);
INSERT INTO atrakcje VALUES (7, 'Upper Peninsula Children''s Museum',
                               'www.upcmkids.org',
                               'N', 3);
INSERT INTO atrakcje VALUES (8, 'Marquette Maritime Museum',
                               'mqtmaritimemuseum.com',
                               'N', 3);

/* Hrabstwo Chippewa */
INSERT INTO atrakcje VALUES (9, 'Valley Camp',
                               'www.thevalleycamp.com',
                               'N', 15);

/* Hrabstwo Mackinac */
INSERT INTO atrakcje VALUES (10, 'Mackinac Bridge',
                               'www.mackinacbridge.org',
                               'Y', 2);

/* Hrabstwo Delta */
INSERT INTO atrakcje VALUES (11, 'Hoegh Pet Casket Company',
                               'hoegh.abka.com',
                               'N', 14);

/* Hrabstwo Luce */
/* Brak danych o atrakcjach hrabstwa Luce jest celowy.
   Umoliwia on zademonstrowanie szczeglnego sposobu dziaania 
   klauzuli GROUP BY. */

/* Hrabstwo Schoolcraft */
INSERT INTO atrakcje VALUES (12, 'Seney National Wildlife Refuge',
                               'midwest.fws.gov/seney/',
                               'Y', 12);

/* Menominee */
INSERT INTO atrakcje VALUES (13, 'Wells State Park',
                               NULL,'Y',NULL);

/* Dickenson */
/* Brak danych dla hrabstwa Dickenson. */

/* Baraga */
INSERT INTO atrakcje VALUES (14, 'Bishop Baraga Shrine',
                               'www.baragashrine.com',
                               'N', 9);

INSERT INTO atrakcje VALUES (15, 'Mount Arvon',
                               NULL,NULL,NULL);

/* Houghton */
INSERT INTO atrakcje VALUES (16,'Quincy Steam Hoist',
                               'www.quincymine.com',
                               'N',8);
INSERT INTO atrakcje VALUES (17,'Temple Jacob',
                               'www.uahc.org/mi/mi010',
                               'N',8);
INSERT INTO atrakcje VALUES (18,'Finlandia University',
                               'www.finlandia.edu',
                               'N',8);

/* Keweenaw */
INSERT INTO atrakcje VALUES (19,'Fort Wilkins State Park',
                               NULL,'Y',7);

/* Ontonagon */
INSERT INTO atrakcje VALUES (20,'Porcupine Mountain Wilderness',
                               NULL,'Y',6);

/* Gogebic */
INSERT INTO atrakcje VALUES (21,'Copper Peak Ski Flying Hill',
                               'www.westernup.com/copperpeak/',
                               'N',5);

/* Iron */
INSERT INTO atrakcje VALUES (22,'Iron County Historical Museum',
                               'www.ironcountymuseum.com',
                               'N',4);
COMMIT;



/*****************************************
 Tabele CD
*****************************************/
DROP VIEW utwory_cd;
DROP TYPE tabela_utworow;
DROP TYPE typ_utworow;
DROP TABLE utwory;
DROP TABLE cd;
DROP TABLE "Tabela CD";
DROP TABLE wykonawcy;

CREATE TABLE wykonawcy (
    nazwa VARCHAR(15),
    stronaWWW VARCHAR(25) DEFAULT 'brak adresu',
    CONSTRAINT wykonawcy_pk
        PRIMARY KEY (nazwa));

CREATE TABLE cd (
    id_cd NUMBER,
    tytul VARCHAR2(35),
    cena  NUMBER(4,2),
    czas_calkowity NUMBER,
    wykonawca VARCHAR2(15),
    pierwszy_utwor VARCHAR2(36),
    CONSTRAINT cd_pk
        PRIMARY KEY (id_cd),
    CONSTRAINT cd_unique
        UNIQUE (tytul));

CREATE TABLE utwory (
    id_cd NUMBER,
    utwor NUMBER,
    tytul VARCHAR2(36),
    czas_trwania NUMBER,
    wykonawca VARCHAR2(15),
    CONSTRAINT utwory_pk
        PRIMARY KEY (id_cd, utwor),
    CONSTRAINT cd_fk
        FOREIGN KEY (id_cd)
        REFERENCES cd,
    CONSTRAINT wykonawca_fk
        FOREIGN KEY (nazwa)
        REFERENCES wykonawcy);

CREATE TYPE typ_utworow AS OBJECT (
    utwor NUMBER,
    tytul VARCHAR2(36),
    czas_trwania NUMBER);
/

CREATE TYPE tabela_utworow
   AS TABLE OF typ_utworow;
/

CREATE VIEW utwory_cd
   (id_cd, tytul, utwory)
AS (SELECT c.id_cd, c.tytul,
           CAST(MULTISET
               (SELECT u.utwor, u.tytul, u.czas_trwania
               FROM utwory u
               WHERE u.id_cd = c.id_cd) AS tabela_utworow)
    FROM cd c);

INSERT INTO wykonawcy VALUES ('Carl Behrend','www.GreatLakesLegends.com');
INSERT INTO wykonawcy VALUES ('Rondi Olson','www.milknhoney.org');
INSERT INTO wykonawcy VALUES ('Jenny Gennick','');

INSERT INTO cd VALUES (1,'Legends of the Great Lakes',17.95,0,'','');
INSERT INTO cd VALUES (2,'Nothing Less',10.00,0,'','');
INSERT INTO cd VALUES (3,'More Legends of the Great Lakes',17.95,0,'','');
INSERT INTO cd VALUES (4,'The Ballad of Seul Choix',17.95,0,'','');
INSERT INTO cd VALUES (5,'Seeing the Unseen',10,0,'','');

/* Legends of the Great Lakes */
INSERT INTO utwory VALUES (1,1,'The Christmas Ship',NULL,'Carl Behrend');
INSERT INTO utwory VALUES (1,2,'Lake Superior Song',NULL,'Carl Behrend');
INSERT INTO utwory VALUES (1,3,'Captain Bundy''s Gospel Ship',NULL,'Carl Behrend');
INSERT INTO utwory VALUES (1,4,'Ballad of Seul Choix',NULL,'Carl Behrend');
INSERT INTO utwory VALUES (1,5,'What Do You Do With a Drunken Sailor',NULL,'Carl Behrend');
INSERT INTO utwory VALUES (1,6,'Dream on a Winters Night',NULL,'Carl Behrend');
INSERT INTO utwory VALUES (1,7,'Porcupine Mountains Wilderness Song',NULL,'Carl Behrend');
INSERT INTO utwory VALUES (1,8,'Just a Memory',NULL,'Carl Behrend');
INSERT INTO utwory VALUES (1,9,'Wanda Fey',NULL,'Carl Behrend');
INSERT INTO utwory VALUES (1,10,'What Would I Be Without Love',NULL,'Carl Behrend');
INSERT INTO utwory VALUES (1,11,'How Many Stars',NULL,'Carl Behrend');

/* Nothing Less */
INSERT INTO utwory VALUES (2,1,'Joyfully Lord',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,2,'Open My Heart',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,3,'Nothing Less',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,4,'Where You Want Me to Go',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,5,'Do You Love Me',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,6,'In the Light of the Cross',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,7,'Yeshua, Messiah',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,8,'Into the River',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,9,'Worthy to be Praised',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,10,'Michael Stand Up',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,11,'What You Saw',NULL,'Rondi Olson');
INSERT INTO utwory VALUES (2,12,'Listen',NULL,'Rondi Olson');

/* More Legends of the Great Lakes */
INSERT INTO utwory VALUES (3,1,'Dan Seavy the Great Lakes Pirate',296,'Carl Behrend');
INSERT INTO utwory VALUES (3,2,'The Captain and the Lady',313,'Carl Behrend');
INSERT INTO utwory VALUES (3,3,'Wreck of the Mary Ellen Carter',301,'Carl Behrend');
INSERT INTO utwory VALUES (3,4,'Three Sheets to the Wind',285,'Carl Behrend');
INSERT INTO utwory VALUES (3,5,'Face on the Rock',285,'Carl Behrend');
INSERT INTO utwory VALUES (3,6,'On the Boat Again',186,'Carl Behrend');
INSERT INTO utwory VALUES (3,7,'Great Lakes Fisherman',259,'Carl Behrend');
INSERT INTO utwory VALUES (3,8,'Wreck of the Edmund Fitzgerald',305,'Carl Behrend');
INSERT INTO utwory VALUES (3,9,'Lady Sing Your Songs Tonight',269,'Carl Behrend');
INSERT INTO utwory VALUES (3,10,'Grandma''s Feather Bed',189,'Carl Behrend');

COMMIT;

CREATE TABLE "CD Table" (
    "ID CD",
    "Tytul CD",
    "Cena",
    CONSTRAINT cd2_pk
        PRIMARY KEY ("ID CD"),
    CONSTRAINT cd2_unique
        UNIQUE ("Tytul CD"))
AS SELECT * FROM CD;



/*****************************************
 Tabela przestawna
*****************************************/
DROP TABLE przestawna;

CREATE TABLE przestawna (
   x NUMBER
   );

INSERT INTO przestawna
SELECT setki.x+dzies.x+jedn.x FROM
  (SELECT 0 x FROM dual
   UNION SELECT 1 FROM dual
   UNION SELECT 2 FROM dual
   UNION SELECT 3 FROM dual
   UNION SELECT 4 FROM dual
   UNION SELECT 5 FROM dual
   UNION SELECT 6 FROM dual
   UNION SELECT 7 FROM dual
   UNION SELECT 8 FROM dual
   UNION SELECT 9 FROM dual) jedn,
  (SELECT 0 x FROM dual
   UNION SELECT 10 FROM dual
   UNION SELECT 20 FROM dual
   UNION SELECT 30 FROM dual
   UNION SELECT 40 FROM dual
   UNION SELECT 50 FROM dual
   UNION SELECT 60 FROM dual
   UNION SELECT 70 FROM dual
   UNION SELECT 80 FROM dual
   UNION SELECT 90 FROM dual) dzies,
  (SELECT 0 x FROM dual
   UNION SELECT 100 FROM dual
   UNION SELECT 200 FROM dual
   UNION SELECT 300 FROM dual
   UNION SELECT 400 FROM dual
   UNION SELECT 500 FROM dual
   UNION SELECT 600 FROM dual
   UNION SELECT 700 FROM dual
   UNION SELECT 800 FROM dual
   UNION SELECT 900 FROM dual) setki;

COMMIT;

/*****************************************
Tabele zagroe
*****************************************/
DROP TABLE lokalizacja_pracownika;
DROP TABLE narazone_budynki;

CREATE TABLE lokalizacja_pracownika (
   id_pracownika NUMBER,
   numer_budynku NUMBER,
   data_poczatkowa DATE,
   data_koncowa DATE);

CREATE TABLE narazone_budynki (
   numer_budynku NUMBER,
   substancja VARCHAR2(20),
   data_poczatkowa DATE,
   data_koncowa DATE);

INSERT INTO lokalizacja_pracownika VALUES (1,1,'15-Nov-2000','1-Jan-2002');
INSERT INTO lokalizacja_pracownika VALUES (1,2,'2-Jan-2002',NULL);
INSERT INTO lokalizacja_pracownika VALUES (2,1,'26-Dec-1995','4-Jul-1997');
INSERT INTO lokalizacja_pracownika VALUES (2,2,'1-Jul-1997','31-Dec-2001');
INSERT INTO lokalizacja_pracownika VALUES (2,3,'31-Dec-2001',NULL);

--Nazwy substancji chemicznych pochodz z elektronicznego leksykonu NIOSH
--NIOSH Pocket Guide to Chemical Hazards i zostay wybrane w przypadkowej kolejnoci z
--listy dostpnej pod adresem:

--    http://www.cdc.gov/niosh/npg/npgd0000.html


INSERT INTO narazone_budynki
   VALUES (1,'Acetaldehyd','1-Nov-1999','1-Mar-2001');
INSERT INTO narazone_budynki
   VALUES (1,'Cyjanooctan etylu','1-Dec-2000',NULL);
INSERT INTO narazone_budynki
   VALUES (1,'Tetrachloroethylen','1-Jan-2001','31-Dec-2001');
INSERT INTO narazone_budynki
   VALUES (1,'Kwas pruski','1-Jan-1995','1-Jan-1997');

INSERT INTO narazone_budynki
   VALUES (2,'Mrowczan butylu','2-Feb-1996','13-Aug-1997');
INSERT INTO narazone_budynki
   VALUES (2,'Metoksyetanol','27-Apr-1998','2-Jan-2002');
INSERT INTO narazone_budynki
   VALUES (2,'Cykloheksan','30-Sep-2000','31-Oct-2000');
INSERT INTO narazone_budynki
   VALUES (2,'Tetralina','1-Jan-2002',NULL);

INSERT INTO narazone_budynki
   VALUES (3,'Heptan','1-Jan-2002',NULL);
INSERT INTO narazone_budynki
   VALUES (3,'Kwas karbolowy','1-Oct-2001','31-Dec-2001');

COMMIT;

/*****************************************
Hierarchiczne tabele zestawienia materiaw
*****************************************/
DROP TABLE element;
DROP TABLE zestawienie_materialow;

CREATE TABLE element (
	numer_elementu    NUMBER,
	nazwa_elementu    VARCHAR2(23),
	producent         VARCHAR2(30),
	stan_magazynowy   NUMBER);

/* Czeci samochodowe */

INSERT INTO element VALUES (1001,'Tok','Munising Tool & Die',500);
INSERT INTO element VALUES (1002,'Filtr powietrza','Germfask Filter Company', 200);
INSERT INTO element VALUES (1003,'wieca zaponowa','Pyro Plugs, Inc.',2000);
INSERT INTO element VALUES (1004,'Blok silnika','Munising Tool & Die',100);
INSERT INTO element VALUES (1005,'Alternator','Pyro Plugs, Inc.',300);
INSERT INTO element VALUES (1006,'Akumulator','Low-flow Battery Corp.',250);
INSERT INTO element VALUES (1007,'Rozrusznik','Pyro Plugs, Inc.',400);
INSERT INTO element VALUES (1008,'Dach','Shingleton Stamping',700);
INSERT INTO element VALUES (1017,'Rama lewych drzwi','Shingleton Stamping',250);
INSERT INTO element VALUES (1018,'Szyba lewych drzwi','Shards & Splinters Glass Fab',250);
INSERT INTO element VALUES (1019,'Zamek','Grand Marais Motors',250);
INSERT INTO element VALUES (1020,'Rama prawych drzwi','Shingleton Stamping',250);
INSERT INTO element VALUES (1021,'Szyba prawych drzwi','Shards & Splinters Glass Fab',650);

/* Czci samolotu  */
INSERT INTO element VALUES (2001,'Penowymiarowa poduszka','Seney Seats',333);
INSERT INTO element VALUES (2002,'Uchwyt podokietnika na kubek','Seney Seats',444);
INSERT INTO element VALUES (2003,'Ergonomiczne oparcie','Seney Seats',374);
INSERT INTO element VALUES (2004,'Dodatkowa wska poduszka','Seney Seats',432);
INSERT INTO element VALUES (2005,'Podokietnik','Seney Seats',521);
INSERT INTO element VALUES (2006,'Twarde oparcie','Seney Seats',978);

COMMIT;

CREATE TABLE zestawienie_materialow (
	id_elementu     NUMBER,
	nazwa_elementu  VARCHAR2(23),
	element_rodzic  NUMBER,
	numer_elementu  NUMBER,
	ilosc           NUMBER);

/* Samochod */
INSERT INTO zestawienie_materialow VALUES (100,'Samochod',NULL,NULL,NULL);
INSERT INTO zestawienie_materialow VALUES (110,'Silnik',100,NULL,1);
INSERT INTO zestawienie_materialow VALUES (120,'Nadwozie',100,NULL,1);
INSERT INTO zestawienie_materialow VALUES (130,'Wntrze',100,NULL,1);

/* Samochod/Silnik */
INSERT INTO zestawienie_materialow VALUES (111,'Tok',110,1001,6);
INSERT INTO zestawienie_materialow VALUES (112,'Filtr powietrza',110,1002,1);
INSERT INTO zestawienie_materialow VALUES (113,'wica zaponowa',110,1003,6);
INSERT INTO zestawienie_materialow VALUES (114,'Blok silnika',110,1004,1);
INSERT INTO zestawienie_materialow VALUES (115,'System zaponowy',110,NULL,1);

/* Samochod/Silnik/System zaponowy */
INSERT INTO zestawienie_materialow VALUES (116,'Alternator',115,1005,1);
INSERT INTO zestawienie_materialow VALUES (117,'Akumulator',115,1006,1);
INSERT INTO zestawienie_materialow VALUES (118,'Rozrusznik',115,1007,1);

/* Samochod/Nadwozie */
INSERT INTO zestawienie_materialow VALUES (121,'Dach',120,1008,1);
INSERT INTO zestawienie_materialow VALUES (122,'Lewe drzwi',120,NULL,2);
INSERT INTO zestawienie_materialow VALUES (123,'Prawe drzwi',120,NULL,2);

/* Samochod/Nadwozie/Lewe drzwi */
INSERT INTO zestawienie_materialow VALUES (139,'Rama lewych drzwi',122,1017,1);
INSERT INTO zestawienie_materialow VALUES (140,'Szyba lewych drzwi',122,1018,1);
INSERT INTO zestawienie_materialow VALUES (141,'Zamek',122,1019,1);

/* Samochod/Nadwozie/Prawe drzwi */
INSERT INTO zestawienie_materialow VALUES (142,'Rama prawych drzwi',123,1020,1);
INSERT INTO zestawienie_materialow VALUES (143,'Szyba prawych drzwi',123,1021,1);
INSERT INTO zestawienie_materialow VALUES (144,'Zamek',123,1019,1);

/* Samochod/Wntrze */
INSERT INTO zestawienie_materialow VALUES (131,'Front Seat',130,NULL,2);
INSERT INTO zestawienie_materialow VALUES (132,'Back Seat',130,NULL,1);
INSERT INTO zestawienie_materialow VALUES (133,'Carpet',130,1011,1);

/* Samochod/Wntrze/Przednie siedzenia */
INSERT INTO zestawienie_materialow VALUES (134,'Poduszka siedzenia',131,1012,1);
INSERT INTO zestawienie_materialow VALUES (135,'Oparcie siedzenia',131,1013,1);
INSERT INTO zestawienie_materialow VALUES (136,'Zagwek',131,1014,1);

/* Samochod/Wntrze/Tylne siedzenia */
INSERT INTO zestawienie_materialow VALUES (137,'Poduszka siedzenia',132,1015,1);
INSERT INTO zestawienie_materialow VALUES (138,'Oparcie siedzenia',132,1016,1);

/* Samolot*/
INSERT INTO zestawienie_materialow VALUES (200,'Samolot',NULL,NULL,NULL);
INSERT INTO zestawienie_materialow VALUES (201,'Silnik odrzutowy',200,NULL,2);
INSERT INTO zestawienie_materialow VALUES (202,'Lewe skrzydo',200,NULL,1);
INSERT INTO zestawienie_materialow VALUES (203,'Prawe skrzydo',200,NULL,1);
INSERT INTO zestawienie_materialow VALUES (204,'Kadub',200,NULL,1);

/* Samolot/Kadub */
INSERT INTO zestawienie_materialow VALUES (205,'Siedzenie pierwszej klasy',204,NULL,12);
INSERT INTO zestawienie_materialow VALUES (206,'Siedzenie zwyke',204,NULL,300);

/* Samolot/Kadub/Siedzenie pierwszej klasy */
INSERT INTO zestawienie_materialow VALUES (207,'Penowymiarowa poduszka',205,2001,1);
INSERT INTO zestawienie_materialow VALUES (208,'Uchwyt podokietnika na kubek',205,2002,2);
INSERT INTO zestawienie_materialow VALUES (209,'Ergonomiczne oparcie',205, 2003,1);

/* Samolot/Kadub/Zwyke siedzenie */
INSERT INTO zestawienie_materialow VALUES (210,'Dodatkowa wska poduszka',206,2004,1);
INSERT INTO zestawienie_materialow VALUES (211,'Podokietnik',206,2005,1);
INSERT INTO zestawienie_materialow VALUES (212,'Twarde oparcie',206, 2006,1);

COMMIT;

--Uytkownik musi ponownie zestawi poczenie ze wzgldu na
--zmiany dwch parametrw sesji: NLS_DATE_FORMAT i
--NLS_DATE_LANGUAGE.
DISCONNECT;

SPOOL OFF
SET ECHO OFF
SET DEFINE ON
