USE AdventureWorks
DECLARE @TraceID INT
DECLARE @maxfilesize BIGINT
SET @maxfilesize = 5 
EXEC sp_trace_create @TraceID OUTPUT, 0, N'C:\PerfLogs\SQL', @maxfilesize, NULL

DECLARE @on BIT
SET @on = 1
EXEC sp_trace_setevent @TraceID, 10, 16, @on
EXEC sp_trace_setevent @TraceID, 10, 48, @on
EXEC sp_trace_setevent @TraceID, 10, 1, @on
EXEC sp_trace_setevent @TraceID, 10, 17, @on
EXEC sp_trace_setevent @TraceID, 10, 18, @on
EXEC sp_trace_setevent @TraceID, 10, 3, @on
EXEC sp_trace_setevent @TraceID, 10, 11, @on
EXEC sp_trace_setevent @TraceID, 10, 35, @on
EXEC sp_trace_setevent @TraceID, 10, 12, @on
EXEC sp_trace_setevent @TraceID, 10, 13, @on
EXEC sp_trace_setevent @TraceID, 45, 16, @on
EXEC sp_trace_setevent @TraceID, 45, 48, @on
EXEC sp_trace_setevent @TraceID, 45, 1, @on
EXEC sp_trace_setevent @TraceID, 45, 17, @on
EXEC sp_trace_setevent @TraceID, 45, 18, @on
EXEC sp_trace_setevent @TraceID, 45, 3, @on
EXEC sp_trace_setevent @TraceID, 45, 11, @on
EXEC sp_trace_setevent @TraceID, 45, 35, @on
EXEC sp_trace_setevent @TraceID, 45, 12, @on
EXEC sp_trace_setevent @TraceID, 45, 28, @on
EXEC sp_trace_setevent @TraceID, 45, 13, @on
EXEC sp_trace_setevent @TraceID, 12, 16, @on
EXEC sp_trace_setevent @TraceID, 12, 48, @on
EXEC sp_trace_setevent @TraceID, 12, 1, @on
EXEC sp_trace_setevent @TraceID, 12, 17, @on
EXEC sp_trace_setevent @TraceID, 12, 18, @on
EXEC sp_trace_setevent @TraceID, 12, 3, @on
EXEC sp_trace_setevent @TraceID, 12, 11, @on
EXEC sp_trace_setevent @TraceID, 12, 35, @on
EXEC sp_trace_setevent @TraceID, 12, 12, @on
EXEC sp_trace_setevent @TraceID, 12, 13, @on

DECLARE @intfilter INT
DECLARE @bigintfilter BIGINT
EXEC sp_trace_setfilter @TraceID, 10, 0, 7, N'SQL Profiler' 
EXEC sp_trace_setfilter @TraceID, 35, 0, 7, N'Master'

EXEC sp_trace_setstatus @TraceID, 1
SELECT TraceID=@TraceID
GO

SELECT Textdata, Duration
FROM fn_trace_gettable ('C:\PerfLogs\SQL.trc' , 1)
ORDER BY Duration DESC
GO


EXEC sp_trace_setstatus 2, 0
EXEC sp_trace_setstatus 2, 2
GO
DECLARE @TraceID int
SELECT @TraceID = TraceID 
FROM ::fn_trace_getinfo(default) 
WHERE property = 2 AND value = 'nazwa pliku'
SELECT @TraceID
GO
SELECT id, status, path
FROM sys.traces
GO

SELECT counter_name,cntr_value
FROM sys.dm_os_performance_counters
WHERE object_name LIKE 'MSSQL$SQLEXPRESS:General Statistics%' 
AND cntr_value<>0  
GO
SELECT wait_type, waiting_tasks_count, wait_time_ms, max_wait_time_ms, signal_wait_time_ms
FROM sys.dm_os_wait_stats
ORDER BY wait_type
GO
SELECT GETDATE() AS dt, wait_type, waiting_tasks_count, wait_time_ms, max_wait_time_ms, signal_wait_time_ms
INTO dbo.WaitStats
FROM sys.dm_os_wait_stats
GO
DBCC SQLPERF('sys.dm_os_wait_stats', CLEAR)
GO
INSERT INTO dbo.WaitStats
SELECT GETDATE(), wait_type, waiting_tasks_count, wait_time_ms, max_wait_time_ms, signal_wait_time_ms
FROM sys.dm_os_wait_stats
GO
DBCC SQLPERF('sys.dm_os_wait_stats', CLEAR)
GO

CHECKPOINT
DBCC FREEPROCCACHE
DBCC DROPCLEANBUFFERS
GO
SELECT sql.text, qs.execution_count, creation_time,last_execution_time, total_worker_time, total_physical_reads, total_logical_reads, total_logical_writes, total_elapsed_time, query_plan
FROM sys.dm_exec_query_stats AS qs 
CROSS APPLY sys.dm_exec_sql_text(sql_handle) sql
CROSS APPLY sys.dm_exec_query_plan(plan_handle) p
WHERE text NOT LIKE '%sql.text%'
GO

WITH Waits AS
(SELECT wait_type, wait_time_ms / 1000. AS wait_time_s, 100. * wait_time_ms / SUM(wait_time_ms) OVER() AS pct, ROW_NUMBER() OVER(ORDER BY wait_time_ms DESC) AS rn
FROM sys.dm_os_wait_stats
WHERE wait_type NOT LIKE '%SLEEP%')
SELECT W1.wait_type, CAST(W1.wait_time_s AS DECIMAL(12, 2)) AS Czas_sec, CAST(W1.pct AS DECIMAL(12, 2)) AS Procent, CAST(SUM(W2.pct) AS DECIMAL(12, 2)) AS ProcentNarastajaco
FROM Waits AS W1 JOIN Waits AS W2
ON W2.rn <= W1.rn
GROUP BY W1.rn, W1.wait_type, W1.wait_time_s, W1.pct
HAVING W1.rn <=6
ORDER BY W1.rn
GO
WITH Waits1 AS 
(SELECT dt, wait_type, wait_time_ms / 1000. AS wait_time_s,
ROW_NUMBER() OVER(PARTITION BY wait_type ORDER BY dt) AS rn
FROM dbo.WaitStats
WHERE wait_type NOT LIKE '%SLEEP%')
SELECT *
FROM Waits1
ORDER BY SUM(wait_time_s) OVER(PARTITION BY wait_type) DESC, wait_type
GO

SELECT scheduler_id, current_tasks_count, runnable_tasks_count
FROM sys.dm_os_schedulers
WHERE scheduler_id < 255
GO
WITH opt AS 
(SELECT server_start_time = 
(SELECT login_time 
FROM sys.dm_exec_sessions 
WHERE session_id = 1), 
total_optimizations = [occurrence], avg_optimization_time_s = [value] 
FROM sys.dm_exec_query_optimizer_info 
WHERE counter = 'elapsed time' ), 
opt_perc AS 
(SELECT opt.*, available_time_s = DATEDIFF(SS, server_start_time, GETDATE()), total_optimization_time_s = avg_optimization_time_s * total_optimizations 
FROM opt) 
SELECT opt_perc.*, percent_time = total_optimization_time_s / available_time_s * 100. 
FROM opt_perc
GO
SELECT counter_name,cntr_value
FROM sys.dm_os_performance_counters
WHERE object_name = 'MSSQL$SQLEXPRESS:SQL Statistics'
GO
SELECT cpu.total_worker_time /1000. AS czas_cpu, q.[text]
FROM (SELECT TOP 5 qs.plan_handle, qs.total_worker_time
FROM sys.dm_exec_query_stats qs
ORDER BY qs.total_worker_time desc) as cpu
CROSS APPLY sys.dm_exec_sql_text(plan_handle) as q
ORDER BY cpu.total_worker_time DESC
GO

SELECT counter_name, cntr_value
FROM sys.dm_os_performance_counters 
WHERE counter_name = 'Memory Grants Pending'
GO
SELECT counter_name, cntr_value
FROM sys.dm_os_performance_counters
WHERE object_name = 'MSSQL$SQLEXPRESS:Buffer Manager' 
AND (counter_name = 'Page life expectancy' OR counter_name = 'Buffer cache hit ratio')
GO
SELECT 'Strony danych', CONVERT(INT,((CONVERT(NUMERIC(10,2),cntr_value)
* 8192)/1024)/1024) as 'MB'
FROM sys.dm_os_performance_counters
WHERE object_name = 'MSSQL$SQLEXPRESS:Buffer Manager' 
AND counter_name = 'Database pages'
UNION
SELECT 'Puste strony', CONVERT(INT,((CONVERT(NUMERIC(10,2), cntr_value)
* 8192)/1024)/1024) as 'MB'
FROM sys.dm_os_performance_counters
WHERE object_name = 'MSSQL$SQLEXPRESS:Buffer Manager' 
AND counter_name = 'Free pages'
GO
DBCC CACHESTATS
GO
SELECT TOP 5 [type], SUM(multi_pages_kb) 
FROM sys.dm_os_memory_clerks
GROUP BY [type]
ORDER BY 2 DESC
GO

SELECT DB_NAME(database_id), FILE_NAME(file_id), io_stall
FROM sys.dm_io_virtual_file_stats(NULL, NULL) t1 JOIN sys.dm_io_pending_io_requests t2
ON t1.file_handle = t2.io_handle
GO
WITH DBIO AS
(SELECT DB_NAME(IVFS.database_id) AS db,
CASE WHEN MF.type = 1 THEN 'log' ELSE 'dane' END AS typ,
SUM(IVFS.num_of_bytes_read + IVFS.num_of_bytes_written) AS io, 
SUM(IVFS.io_stall) AS io_stall
FROM sys.dm_io_virtual_file_stats(NULL, NULL) AS IVFS
JOIN sys.master_files AS MF
ON IVFS.database_id = MF.database_id
AND IVFS.file_id = MF.file_id
GROUP BY DB_NAME(IVFS.database_id), MF.type)
SELECT db, typ, CAST(1. * io / (1024 * 1024) AS DECIMAL(12, 2)) AS io_mb,
CAST(io_stall / 1000. AS DECIMAL(12, 2)) AS io_stall_s,
CAST(100. * io_stall / SUM(io_stall) OVER() AS DECIMAL(10, 2)) AS io_stall_pct
FROM DBIO
ORDER BY io_stall DESC
GO
SELECT TOP 4 text, total_logical_reads + total_logical_writes AS suma,(total_logical_reads/execution_count) as rednia_logicznych, (total_logical_writes/execution_count) as avg_logical_writes,(total_physical_reads/execution_count) as rednia_fizycznych, execution_count 
FROM sys.dm_exec_query_stats 
CROSS APPLY sys.dm_exec_sql_text (sql_handle) 
ORDER BY(total_logical_reads + total_logical_writes) DESC
GO

SELECT instance_name, cntr_value
FROM sys.dm_os_performance_counters 
WHERE counter_name = 'Log Growths' AND cntr_value>0
GO
SELECT instance_name, cntr_value 
FROM sys.dm_os_performance_counters 
WHERE counter_name = 'Log File(s) Used Size (KB)'
GO
SELECT instance_name, cntr_value 
FROM sys.dm_os_performance_counters
WHERE counter_name ='Percent Log Used'  
GO

USE tempdb
EXEC sp_helpfile
GO
SELECT SUM (user_object_reserved_page_count)*8 AS obiekty_uz, 
SUM (internal_object_reserved_page_count)*8 AS obiekty_wew_kb, 
SUM (version_store_reserved_page_count)*8  AS magazyn_wersji_kb, 
SUM (unallocated_extent_page_count)*8 as wolne_kb
FROM sys.dm_db_file_space_usage
GO
SELECT *
FROM sys.dm_db_session_space_usage
GO
SELECT *
FROM sys.dm_tran_active_snapshot_database_transactions  
GO

SELECT counter_name, cntr_value
FROM sys.dm_os_performance_counters
WHERE counter_name = 'Full Scans/sec' OR counter_name = 'Index Searches/sec' 
GO
USE AdventureWorks
SELECT CustomerID, SalesOrderNumber, SubTotal
FROM Sales.SalesOrderHeader
WHERE ShipMethodID > 2
AND TerritoryID = 5
GO
SELECT DB_NAME(database_id),OBJECT_NAME(object_id),equality_columns, inequality_columns, included_columns
FROM sys.dm_db_missing_index_details
GO
SELECT OBJECT_NAME(object_id), index_id, avg_fragmentation_in_percent, page_count
FROM sys.dm_db_index_physical_stats 
(DB_ID('AdventureWorks'), NULL, NULL, NULL, NULL)
GO
SELECT OBJECT_NAME(object_id),index_id,avg_fragmentation_in_percent, page_count, avg_page_space_used_in_percent 
FROM sys.dm_db_index_physical_stats
(db_id('AdventureWorks'), OBJECT_ID('Sales.SalesOrderDetail'), NULL, NULL, 'SAMPLED')
GO
SELECT INDEXPROPERTY(OBJECT_ID('HumanResources.Employee'), 'PK_Employee_EmployeeID', 'IndexFillFactor')
GO
SELECT object_name(i.object_id), i.name, s.user_updates, s.user_seeks, s.user_scans, s.user_lookups
FROM sys.indexes i LEFT JOIN sys.dm_db_index_usage_stats s 
ON s.object_id = i.object_id 
AND i.index_id = s.index_id AND s.database_id = DB_ID('AdventureWorks')
WHERE OBJECTPROPERTY(i.object_id, 'IsIndexable') = 1
GO
SELECT OBJECT_NAME(s.object_id),i.name, i.index_id,   
CAST (100.0 * row_lock_wait_count / (1 + row_lock_count) AS NUMERIC(15,2)) ProcentBlokad, row_lock_wait_in_ms, 
CAST (1.0 * row_lock_wait_in_ms /(1 + row_lock_wait_count) AS NUMERIC(15,2)) SredniCzasBlokad_ms
FROM sys.dm_db_index_operational_stats (db_id(), NULL, NULL, NULL) s JOIN sys.indexes i
ON i.object_id = s.object_id AND i.index_id = s.index_id
WHERE OBJECTPROPERTY(s.object_id, 'IsUserTable') = 1
ORDER BY row_lock_wait_count desc
GO

SELECT counter_name, cntr_value
FROM sys.dm_os_performance_counters
WHERE counter_name = 'Latch Waits/sec'
OR counter_name = 'Average Latch Wait Time (ms)'  
GO
SELECT counter_name, SUM(cntr_value)
FROM sys.dm_os_performance_counters
WHERE counter_name = 'Lock Waits/sec'
OR counter_name = 'Lock Wait Time (ms)'
OR counter_name = 'Lock Requests/sec'  
GROUP BY counter_name
GO
SELECT counter_name, SUM(cntr_value)
FROM sys.dm_os_performance_counters
WHERE counter_name = 'Lock Timeouts/sec'
OR counter_name = 'Number of Deadlocks/sec' 
GROUP BY counter_name
GO
SELECT t1.request_session_id, t1.resource_type, t1.resource_database_id as dbid, 
(CASE resource_type  WHEN 'OBJECT' THEN object_name(t1.resource_associated_entity_id) 
WHEN 'DATABASE' THEN ' ' 
ELSE (select object_name(object_id) 
FROM sys.partitions 
WHERE hobt_id=resource_associated_entity_id) END), 
t1.resource_description, t1.request_mode, t1.request_status, t2.blocking_session_id 
FROM sys.dm_tran_locks t1 LEFT OUTER JOIN sys.dm_os_waiting_tasks t2 
ON t1.lock_owner_address = t2.resource_address
GO
SELECT t1.resource_type, db_name(resource_database_id),t1.resource_associated_entity_id, t1.request_mode, t1.request_session_id, t2.wait_duration_ms,
(SELECT text FROM sys.dm_exec_requests as r    
CROSS APPLY sys.dm_exec_sql_text(r.sql_handle) 
WHERE r.session_id = t1.request_session_id) ,
(SELECT SUBSTRING(qt.text,r.statement_start_offset/2, 
(CASE WHEN r.statement_end_offset = -1 THEN LEN(CONVERT(NVARCHAR(MAX), qt.text)) * 2 
ELSE r.statement_end_offset end - r.statement_start_offset)/2) 
FROM sys.dm_exec_requests as r
CROSS APPLY sys.dm_exec_sql_text(r.sql_handle) as qt
WHERE r.session_id = t1.request_session_id) , 
t2.blocking_session_id, 
(SELECT text FROM sys.sysprocesses as p
CROSS APPLY sys.dm_exec_sql_text(p.sql_handle) 
WHERE p.spid = t2.blocking_session_id)
FROM sys.dm_tran_locks as t1, sys.dm_os_waiting_tasks as t2
WHERE t1.lock_owner_address = t2.resource_address
GO
EXEC sp_configure 'show advanced options',1
RECONFIGURE
EXEC sp_configure 'blocked process threshold',10
RECONFIGURE
EXEC sp_configure 'show advanced options',0
RECONFIGURE
GO
declare @rc int
declare @TraceID int
declare @maxfilesize bigint
set @maxfilesize = 5 

exec sp_trace_create @TraceID output, 0, N'C:\PerfLogs\Lock', @maxfilesize, NULL 

declare @on bit
set @on = 1
exec sp_trace_setevent @TraceID, 137, 3, @on
exec sp_trace_setevent @TraceID, 137, 15, @on
exec sp_trace_setevent @TraceID, 137, 51, @on
exec sp_trace_setevent @TraceID, 137, 4, @on
exec sp_trace_setevent @TraceID, 137, 24, @on
exec sp_trace_setevent @TraceID, 137, 32, @on
exec sp_trace_setevent @TraceID, 137, 60, @on
exec sp_trace_setevent @TraceID, 137, 64, @on
exec sp_trace_setevent @TraceID, 137, 1, @on
exec sp_trace_setevent @TraceID, 137, 13, @on
exec sp_trace_setevent @TraceID, 137, 41, @on
exec sp_trace_setevent @TraceID, 137, 22, @on
exec sp_trace_setevent @TraceID, 137, 26, @on

exec sp_trace_setstatus @TraceID, 1
select TraceID=@TraceID
GO
EXEC sp_trace_setstatus 2, 0
EXEC sp_trace_setstatus 2, 2
SELECT Textdata, DatabaseID, TransactionID, SPID, Duration
FROM fn_trace_gettable ('C:\PerfLogs\Lock.trc' , 1)
ORDER BY Duration DESC
GO

WITH Trace AS
(SELECT CAST(Textdata AS VARCHAR(MAX)) AS Instrukcja, SUM(Duration) AS Czas
FROM fn_trace_gettable ('C:\PerfLogs\SQL.trc' , 1)
GROUP BY CAST(Textdata AS VARCHAR(MAX)))
SELECT *
FROM Trace
ORDER BY Czas DESC
GO
WITH Trace AS
(SELECT dbo.ufnRegex(Textdata,
N'([\s,(=<>!](?![^\]]+[\]]))(?:(?:(?:(?#    
)(?:([N])?('')(?:[^'']|'''')*(''))(?#      
)|(?:0x[\da-fA-F]*)(?#                     
)|(?:[-+]?(?:(?:[\d]*\.[\d]*|[\d]+)(?#      
)(?:[eE]?[\d]*)))(?#                        
)|(?:[~]?[-+]?(?:[\d]+))(?#                
))(?:[\s]?[\+\-\*\/\%\&\|\^][\s]?)?)+(?#   
))',
N'$1$2$3#$4') AS Sygnatura, Duration AS Czas
FROM fn_trace_gettable ('C:\PerfLogs\SQL.trc' , 1))
SELECT CAST(Sygnatura AS VARCHAR(MAX)) AS Sygnatura, SUM (Czas)
FROM Trace 
GROUP BY Sygnatura
ORDER BY SUM (Czas) DESC
GO
WITH Trace AS
(SELECT dbo.ufnRegex(Textdata,
N'([\s,(=<>!](?![^\]]+[\]]))(?:(?:(?:(?#    
)(?:([N])?('')(?:[^'']|'''')*(''))(?#      
)|(?:0x[\da-fA-F]*)(?#                     
)|(?:[-+]?(?:(?:[\d]*\.[\d]*|[\d]+)(?#      
)(?:[eE]?[\d]*)))(?#                        
)|(?:[~]?[-+]?(?:[\d]+))(?#                
))(?:[\s]?[\+\-\*\/\%\&\|\^][\s]?)?)+(?#   
))',
N'$1$2$3#$4') AS Sygnatura, Duration AS Czas
FROM fn_trace_gettable ('C:\PerfLogs\SQL.trc' , 1))
SELECT CAST(Sygnatura AS VARCHAR(MAX)) AS Sygnatura, SUM (Czas) AS Czas,
100. * SUM(Czas) / SUM(SUM(Czas)) OVER() AS Procent,
ROW_NUMBER() OVER(ORDER BY SUM(Czas) DESC) AS rn
FROM Trace 
GROUP BY Sygnatura
ORDER BY SUM (Czas) DESC
GO