USE AdventureWorks
SELECT SC.Name
FROM Production.ProductSubcategory SC
WHERE SC.ProductSubcategoryID = 
(SELECT P.ProductSubcategoryID
FROM Production.Product P
WHERE P.Name LIKE 'Road-150 Red, 44')
GO
SELECT SC.Name
FROM Production.ProductSubcategory SC
WHERE SC.ProductSubcategoryID = 
(SELECT P.ProductSubcategoryID
FROM Production.Product P
WHERE P.Name LIKE 'Road-150 Red%')
GO
SELECT SC.Name
FROM Production.ProductSubcategory SC
WHERE SC.ProductSubcategoryID IN 
(SELECT P.ProductSubcategoryID
FROM Production.Product P
WHERE P.Name LIKE 'A%')
GO
SELECT MAX(OrderDate)
FROM Sales.SalesOrderHeader
WHERE YEAR(OrderDate) = 2004
GROUP BY YEAR(OrderDate), MONTH(OrderDate)
GO
SELECT SalesOrderID,OrderDate,CustomerID
FROM Sales.SalesOrderHeader
WHERE OrderDate IN
(SELECT MAX(OrderDate)
FROM Sales.SalesOrderHeader
WHERE YEAR(OrderDate) = 2004
GROUP BY YEAR(OrderDate), MONTH(OrderDate))
GO

SELECT DISTINCT C.LastName, C.FirstName 
FROM Person.Contact C JOIN HumanResources.Employee E 
ON E.ContactID = C.ContactID 
WHERE EmployeeID IN 
(SELECT SalesPersonID 
FROM Sales.SalesOrderHeader 
WHERE SalesOrderID IN 
(SELECT SalesOrderID 
FROM Sales.SalesOrderDetail 
WHERE ProductID IN 
(SELECT ProductID 
FROM Production.Product P 
WHERE P.Name LIKE'Road-650 Black%')))
GO

SELECT S1.Title, S1.EmployeeID, S1.VacationHours
FROM HumanResources.Employee S1
WHERE S1.VacationHours = 
(SELECT MAX(S2.VacationHours)
FROM HumanResources.Employee S2)
GO
SELECT S1.Title, S1.EmployeeID, S1.VacationHours
FROM HumanResources.Employee S1
WHERE S1.VacationHours = 
(SELECT MAX(S2.VacationHours)
FROM HumanResources.Employee S2
WHERE S2.VacationHours <
(SELECT MAX(S3.VacationHours)
FROM HumanResources.Employee S3))
GO
SELECT COUNT(DISTINCT(S2.VacationHours))
FROM HumanResources.Employee S2
WHERE S2.VacationHours > 98
GO
SELECT S1.Title, S1.EmployeeID, S1.VacationHours
FROM HumanResources.Employee S1
WHERE 1 = 
(SELECT COUNT(DISTINCT(S2.VacationHours))
FROM HumanResources.Employee S2
WHERE S2.VacationHours >S1.VacationHours)
GO

SELECT TOP 5 WITH TIES OH.SalesOrderID, SUM(TotalDue) 
FROM Sales.SalesOrderHeader OH 
WHERE OH.SalesOrderID NOT IN
(SELECT TOP 10 S.SalesOrderID 
FROM Sales.SalesOrderHeader S 
GROUP BY S.SalesOrderID
ORDER BY SUM(TotalDue) DESC)
GROUP BY OH.SalesOrderID
ORDER BY SUM(TotalDue) DESC
GO

SELECT CustomerID
FROM Sales.Customer SC
WHERE EXISTS (SELECT CustomerID FROM Sales.SalesOrderHeader OH
WHERE SC.CustomerID = OH.CustomerID)

SELECT CustomerID
FROM Sales.Customer SC
WHERE EXISTS (SELECT * FROM Sales.SalesOrderHeader OH
WHERE SC.CustomerID = OH.CustomerID)
GO
SELECT CustomerID 
FROM Sales.Customer SC
WHERE EXISTS 
(SELECT * 
FROM Sales.SalesOrderHeader OH
WHERE SC.CustomerID = OH.CustomerID)

SELECT CustomerID 
FROM Sales.Customer SC
WHERE CustomerID IN 
(SELECT  CustomerID
FROM Sales.SalesOrderHeader OH
WHERE SC.CustomerID = OH.CustomerID)
GO

SELECT C.CreditCardID
FROM Sales.CreditCard C
WHERE EXISTS 
(SELECT *
FROM Sales.CreditCard S1
WHERE C.CreditCardID <> S1.CreditCardID
AND C.CardType = S1.CardType
AND C.CardNumber = S1.CardNumber)  
GO

SELECT ProductID
FROM Production.Product P
WHERE NOT EXISTS 
(SELECT ProductID
FROM Production.Product S1
WHERE S1.ProductID = P.ProductID+1)
GO
SELECT ProductID+1
FROM Production.Product P
WHERE NOT EXISTS 
(SELECT ProductID
FROM Production.Product S1
WHERE S1.ProductID = P.ProductID+1)
AND ProductID < 
(SELECT MAX(ProductID)
FROM Production.Product S2)
GO

SELECT Gender, DATEDIFF(YY, BirthDate, GETDATE()) AS Wiek, COUNT(EmployeeID) AS LiczbaPracownikw
FROM HumanResources.Employee
GROUP BY Gender, DATEDIFF(YY, BirthDate, GETDATE())
GO
SELECT Gender, DATEDIFF(YY, BirthDate, GETDATE()) AS Wiek, COUNT(EmployeeID) AS LiczbaPracownikw
FROM HumanResources.Employee
GROUP BY Gender, Wiek
GO
SELECT Gender,Wiek, COUNT(EmployeeID) AS LiczbaPracownikw
FROM
(SELECT Gender, DATEDIFF(YY, BirthDate, GETDATE()) AS Wiek ,EmployeeID
FROM HumanResources.Employee) AS S1
GROUP BY Gender, Wiek
GO

SELECT *
FROM 
(SELECT ROW_NUMBER() OVER(ORDER BY TotalDue DESC) AS Numer, TotalDue, SalesOrderID,OrderDate
FROM Sales.SalesOrderHeader) S1
WHERE Numer BETWEEN 11 AND 15
ORDER BY Numer
GO

SELECT OrderDate, TotalDue
FROM Sales.SalesOrderHeader AS S1
WHERE TotalDue >= 1000
GO
SELECT OrderDate, TotalDue,
(SELECT MIN(OrderDate)
FROM Sales.SalesOrderHeader AS S2
WHERE S2.OrderDate > S1.OrderDate
AND TotalDue < 1000) AS G
FROM Sales.SalesOrderHeader AS S1
WHERE TotalDue >= 1000
GO
SELECT MIN(OrderDate) AS DataOd, MAX(OrderDate) AS DataDo,
DATEDIFF(day, MIN(OrderDate), MAX(OrderDate)) + 1 AS Dni, MAX(TotalDue) 
FROM 
(SELECT OrderDate, TotalDue,
(SELECT MIN(OrderDate)
 FROM Sales.SalesOrderHeader AS S2
WHERE S2.OrderDate > S1.OrderDate
AND TotalDue < 1000) AS G
FROM Sales.SalesOrderHeader AS S1
WHERE TotalDue >= 1000) AS D
GROUP BY G
ORDER BY Dni DESC
GO

WITH CTE1 AS
(SELECT Gender, DATEDIFF(YY, BirthDate, GETDATE()) AS Wiek ,EmployeeID
FROM HumanResources.Employee)
SELECT Gender,Wiek, COUNT(EmployeeID) AS LiczbaPracownikw
FROM CTE1
GROUP BY Gender, Wiek
GO
WITH Lista AS
(SELECT ProductID, DueDate, UnitPrice, 
NTILE(4) OVER (ORDER BY UnitPrice DESC) as Kategoria
FROM Purchasing.PurchaseOrderDetail
WHERE DueDate <'20020101'
)
SELECT *
FROM Lista
WHERE Kategoria = '1'
GO
WITH CTE1 AS 
(SELECT TotalDue, NTILE(5) OVER(ORDER BY TotalDue DESC) AS Sprzedaz
FROM Sales.SalesOrderHeader)
SELECT Sprzedaz, MIN(TotalDue), MAX(TotalDue), AVG(TotalDue)
FROM CTE1
GROUP BY Sprzedaz
ORDER BY Sprzedaz
GO
WITH CTE1 AS
(SELECT CustomerID, TotalDue, YEAR(OrderDate) AS Rok
FROM Sales.SalesOrderHeader),
CTE2 AS
(SELECT CustomerID, Rok, SUM(TotalDue) AS Suma
FROM CTE1
GROUP BY CustomerID, Rok)
SELECT TOP 5 *
FROM CTE2
ORDER BY Suma DESC
GO

DECLARE @LiczbaWierszy int
DECLARE @Przelozeni TABLE
(Pracownik int, Przelozony int, P int default 0)
 
INSERT @Przelozeni
SELECT EmployeeID, ManagerID, 0 FROM HumanResources.Employee
WHERE ManagerID IS NULL
SET @LiczbaWierszy = @@rowcount
--dodajemy wszystkich podwadnych danej osoby
WHILE @LiczbaWierszy > 0
BEGIN
--oznaczamy dodanych pracownikw
UPDATE @Przelozeni 
SET P = 1 
WHERE P = 0
--dopisujemy nowych przeoonych
INSERT @Przelozeni
SELECT EmployeeID, ManagerID, 0
FROM HumanResources.Employee E
INNER JOIN @Przelozeni R ON E.ManagerID = R.Pracownik
WHERE ManagerID <> EmployeeID and R.P = 1
SET @LiczbaWierszy = @@rowcount
--oznaczamy przeoonych, ktrych podwadni zostali ju dodani
UPDATE @Przelozeni SET P = 2 WHERE P = 1
END
SELECT Pracownik, Przelozony 
FROM @Przelozeni
ORDER BY Przelozony
GO
WITH Przelozeni AS
(SELECT ManagerID, EmployeeID, 0 as Pozycja
FROM HumanResources.Employee
WHERE ManagerID IS NULL
UNION ALL
SELECT e.ManagerID, e.EmployeeID, CTE1.Pozycja+1
FROM HumanResources.Employee AS E
INNER JOIN Przelozeni AS CTE1 ON
E.ManagerID = CTE1.EmployeeID )
SELECT * FROM Przelozeni
ORDER BY ManagerID
GO

WITH CTE1 AS
(SELECT i = 1
UNION All
SELECT i = i + 1 
FROM CTE1 
WHERE i < 5000 )
SELECT i
FROM CTE1
ORDER BY i
GO
WITH CTE1 AS
(SELECT i = 1
UNION All
SELECT i = i + 1 
FROM CTE1 
WHERE i < 5000 )
SELECT i
FROM CTE1
ORDER BY i
OPTION (MAXRECURSION 0)
GO

DECLARE @str varchar(2000)
SELECT @str = ' Zawierajce dodatkowe spacje  dane tekstowe musz by analizowane  wyraz po   wyrazie';

WITH Wyrazy AS 
(SELECT 1 as Start, CHARINDEX (' ',@str, 1) as Koniec 
UNION ALL 
SELECT Koniec + 1, CHARINDEX (' ',@str, Koniec + 1)
FROM Wyrazy 
WHERE Koniec > 0)

SELECT Start, Koniec, 
SUBSTRING(@str, Start, Koniec - Start) AS Wyraz 
INTO #Wyrazy
FROM Wyrazy 
WHERE Koniec > 0 
UNION ALL
SELECT MAX(Koniec) + 1, 0, RIGHT(@str, LEN(@str) - MAX(Koniec))
FROM Wyrazy

DELETE #Wyrazy WHERE Wyraz = ''

SELECT * FROM #Wyrazy
DROP TABLE #Wyrazy
GO