USE AdventureWorks
SELECT AVG(VacationHours), AVG( DISTINCT VacationHours)
FROM HumanResources.Employee
GO
SELECT CHECKSUM_AGG(CAST(ListPrice AS INT)), CHECKSUM_AGG( DISTINCT CAST(ListPrice AS INT))
FROM Production.Product
GO
SELECT COUNT(*), COUNT(Color), COUNT (DISTINCT (Color))
FROM Production.Product
GO
SELECT MAX(SellStartDate), MAX( Name)
FROM Production.Product
GO
SELECT MIN(SellStartDate), MIN( Name)
FROM Production.Product
GO
SELECT SUM(ListPrice), SUM(DISTINCT ListPrice)
FROM Production.Product
GO

SELECT Title, AVG(VacationHours)
FROM HumanResources.Employee
GROUP BY Title
GO
SELECT SC.Name, SUM(ListPrice)
FROM Production.Product P JOIN Production.ProductSubcategory SC
ON P.ProductSubcategoryID = SC.ProductSubcategoryID
GROUP BY SC.Name
GO
SELECT ProductSubcategoryID,ProductModelID , MAX(ListPrice)
FROM Production.Product
GROUP BY ProductSubcategoryID,ProductModelID
GO

SELECT OrderDate, CustomerID, SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2003
GROUP BY OrderDate, CustomerID
GO
SELECT OrderDate, CustomerID, SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2003
GROUP BY OrderDate, CustomerID
WITH CUBE
GO
SELECT OrderDate, CustomerID, SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2003
GROUP BY OrderDate, CustomerID
WITH ROLLUP 
GO
SELECT OrderDate, CustomerID, GROUPING(CustomerID), SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2003
GROUP BY OrderDate, CustomerID
WITH ROLLUP
GO

SELECT Title, AVG(VacationHours)
FROM HumanResources.Employee
GROUP BY Title
HAVING AVG(VacationHours)>90
GO
SELECT PM.Name, COUNT(P.ProductID)
FROM Production.Product P JOIN Production.ProductModel PM
ON P.ProductModelID=PM.ProductModelID
GROUP BY PM.Name
HAVING COUNT(P.ProductID)>10
GO

SELECT SalesOrderID, TotalDue, 
AVG(TotalDue) OVER() AS Srednia,
TotalDue - AVG(TotalDue) OVER() AS Roznica,
MIN(TotalDue) OVER() AS Minimum,
MAX(TotalDue) OVER() AS Maksimum
FROM Sales.SalesOrderHeader
GO
SELECT [Group], Name,
SUM(salesytd) OVER (PARTITION BY [Group], [Name]),
SUM(salesytd) OVER (PARTITION BY [Group]) ,
(SUM(salesytd) OVER (PARTITION BY [Group], [Name]) / SUM(salesytd) OVER (PARTITION BY [Group])) * 100.0 
FROM Sales.SalesTerritory 
ORDER BY [Group]
GO

SELECT FirstName, ROW_NUMBER() OVER(ORDER BY FirstName),
RANK() OVER(ORDER BY FirstName),
DENSE_RANK() OVER(ORDER BY FirstName),
NTILE(3) OVER (ORDER BY FirstName) 
FROM Person.Contact
WHERE FirstName IN ('Tai','Juanita')
GO
SELECT rowguid,ROW_NUMBER() OVER (ORDER BY rowguid) AS numer
FROM Person.Contact
ORDER BY rowguid

SELECT rowguid,
(SELECT COUNT(*) FROM Person.Contact AS T2 WHERE T2.rowguid <=T1.rowguid) AS numer
FROM Person.Contact AS T1
ORDER BY rowguid
GO
SELECT FirstName, Title, ROW_NUMBER() OVER (PARTITION BY Title ORDER BY FirstName)
FROM Person.Contact
WHERE ContactID <10
ORDER BY Title
GO
SELECT ProductID, DueDate, UnitPrice, 
NTILE(4) OVER (ORDER BY UnitPrice DESC) as kategoria
FROM Purchasing.PurchaseOrderDetail
WHERE DueDate <'20020101'
ORDER BY UnitPrice DESC
GO
SELECT ProductID, DueDate, UnitPrice, 
CASE NTILE(4) OVER (ORDER BY UnitPrice DESC) 
WHEN 1 THEN 'Najdrosze'
WHEN 2 THEN 'Drogie'
WHEN '3' THEN 'Tanie'
ELSE 'Najtasze' END as kategoria
FROM Purchasing.PurchaseOrderDetail
WHERE DueDate <'20020101'
ORDER BY UnitPrice DESC
GO

SELECT OD.ProductID, YEAR(H.OrderDate) AS Rok, SUM(OD.LineTotal) AS Sprzeda
--INTO #Tab
FROM Sales.SalesOrderDetail OD JOIN Sales.SalesOrderHeader H 
ON OD.SalesOrderID = H. SalesOrderID
WHERE OD.ProductID IN (723,945,949)
GROUP BY OD.ProductID, YEAR(H.orderdate)
ORDER BY OD.ProductID, YEAR(H.orderdate)
GO
SELECT OD.ProductID, YEAR(H.OrderDate) AS Rok, SUM(OD.LineTotal) AS Sprzeda
INTO #Tab
FROM Sales.SalesOrderDetail OD JOIN Sales.SalesOrderHeader H 
ON OD.SalesOrderID = H. SalesOrderID
WHERE OD.ProductID IN (723,945,949)
GROUP BY OD.ProductID, YEAR(H.orderdate)
ORDER BY OD.ProductID, YEAR(H.orderdate)

SELECT P.ProductID, [2001], [2002],[2003], [2004]
--INTO #PIV
FROM  #Tab
PIVOT ( 
SUM(Sprzeda)
FOR Rok IN ([2001], [2002], [2003], [2004]) ) AS P
ORDER BY P.ProductID
GO
DECLARE @ListaLat VARCHAR(MAX)
DECLARE @Lata TABLE (Rok int)

INSERT INTO @Lata (Rok)
SELECT DISTINCT YEAR(DueDate)
FROM Purchasing.PurchaseOrderDetail
ORDER BY YEAR(DueDate) 

SELECT @ListaLat = COALESCE (@ListaLat + ',[', '[') + CAST(Rok AS CHAR(4)) + ']' 
FROM @Lata

EXEC ('SELECT *
FROM (SELECT ProductID, YEAR(DueDate) Rok, OrderQty 
FROM Purchasing.PurchaseOrderDetail
WHERE ProductID < 320) Podzapytanie
PIVOT (SUM(OrderQty) FOR Rok IN (' + @ListaLat + ')) P')
GO

SELECT P.ProductID, [2001], [2002],[2003], [2004]
INTO #PIV
FROM  #Tab
PIVOT ( 
SUM(Sprzeda)
FOR Rok IN ([2001], [2002], [2003], [2004]) ) AS P
ORDER BY P.ProductID

SELECT ProductID, Rok, Sprzeda
FROM #PIV
UNPIVOT (Sprzeda FOR Rok IN ([2001], [2002], [2003], [2004])) U
GO