USE AdventureWorks
SELECT TOP (10) PERCENT WITH TIES Production.ProductSubcategory.Name, Production.Product.ListPrice
FROM Production.Product INNER JOIN Production.ProductSubcategory 
ON Production.Product.ProductSubcategoryID = Production.ProductSubcategory.ProductSubcategoryID 
INNER JOIN Production.ProductCategory 
ON Production.ProductSubcategory.ProductCategoryID = Production.ProductCategory.ProductCategoryID
WHERE     (Production.ProductCategory.Name = N'Bikes')
ORDER BY Production.Product.ListPrice DESC
GO
SELECT [EmployeeID],[Title],[FirstName],[MiddleName],[LastName],[Suffix],[JobTitle],
[Phone],[EmailAddress],[EmailPromotion],[AddressLine1],[AddressLine2],[City],
[StateProvinceName],[PostalCode],[CountryRegionName],[AdditionalContactInfo]
FROM [AdventureWorks].[HumanResources].[vEmployee]
GO

SELECT *
FROM Production.Product
WHERE ProductSubcategoryID !=1 AND
(Name LIKE 'C%' OR Name LIKE '%e_') AND
ListPrice BETWEEN 100 AND 500 AND
Color IN ('Black', 'White') AND
SellEndDate IS NOT NULL
GO
SET STATISTICS IO ON
SELECT * 
FROM Sales.SalesOrderHeader
WHERE CustomerID <=3
 
SELECT * 
FROM Sales.SalesOrderHeader
WHERE NOT CustomerID >3
GO
SELECT * 
FROM Sales.SalesOrderHeader
WHERE CustomerID <2-0

SELECT * 
FROM Sales.SalesOrderHeader
WHERE CustomerID+0 <2
GO
SELECT *
FROM Sales.SalesOrderHeader 
WHERE SalesOrderNumber='SO43860'

SELECT *
FROM Sales.SalesOrderHeader
WHERE UPPER(SalesOrderNumber)='SO43860'
GO
SELECT *
FROM Sales.SalesOrderHeader 
WHERE SalesOrderNumber = 'SO43860'

SELECT *
FROM Sales.SalesOrderHeader
WHERE SalesOrderNumber = 'SO43860' COLLATE Latin1_General_CI_AS
GO
SELECT *
FROM Production.Product
WHERE Name LIKE N'%b'
GO
SELECT *
FROM Production.Product
WHERE Name LIKE N'[H,L]%b'

SELECT *
FROM Production.Product
WHERE Name LIKE N'%b'
GO
SET STATISTICS IO OFF

SELECT EmployeeID, ProductID, Name
FROM HumanResources.Employee, Production.Product
GO
WITH SprzedawcyProdukty AS (
SELECT EmployeeID, ProductID, Name
FROM HumanResources.Employee, Production.Product)

SELECT ROW_NUMBER() OVER (ORDER BY EmployeeID) AS ID, *
INTO #SprzedawcyProdukty
FROM SprzedawcyProdukty
GO

SELECT * FROM #SprzedawcyProdukty
GO

SELECT SalesOrderID, TotalDue, 
(SELECT AVG(TotalDue) FROM Sales.SalesOrderHeader) AS Srednia,
TotalDue - (SELECT AVG(TotalDue) FROM Sales.SalesOrderHeader) AS Roznica,
(SELECT MIN(TotalDue) FROM Sales.SalesOrderHeader) AS Minimum,
(SELECT MAX(TotalDue) FROM Sales.SalesOrderHeader) AS Maksimum
FROM Sales.SalesOrderHeader

SELECT SalesOrderID, TotalDue, Srednia, TotalDue - Srednia, Minimum,Maksimum
FROM Sales.SalesOrderHeader CROSS JOIN
(SELECT AVG(TotalDue) AS Srednia, MIN(TotalDue) AS Minimum, MAX(TotalDue) AS Maksimum
FROM Sales.SalesOrderHeader) AS Podzapytanie
GO

SELECT C.Name, SC.Name, P.Name
FROM Production.ProductCategory C JOIN Production.ProductSubcategory SC
ON C.ProductCategoryID = SC.ProductCategoryID
INNER JOIN Production.Product P
ON P.ProductSubcategoryID = SC.ProductSubcategoryID
GO
SELECT Name, GroupName, EmployeeID
FROM HumanResources.Department D LEFT JOIN HumanResources.EmployeeDepartmentHistory H
ON D.DepartmentID = H.DepartmentID
WHERE EmployeeID IS NULL
GO

SELECT Name, GroupName, H.EmployeeID, LoginID
FROM HumanResources.Department D LEFT JOIN HumanResources.EmployeeDepartmentHistory H
ON D.DepartmentID = H.DepartmentID
INNER JOIN HumanResources.Employee EA
ON EA.EmployeeID = H.EmployeeID
GO
SELECT Name, GroupName, H.EmployeeID, LoginID
FROM HumanResources.Department D LEFT JOIN HumanResources.EmployeeDepartmentHistory H
ON D.DepartmentID = H.DepartmentID
LEFT JOIN HumanResources.Employee EA
ON EA.EmployeeID = H.EmployeeID
GO
SELECT Name, GroupName, H.EmployeeID, LoginID
FROM HumanResources.Department D LEFT JOIN 
(HumanResources.EmployeeDepartmentHistory H
INNER JOIN HumanResources.Employee EA
ON EA.EmployeeID = H.EmployeeID)
ON D.DepartmentID = H.DepartmentID
GO

SELECT C.Name, SC.Name, P.Name
FROM Production.ProductCategory C JOIN Production.ProductSubcategory SC
ON C.ProductCategoryID = SC.ProductCategoryID
INNER JOIN Production.Product P
ON P.ProductSubcategoryID = SC.ProductSubcategoryID
WHERE P.ProductSubcategoryID IN(1,2)
GO
SELECT C.Name, SC.Name, P.Name
FROM Production.ProductCategory C JOIN Production.ProductSubcategory SC
ON C.ProductCategoryID = SC.ProductCategoryID
INNER JOIN Production.Product P
ON P.ProductSubcategoryID = SC.ProductSubcategoryID
WHERE P.ProductSubcategoryID IN(1,2)
OPTION (FORCE ORDER)
GO

SELECT M.LoginID Przelozony, E.LoginID Pracownik
FROM HumanResources.Employee M JOIN HumanResources.Employee E
ON E.ManagerID = M.EmployeeID
GO
SELECT DISTINCT T1.ProductID, T2.VendorID
FROM Purchasing.ProductVendor T1 JOIN Purchasing.ProductVendor T2
ON T1.ProductID = T2.ProductID 
ORDER BY T1.ProductID
GO

SELECT Name
FROM Purchasing.Vendor
UNION 
SELECT Name
FROM Sales.Store
ORDER BY 1
GO
SELECT Name
FROM Purchasing.Vendor
UNION ALL
SELECT Name
FROM Sales.Store
ORDER BY 1
GO
SELECT ListPrice
FROM Production.Product
EXCEPT 
SELECT ListPrice
FROM Production.ProductListPriceHistory
GO
SELECT ListPrice
FROM Production.Product
INTERSECT 
SELECT ListPrice
FROM Production.ProductListPriceHistory
GO

SELECT P.Name, S1.*
FROM Production.Product P
CROSS APPLY (
SELECT TOP 1 PurchaseOrderID, LineTotal, DueDate
FROM Purchasing.PurchaseOrderDetail PU
WHERE PU.ProductID = P.ProductID
ORDER BY DueDate DESC) S1 
ORDER BY P.Name
GO
SELECT P.Name, S1.*
FROM Production.Product P
OUTER APPLY (
SELECT TOP 1 PurchaseOrderID, LineTotal, DueDate
FROM Purchasing.PurchaseOrderDetail PU
WHERE PU.ProductID = P.ProductID
ORDER BY DueDate DESC) S1 
ORDER BY P.Name
GO

SELECT ProductLine, Color,Name, ListPrice
FROM Production.Product
ORDER BY ProductLine, Color, Name
GO
SELECT ProductLine,Color,Name, ListPrice
FROM Production.Product
ORDER BY ProductID
GO
SELECT ProductLine,Color,Name, ListPrice
FROM Production.Product
ORDER BY ProductLine DESC, Color ASC, Name DESC
GO
SELECT ProductLine,Name, ListPrice
FROM Production.Product
ORDER BY CASE 
WHEN ProductLine IS NULL THEN 'X' ELSE ProductLine END,
Name
GO

SELECT SalesOrderID,SalesOrderDetailID,ProductID,LineTotal
FROM Sales.SalesOrderDetail
ORDER BY ProductID

SELECT SalesOrderID,SalesOrderDetailID,ProductID,LineTotal
FROM Sales.SalesOrderDetail
ORDER BY ProductID
OPTION (FAST 100)
GO

SELECT TOP(5) PERCENT WITH TIES Title, Rate
FROM HumanResources.EmployeePayHistory PH JOIN HumanResources.Employee E
ON PH.EmployeeID = E.EmployeeID
ORDER BY Rate DESC
GO
DECLARE @ile int
SET @ile = 5
SELECT TOP(@ile) PERCENT WITH TIES Title, Rate
FROM HumanResources.EmployeePayHistory PH JOIN HumanResources.Employee E
ON PH.EmployeeID = E.EmployeeID
ORDER BY Rate DESC
GO
SELECT TOP
(SELECT COUNT(EmployeeID) FROM HumanResources.EmployeePayHistory WHERE Rate>50)
WITH TIES Title, Rate
FROM HumanResources.EmployeePayHistory PH JOIN HumanResources.Employee E
ON PH.EmployeeID = E.EmployeeID
ORDER BY Rate DESC
GO

SELECT *
FROM Sales.SalesOrderDetail
TABLESAMPLE (10 PERCENT)
GO
SELECT *
FROM Sales.SalesOrderDetail
TABLESAMPLE (10) REPEATABLE (21)
GO