USE tempdb
GO
CREATE SYMMETRIC KEY TestAES
WITH ALGORITHM = AES_256 
ENCRYPTION BY PASSWORD = 'Test09wyKl@$czAES'
OPEN SYMMETRIC KEY TestAES 
DECRYPTION BY PASSWORD = 'Test09wyKl@$czAES'
PRINT EncryptByKey(Key_GUID('TestAES'),'A po suszy szosa sucha');
CLOSE SYMMETRIC KEY TestAES
GO
CREATE SYMMETRIC KEY Test3DES
WITH ALGORITHM = TRIPLE_DES
ENCRYPTION BY PASSWORD = 'Te)(*stowyKl*()cz3DES'
OPEN SYMMETRIC KEY Test3DES 
DECRYPTION BY PASSWORD = 'Te)(*stowyKl*()cz3DES'
PRINT EncryptByKey(Key_GUID('Test3DES'),'A po suszy szosa sucha');
CLOSE SYMMETRIC KEY Test3DES
GO
CREATE SYMMETRIC KEY TestRC4 
WITH ALGORITHM = RC4 
ENCRYPTION BY PASSWORD = 'Tes.897wyKl234czRC4'
OPEN SYMMETRIC KEY TestRC4 
DECRYPTION BY PASSWORD = 'Tes.897wyKl234czRC4'
PRINT EncryptByKey(Key_GUID('TestRC4'),'A po suszy szosa sucha')
PRINT EncryptByKey(Key_GUID('TestRC4'),'A po suszy szosa sucha')
PRINT EncryptByKey(Key_GUID('TestRC4'),'A po suszy szosa sucha')
CLOSE SYMMETRIC KEY TestRC4
GO
CREATE CERTIFICATE TestCert
ENCRYPTION BY PASSWORD = 'Te)(*stowyKl*()Certy908fikatRSA'
WITH SUBJECT = 'Testowy certyfikat', EXPIRY_DATE = '10/31/2009'
GO
BACKUP CERTIFICATE TestCert 
TO FILE = 'c:\Backup\TestCert.cer'
GO

USE AdventureWorks
SELECT Title, HashBytes('SHA1', Title)
FROM HumanResources.Employee
GO
BACKUP SERVICE MASTER KEY TO FILE = 'g:\SMK.KEY' 
ENCRYPTION BY PASSWORD = 'T0Hasl,.oMusi%$3BykjcNapraw890$#$deBe=-"zpiecz89nE!'
GO
ALTER SERVICE MASTER KEY REGENERATE
GO
RESTORE SERVICE MASTER KEY FROM FILE = 'g:\SMK.KEY' 
DECRYPTION BY PASSWORD = 'T0Hasl,.oMusi%$3BykjcNapraw890$#$deBe=-"zpiecz89nE!'
GO
ALTER SERVICE MASTER KEY 
WITH OLD_ACCOUNT = 'sqlsrv', OLD_PASSWORD = 'TajnEhas0:)'
GO
ALTER SERVICE MASTER KEY
FORCE REGENERATE
-- lub
RESTORE SERVICE MASTER KEY
FROM FILE = 'g:\SMK.KEY' 
DECRYPTION BY PASSWORD = 'T0Hasl,.oMusi%$3BykjcNapraw890$#$deBe=-"zpiecz89nE!'
FORCE
GO

CREATE DATABASE db2
GO
USE db2
GO
CREATE MASTER KEY
ENCRYPTION BY PASSWORD = 'ToPowinnoBycInnE,R0wnieSilneH@sl0!'
GO
SELECT name, algorithm_desc 
FROM sys.symmetric_keys
GO
SELECT name, is_master_key_encrypted_by_server 
FROM sys.databases 
WHERE database_id > 5
GO
BACKUP MASTER KEY TO FILE = 'g:\DBK.KEY' 
ENCRYPTION BY PASSWORD = 'K09jRm,YsdeSiopEI00M+_IdfsSI43E'
GO
CREATE CERTIFICATE Cert1
WITH SUBJECT = 'Test odszyfrowania DBK przez SMK'
SELECT name, pvt_key_encryption_type_desc 
FROM sys.certificates
GO
ALTER MASTER KEY 
DROP ENCRYPTION BY SERVICE MASTER KEY
CREATE CERTIFICATE Cert2
WITH SUBJECT = 'Test odszyfrowania DBK przez SMK'
GO
OPEN MASTER KEY DECRYPTION BY PASSWORD = 'ToPowinnoBycInnE,R0wnieSilneH@sl0!'
CREATE CERTIFICATE Cert2
WITH SUBJECT = 'Test odszyfrowania DBK przez SMK'
CLOSE MASTER KEY
GO
OPEN MASTER KEY DECRYPTION BY PASSWORD = 'ToPowinnoBycInnE,R0wnieSilneH@sl0!'
ALTER MASTER KEY 
ADD ENCRYPTION BY SERVICE MASTER KEY 
CLOSE MASTER KEY
GO

CREATE CERTIFICATE CertS1
AUTHORIZATION dbo
WITH SUBJECT = 'Certyfikat chronicy klucz symetryczny' 
GO
CREATE SYMMETRIC KEY SKey1 
AUTHORIZATION dbo
WITH ALGORITHM = TRIPLE_DES 
ENCRYPTION BY CERTIFICATE CertS1
GO

OPEN SYMMETRIC KEY SKey1 DECRYPTION BY CERTIFICATE CertS1 
SELECT database_name, key_name 
FROM sys.openkeys
GO
CREATE CERTIFICATE CertTemp 
WITH SUBJECT = 'Tymczasowy certyfikat chronicy klucz SKey1' 
ALTER SYMMETRIC KEY SKey1 ADD ENCRYPTION BY CERTIFICATE CertTemp
ALTER SYMMETRIC KEY SKey1 DROP ENCRYPTION BY CERTIFICATE CertS1 
DROP CERTIFICATE CertS1
CREATE CERTIFICATE CertS1 
AUTHORIZATION dbo
WITH SUBJECT = 'Certyfikat chronicy klucz symetryczny v.2' 
ALTER SYMMETRIC KEY SKey1 ADD ENCRYPTION BY CERTIFICATE CertS1
ALTER SYMMETRIC KEY SKey1 DROP ENCRYPTION BY CERTIFICATE CertTemp 
DROP CERTIFICATE CertTemp
CLOSE ALL SYMMETRIC KEYS
GO
BACKUP CERTIFICATE CertS1 
TO FILE = 'g:\CertS1.cer'
WITH PRIVATE KEY
(FILE = 'g:\KeyS1.KEY',
ENCRYPTION BY PASSWORD = 'DE5@#$vfr^dEy*(&DftS)')
GO

CREATE CERTIFICATE CertS2 
WITH SUBJECT = 'Certyfikat chroniacy klucz symetryczny' 
CREATE SYMMETRIC KEY SKey2 
WITH ALGORITHM = TRIPLE_DES,
KEY_SOURCE = 'KDF9384939834kjf02930sd9f09r04395,c03945039102,c59mncxvSZUIE49CVGKSL38493KALSA;W=1-2',
IDENTITY_VALUE = 'Klucz Marcina' 
ENCRYPTION BY CERTIFICATE CertS2
GO
SELECT key_guid 
FROM sys.symmetric_keys
WHERE name = 'Skey2'
GO
CREATE TABLE T1
(K1 varbinary(100))
GO
OPEN SYMMETRIC KEY SKey2 
DECRYPTION BY CERTIFICATE CertS2 
INSERT INTO T1
VALUES (EncryptByKey(Key_GUID('SKey2'),'Tajne dane'))
CLOSE ALL SYMMETRIC KEYS 
GO
BACKUP CERTIFICATE CertS2 
TO FILE = 'c:\backup\CertS2.cer'
WITH PRIVATE KEY
(FILE = 'c:\backup\KeyS2.KEY',
ENCRYPTION BY PASSWORD = 'DE5@#$vfr^dEy*(&DftS)')
GO
CREATE DATABASE db3
GO
USE db3
GO
CREATE MASTER KEY
ENCRYPTION BY PASSWORD = 'd903M[90328rA93048R9dsfC92385I09asdN'
GO
CREATE CERTIFICATE CertS2 
FROM FILE = 'c:\backup\CertS2.cer'
WITH PRIVATE KEY 
(FILE = 'c:\backup\KeyS2.KEY', 
DECRYPTION BY PASSWORD = 'DE5@#$vfr^dEy*(&DftS)')
GO
CREATE SYMMETRIC KEY SKey2 
WITH ALGORITHM = TRIPLE_DES,
KEY_SOURCE = 'KDF9384939834kjf02930sd9f09r04395,c03945039102,c59mncxvSZUIE49CVGKSL38493KALSA;W=1-2',
IDENTITY_VALUE = 'Klucz Marcina' 
ENCRYPTION BY CERTIFICATE CertS2
GO
SELECT key_guid 
FROM sys.symmetric_keys
WHERE name = 'Skey2'
GO
SELECT *
INTO t1
FROM db2.dbo.t1
GO
OPEN SYMMETRIC KEY SKey2 
DECRYPTION BY CERTIFICATE CertS2 
SELECT CAST(DecryptByKey(k1) AS VARCHAR(50))
FROM t1
CLOSE ALL SYMMETRIC KEYS
GO

USE db2
CREATE CERTIFICATE CertMAC WITH SUBJECT = 'Ochrona klucza MAC'
CREATE SYMMETRIC KEY SKeyMAC 
WITH ALGORITHM = TRIPLE_DES
ENCRYPTION BY CERTIFICATE CertMAC
GO
CREATE TABLE tMac
(TblID INT PRIMARY KEY, 
Mac VARBINARY(100) NOT NULL)
GO
OPEN SYMMETRIC KEY SKeyMAC 
DECRYPTION BY CERTIFICATE CertMAC
INSERT INTO tMac
VALUES (1,EncryptByKey(Key_GUID('SKeyMAC'),CAST(NewID() AS VARCHAR(100))))
CLOSE ALL SYMMETRIC KEYS
GO
SELECT * 
FROM tMac
GO
CREATE FUNCTION fMac(@Dane NVARCHAR(4000), @TblID INT )
RETURNS BINARY(24)
WITH EXECUTE AS 'dbo'
AS
BEGIN
  DECLARE @Key VARBINARY(100)
  SET @Key = NULL
  SELECT @Key = DecryptByKeyAutoCert(cert_id('CertMAC'), NULL, Mac)
  FROM tMac 
  WHERE TblID = @TblID
  RETURN (HashBytes( N'SHA1', CONVERT(VARBINARY(8000), @Dane) + @Key))
 END
GO
SELECT EmployeeID, Title
INTO Emp
FROM AdventureWorks.HumanResources.Employee
GO
ALTER TABLE Emp
ADD Mac binary(24)
GO
UPDATE Emp
SET Mac = dbo.fMac(Title,1)
GO
UPDATE dbo.Emp 
SET Title = 'Design Engineer' 
WHERE EmployeeID=4
GO
SELECT EmployeeID, Title
FROM Emp
WHERE Mac <> dbo.fMac(Title,1)
GO

CREATE PROC TrTbl
AS
SELECT name,type 
FROM sys.user_token
TRUNCATE TABLE dbo.T1
GO
CREATE USER Danka
GRANT EXECUTE ON TrTbl TO Danka
GO
EXECUTE AS LOGIN = 'Danka'
EXEC TrTbl
GO
REVERT
CREATE CERTIFICATE CertSign 
WITH SUBJECT = 'Podpisuje proc TrTbl'
GO
ADD SIGNATURE TO TrTbl 
BY CERTIFICATE CertSign
GO
CREATE USER uCertSign 
FROM CERTIFICATE CertSign
GO
GRANT ALTER ON dbo.T1
TO uCertSign
GO
EXECUTE AS LOGIN = 'Danka'
EXEC TrTbl
GO
REVERT
GO
ALTER PROC TrTbl
AS
SELECT principal_id, name,type FROM sys.user_token
TRUNCATE TABLE dbo.T1
GO
EXECUTE AS LOGIN = 'Danka'
EXEC TrTbl
GO
REVERT
GO

CREATE LOGIN Marcin WITH PASSWORD='PusteHasl0'
GO
CREATE USER Marcin FOR LOGIN Marcin
GO
CREATE CERTIFICATE certMarcina
AUTHORIZATION Marcin
WITH subject = 'Certyfikat Marcina'
CREATE CERTIFICATE certDanki
AUTHORIZATION Danka 
WITH subject = 'Certyfikat Danki'
CREATE SYMMETRIC KEY SkeyMarcina 
AUTHORIZATION Marcin
WITH ALGORITHM = TRIPLE_DES
ENCRYPTION BY CERTIFICATE certMarcina
CREATE SYMMETRIC KEY SkeyDanki
AUTHORIZATION Danka
WITH ALGORITHM = TRIPLE_DES
ENCRYPTION BY CERTIFICATE certDanki
GO
CREATE TABLE Klienci 
(Id INT IDENTITY, 
nazwisko NVARCHAR(30),  
numerKartyKredytowej VARBINARY(300))
GRANT CONTROL ON Klienci TO Danka, Marcin
GO
EXECUTE AS LOGIN ='Marcin'
OPEN SYMMETRIC KEY SkeyMarcina  
DECRYPTION BY CERTIFICATE certMarcina 
INSERT INTO dbo.Klienci (nazwisko,numerKartyKredytowej)
VALUES ('Szeliga', EncryptByKey(Key_GUID('SkeyMarcina'),'123-456-78-90'))
CLOSE ALL SYMMETRIC KEYS 
REVERT
EXECUTE AS LOGIN ='Danka'
OPEN SYMMETRIC KEY SkeyDanki 
DECRYPTION BY CERTIFICATE certDanki
INSERT INTO dbo.Klienci (nazwisko,numerKartyKredytowej)
VALUES ('Mendrala', EncryptByKey(Key_GUID('SkeyDanki'),'123-456-78-90'))
CLOSE ALL SYMMETRIC KEYS
REVERT
GO
OPEN SYMMETRIC KEY SkeyDanki 
DECRYPTION BY CERTIFICATE certDanki
SELECT nazwisko, CAST(DecryptByKey(numerKartyKredytowej) AS VARCHAR(100))
FROM dbo.Klienci 
CLOSE ALL SYMMETRIC KEYS 
GO

CREATE PROCEDURE Szyfruj @Dane VARCHAR(8000), @szyfr VARBINARY(8000) OUTPUT 
AS
BEGIN
OPEN SYMMETRIC KEY SKey1 DECRYPTION BY CERTIFICATE CertS1
SET @szyfr = EncryptByKey(KEY_GUID('SKey1'), @Dane)
CLOSE SYMMETRIC KEY SKey1
END
GO
GRANT EXECUTE ON Szyfruj TO Marcin
GO
EXECUTE AS LOGIN = 'Marcin'
DECLARE @T1 varbinary(8000)
EXEC Szyfruj 'Numer mojej karty: 123-124-345-124', @T1 OUTPUT
GO
REVERT
CREATE CERTIFICATE CertSignSzyfruj
WITH SUBJECT = 'Podpisuje proc Szyfruj'
CREATE USER uCertSignSzyfruj 
FROM CERTIFICATE CertSignSzyfruj
GRANT VIEW DEFINITION ON SYMMETRIC KEY::SKey1 TO uCertSignSzyfruj
GRANT CONTROL ON CERTIFICATE::CertS1 TO uCertSignSzyfruj
ADD SIGNATURE TO Szyfruj BY CERTIFICATE CertSignSzyfruj
GO
EXECUTE AS LOGIN = 'Marcin'
OPEN SYMMETRIC KEY SKey1 DECRYPTION BY CERTIFICATE CertS1
GO
DECLARE @szyfr VARBINARY(8000)
EXEC Szyfruj 'Numer mojej karty: 123-124-345-124', @szyfr OUTPUT
SELECT @szyfr
REVERT
GO

ALTER TABLE dbo.Emp
ADD Crypto varbinary(250)
GO
OPEN SYMMETRIC KEY SKey1 DECRYPTION BY CERTIFICATE CertS1
UPDATE Emp
SET Crypto = EncryptByKey(Key_GUID('SKey1'),Title)
CLOSE ALL SYMMETRIC KEYS
GO
CREATE UNIQUE INDEX iCrypto
ON Emp(Crypto)
GO
SET STATISTICS IO ON
SELECT Crypto
FROM dbo.Emp
GO
OPEN SYMMETRIC KEY SKey1 DECRYPTION BY CERTIFICATE CertS1              
SELECT EmployeeID, CAST(DecryptByKey(Crypto) AS nvarchar(50))AS Szyfrogram,Crypto 
FROM Emp
WHERE Crypto = EncryptByKey(Key_GUID('SKey1'),'Tool Designer')
CLOSE ALL SYMMETRIC KEYS
GO
OPEN SYMMETRIC KEY SKey1 DECRYPTION BY CERTIFICATE CertS1              
SELECT EmployeeID, CAST(DecryptByKey(Crypto) AS nvarchar(50))AS Szyfrogram,Crypto 
FROM Emp
WHERE CAST(DecryptByKey(Crypto) AS nvarchar(15)) = 'Tool Designer'
CLOSE ALL SYMMETRIC KEYS
GO
CREATE INDEX iMac
ON dbo.Emp(Mac)
GO
SELECT Title, Mac FROM Emp
WHERE Mac = dbo.fMac('Production Control Manager',1)
GO
SELECT Title, Mac FROM Emp
WHERE Mac = 
GO
