USE AdventureWorks
SELECT severity, message_id, text, is_event_logged
FROM sys.messages
WHERE language_id = 1033
ORDER BY severity
GO

SSELECT SalesPersonID
FROM Sales.vSalesPerson
PRINT @@ERROR
GO
SELECT SalesPersonID
FROM SSales.vSalesPerson
PRINT @@ERROR
GO
CREATE PROC uspBlad1
AS
SELECT SalesPersonID
FROM SSales.vSalesPerson
GO
EXEC uspBlad1
PRINT @@ERROR
GO
DELETE Production.ProductCategory
WHERE ProductCategoryID=1
PRINT @@ERROR
GO

EXEC uspBlad1 1
PRINT @@ERROR 
GO
EXEC uspGetManagerEmployees
PRINT @@ERROR
GO
EXEC sp_addmessage @msgnum = 55000, 
@severity = 16, 
@msgtext = N'Item(s) %s cannot be deleted.', 
@lang = 'us_english', @with_log = TRUE
GO
EXEC sp_addmessage @msgnum = 55000, @severity = 16, 
@msgtext = N'Pozycja(e) %1!  nie mog zosta skasowane.', 
@lang = 'Polish'
GO
ALTER LOGIN Danka 
WITH DEFAULT_LANGUAGE = Polish
GO

BEGIN TRY
DELETE Production.ProductCategory
WHERE ProductCategoryID=1
END TRY
BEGIN CATCH
PRINT 'Bd'
END CATCH
PRINT 'Kontynuujemy wykonanie wsadu ...'
GO
BEGIN TRY
    EXEC uspBlad1
END TRY
BEGIN CATCH
  SELECT ERROR_NUMBER() as ErrorNumber, ERROR_STATE() as ErrorState,
  ERROR_SEVERITY() as ErrorSeverity, ERROR_LINE() as ErrorLine,
  ISNULL(ERROR_PROCEDURE(), 'Adhoc') as ErrorProcedure, ERROR_MESSAGE() as ErrorMessage
END CATCH
GO

BEGIN TRANSACTION
BEGIN TRY
  PRINT @@TRANCOUNT 
DELETE FROM Production.ProductCategory
WHERE ProductCategoryID = 1
END TRY
BEGIN CATCH
  PRINT 'Bd'
  PRINT @@TRANCOUNT
 IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION
END CATCH
PRINT @@TRANCOUNT
IF @@TRANCOUNT > 0 COMMIT TRANSACTION
GO

DECLARE @proba INT
SET @proba=5
WHILE (@proba > 0) 
BEGIN
BEGIN TRY
BEGIN TRANSACTION
EXEC proceduraAktualizujacaJakiesDane
SET @proba = 0
COMMIT TRANSACTION
  END TRY
  BEGIN CATCH 
IF ERROR_NUMBER() = 1205 SET @proba = @proba - 1 
ELSE SET @proba = -1
IF XACT_STATE() <> 0 ROLLBACK TRANSACTION
  END CATCH
END
GO

BEGIN TRY
BEGIN TRAN
DELETE FROM Production.ProductCategory
WHERE ProductCategoryID = 1
  COMMIT TRAN
  PRINT 'Transakcja zatwierdzona'
END TRY
BEGIN CATCH
  IF XACT_STATE() = -1
  BEGIN
PRINT 'Transakcja zostaa zawieszona'
ROLLBACK TRANSACTION 
  END
  ELSE IF XACT_STATE() = 1
  BEGIN
PRINT 'Transakcja otwarta'
COMMIT TRANSACTION 
  END
ELSE
PRINT 'Brak rozpocztej transakcji'
END CATCH 
GO
SET XACT_ABORT ON
GO
BEGIN TRY
BEGIN TRAN
DELETE FROM Production.ProductCategory
WHERE ProductCategoryID = 1
  COMMIT TRAN
  PRINT 'Transakcja zatwierdzona'
END TRY
BEGIN CATCH
  IF XACT_STATE() = -1
  BEGIN
PRINT 'Transakcja zostaa zawieszona'
ROLLBACK TRANSACTION 
  END
  ELSE IF XACT_STATE() = 1
  BEGIN
PRINT 'Transakcja otwarta'
COMMIT TRANSACTION 
  END
ELSE
PRINT 'Brak rozpocztej transakcji'
END CATCH
GO
BEGIN TRAN
BEGIN TRY
DELETE FROM Production.ProductCategory
WHERE ProductCategoryID = 1
END TRY
BEGIN CATCH
SELECT @@TRANCOUNT, XACT_STATE()
END CATCH
GO
SET XACT_ABORT OFF
GO

CREATE PROCEDURE uspBlad2
AS
PRINT @@TRANCOUNT
ROLLBACK TRANSACTION
GO
BEGIN TRANSACTION
PRINT @@TRANCOUNT
EXEC uspBlad2
PRINT @@TRANCOUNT
GO
RAISERROR (55000,16,1,'B12')WITH_LOG
GO

CREATE TRIGGER trLimitUsuwanychWierszy
ON dbo.tab4
FOR DELETE
AS
IF (SELECT COUNT (*) FROM DELETED) > 1
RAISERROR('Nie mona jednoczenie usun wielu wierszy', 16, 1)
GO
BEGIN TRAN
BEGIN TRY
  DELETE dbo.tab4
END TRY
BEGIN CATCH
  IF ERROR_NUMBER()=50000 
  BEGIN
      PRINT 'Bd uytkownika'
      PRINT @@TRANCOUNT
 ROLLBACK
END
END CATCH
GO

BEGIN TRY
    SELECT 1/0
END TRY
BEGIN CATCH
DECLARE @komunikat NVARCHAR(4000), @numer INT, @kategoria INT, @stan INT, @wiersz INT, @procedura NVARCHAR(256)
SELECT @numer = ERROR_NUMBER(), @kategoria = ERROR_SEVERITY(), @stan = ERROR_STATE(), @wiersz = ERROR_LINE(), @procedura = ISNULL(ERROR_PROCEDURE(), 'AdHoc')
SELECT @komunikat = 'Bd %d, Kategoria %d, Stan %d, Procedura %s, Wiersz %d, ' + 'Komunikat: ' + ERROR_MESSAGE()
RAISERROR (@komunikat,@kategoria,1,@numer,@kategoria,@stan,@procedura,@wiersz)
END CATCH
GO