USE AdventureWorks
GO
CREATE PROC uspTest 
AS 
SELECT kol1 
FROM nieMaTakiejTabeli
GO
EXEC uspTest
GO
ALTER PROC uspTest 
AS 
SELECT kol7 
FROM tab1
GO

CREATE Procedure uspDaneProduktu (@Categoryname varchar(50) = '%')
AS
IF dbo.ufnLikeRegEx (@Categoryname,'^[a-zA-Z%\s\]*$') = 0
RETURN -1                                     -- nazwa nie skada si z samych liter i symbolu %
IF dbo.ufnLikeRegEx (@Categoryname,'/(\%27)|(\-\-)|(\%23)|(#)/ix') = 1 
RETURN -1                                     -- nazwa zawiera zabronione znaki
SELECT c.Name AS Kategoria, sc.Name AS Podkategoria, p.Name Produkt, p.ListPrice,
DENSE_RANK() OVER                     -- funkcja DENSE_RANK() ponumeruje wiersze
(PARTITION BY sc.Name                 -- w ramach poszczeglnych podkategorii 
ORDER BY p.ListPrice DESC) as Pozycja -- numerowane wiersze musz by posortowane
FROM  Production.Product p
JOIN Production.ProductSubcategory sc ON p.ProductSubcategoryID = sc.ProductSubcategoryID 
JOIN Production.ProductCategory c ON sc.ProductCategoryID = c.ProductCategoryID
WHERE  c.Name LIKE @CategoryName
ORDER BY c.Name  
RETURN @@ROWCOUNT -- zastpujemy systemowy status wykonania liczb zwrconych wierszy
GO
EXEC uspDaneProduktu
GO
EXEC uspDaneProduktu 'a''OR 1=1--'
GO
DECLARE @l INT
EXEC @l = uspDaneProduktu 'Accessories'
PRINT @l
GO

CREATE PROCEDURE uspGrantExec @user SYSNAME
AS
DECLARE @cSQL varchar(8000)
DECLARE @Obj varchar(8000)
DECLARE @Cur  CURSOR  
BEGIN TRY                      -- blok TRY  CATCH opisalimy w rozdziale 11.
SET @Cur = CURSOR FOR SELECT QUOTENAME(routine_schema) + '.' + QUOTENAME(routine_name)
FROM information_schema.routines 
WHERE routine_name NOT LIKE 'dt_%' AND routine_type = 'PROCEDURE'
OPEN @Cur
FETCH NEXT FROM @Cur INTO @Obj
WHILE @@FETCH_STATUS = 0
BEGIN
  SET @cSQL = 'GRANT EXEC ON ' + @Obj + ' TO ' + @user
  EXEC (@cSQL)
  FETCH NEXT FROM @Cur INTO @Obj
END
DEALLOCATE @Cur
END TRY
BEGIN CATCH
RETURN -1                      -- w rozdziale 11. wyjanilimy te problemy zwizane z tak obsug wyjtkw
END CATCH
GO
DECLARE @w INT
EXEC @w = uspGrantExec 'blabla'
IF @w <0  PRINT 'Bd'
GO
DECLARE @w INT
EXEC @w = uspGrantExec 'Danka'
IF @w <0  PRINT 'Bd'
GO

CREATE PROCEDURE uspPrac @Nazwisko nvarchar(50) = '%', @Imie nvarchar(50) = '%'
AS 
SELECT FirstName, LastName, JobTitle
FROM HumanResources.vEmployeeDepartment
WHERE FirstName LIKE @Imie AND LastName LIKE @Nazwisko
GO
CREATE TABLE #Pracownicy 
(Imie nvarchar(50),
Nazwisko nvarchar(50),
Stanowisko nvarchar(50))
GO
INSERT INTO #Pracownicy
EXEC uspPrac 'H%', 'D%'
GO
SELECT * 
FROM #Pracownicy
GO
ALTER PROCEDURE uspPrac @Nazwisko nvarchar(50) = '%', @Imie nvarchar(50) = '%'
AS 
CREATE TABLE #tmpPracownicy 
(Imie nvarchar(50),
Nazwisko nvarchar(50),
Stanowisko nvarchar(50))

INSERT INTO #tmpPracownicy
SELECT FirstName, LastName, JobTitle
FROM HumanResources.vEmployeeDepartment
WHERE FirstName LIKE @Imie AND LastName LIKE @Nazwisko
GO
EXEC uspPrac 'H%', 'D%'
SELECT * 
FROM #tmpPracownicy 
GO

CREATE PROCEDURE uspParamOut @l1 INT, @l2 INT OUTPUT
AS
SET @l2= @l1*@l2
GO
DECLARE @w INT
SET @w=10
EXEC uspParamOut 5,@w OUTPUT
SELECT @w
GO

CREATE PROCEDURE uspParamTab @doc XML
AS
--moemy skorzysta z funkcji OPENXML
DECLARE @h INT
EXEC sp_xml_preparedocument @h OUTPUT, @doc
SELECT *
FROM OPENXML(@h, 'Towary/Towar')
WITH (id INT '@id',        -- klauzula WITH pozwala sformatowa wynik
  nazwa VARCHAR(30) '@nazwa',
  cena DECIMAL '@cena')
EXEC sp_xml_removedocument @h
--albo z metod typu XML
SELECT @doc.value ('(Towary/Towar/@nazwa)[1]','VARCHAR(30)')
GO
DECLARE @Towary XML
SET @Towary =' <Towary>
 <Towar id="1" nazwa="Syrop" cena="1000" />
 <Towar id="4" nazwa="Zioa" cena="200" />
 </Towary>'

EXEC uspParamTab @Towary
GO

sp_who
sp_who2
GO

CREATE PROC uspZamowienia @dataOd DATETIME = '20010101', @dataDo DATETIME = '20020101'
AS
SELECT SalesOrderID, OrderDate, Status
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN @dataOd AND @dataDo
GO
DECLARE @dbid SMALLINT
SELECT @dbid = DB_ID('AdventureWorks')
DBCC FLUSHPROCINDB(@dbid)
GO
EXEC uspZamowienia '20010702','20010702'
GO
SELECT st.text, qs.execution_count, p.query_plan 
FROM sys.dm_exec_query_stats AS qs 
CROSS APPLY sys.dm_exec_sql_text(sql_handle) st
CROSS APPLY sys.dm_exec_query_plan(plan_handle) p
WHERE st.text like '%uspZamowienia%' AND st.text NOT LIKE '%cache%'
GO
EXEC uspZamowienia 
GO
EXEC uspZamowienia '20010701','20010703'
GO
CREATE INDEX IX_SalesOrderHeader_OrderDate
ON Sales.SalesOrderHeader(OrderDate) 
GO
DECLARE @dbid SMALLINT
SELECT @dbid = DB_ID('AdventureWorks')
DBCC FLUSHPROCINDB(@dbid)
GO
SET STATISTICS IO ON
GO
EXEC uspZamowienia '20010702','20010702'
GO
EXEC uspZamowienia '20010701','20050702'
GO
SET STATISTICS IO OFF
GO
ALTER PROC uspZamowienia @dataOd DATETIME = '20010101', @dataDo DATETIME = '20020101'
AS
SELECT SalesOrderID,OrderDate,Status
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN @dataOd AND @dataDo
OPTION (OPTIMIZE FOR (@dataOd='20010701', @dataDo='20010902'))
GO
EXEC uspZamowienia 
GO
SELECT p.query_plan.query 
('declare default element namespace "http://schemas.microsoft.com/sqlserver/2004/07/showplan";
/ShowPlanXML/BatchSequence/Batch/Statements/StmtSimple/QueryPlan/ParameterList')
FROM sys.dm_exec_query_stats AS qs 
CROSS APPLY sys.dm_exec_sql_text(sql_handle) st
CROSS APPLY sys.dm_exec_query_plan(plan_handle) p
WHERE st.text like '%uspZamowienia%' AND st.text NOT LIKE '%cache%'
AND st.text NOT LIKE 'SELECT%'
GO
ALTER PROC uspZamowienia @dataOd DATETIME = '20010101', @dataDo DATETIME = '20020101'
AS
DECLARE @doD DATETIME, @dDo DATETIME
SET @doD=@dataOd
SET @dDo=@dataDo
SELECT SalesOrderID,OrderDate,Status
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN @dOD AND @dDo
GO
SET STATISTICS IO ON
GO
EXEC uspZamowienia '20010702','20010702'
GO
SET STATISTICS IO OFF
GO
ALTER PROC uspZamowienia @dataOd DATETIME = '20010101', @dataDo DATETIME = '20020101'
AS
SELECT SalesOrderID,OrderDate,Status
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN @dataOd AND @dataDo
GO
SET STATISTICS IO ON
GO
EXEC uspZamowienia '20010702','20010702'
GO
EXEC uspZamowienia 
WITH RECOMPILE
GO
SET STATISTICS IO OFF
GO
ALTER PROC uspZamowienia @dataOd DATETIME = '20010101', @dataDo DATETIME = '20020101'
AS
SELECT SalesOrderID,OrderDate,Status
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN @dataOd AND @dataDo
OPTION (RECOMPILE)
GO
EXEC sp_recompile 'Sales.SalesOrderHeader'
GO

CREATE PROC uspExecAs 
WITH EXECUTE AS OWNER
AS
SELECT principal_id, name, type 
FROM sys.user_token 
TRUNCATE TABLE dbo.tab2
GO
GRANT EXEC ON uspExecAs TO Danka
GO
EXECUTE AS LOGIN = 'Danka'
TRUNCATE TABLE dbo.tab2
GO
EXEC uspExecAs
GO
REVERT
GO

CREATE TRIGGER trWirtualneTabele
ON HumanResources.Department
AFTER UPDATE
AS
SELECT @@ROWCOUNT
SELECT *
FROM DELETED
SELECT * 
FROM INSERTED
GO
UPDATE HumanResources.Department
SET Name=UPPER(Name)
WHERE DepartmentID<3
GO
EXEC sp_configure 'disallow results from triggers',1
RECONFIGURE
GO

ALTER TRIGGER HumanResources.trWirtualneTabele
ON HumanResources.Department
AFTER UPDATE
AS
SELECT * 
INTO #tblINSERTED
FROM INSERTED
CREATE UNIQUE CLUSTERED INDEX IDX_tblI
ON #tblINSERTED(DepartmentID)
--Dalsze operacje wykonywane na tabeli tblINSERTED
GO

CREATE TRIGGER trOpisyProd ON Production.ProductReview
AFTER UPDATE 
AS
UPDATE Production.ProductReview
SET Production.ProductReview.ModifiedDate = GETDATE()
FROM INSERTED I --zczenie naturalne z tabel INSERTED wyeliminuje te wiersze, ktre nie byy zmieniane 
JOIN Production.ProductReview p ON I.ProductReviewID = p.ProductReviewID
GO

CREATE TRIGGER trNazwaDoc
ON Production.Document
AFTER UPDATE 
AS 
IF UPDATE (Title) 
BEGIN
RAISERROR ('Nie mona zmieni nazwy dokumentu', 16, 10)
ROLLBACK
END
GO
UPDATE Production.Document
SET Title = 'X'
GO

EXEC sp_configure 'nested triggers'
GO
ALTER DATABASE AdventureWorks 
SET RECURSIVE_TRIGGERS ON
GO
UPDATE Production.ProductReview
SET ReviewerName=ReviewerName
WHERE ProductReviewID=1
GO
ALTER TRIGGER Production.trOpisyProd 
ON Production.ProductReview
INSTEAD OF UPDATE 
AS
UPDATE Production.ProductReview
SET Production.ProductReview.ModifiedDate = GETDATE(),
Production.ProductReview.ProductID = I.ProductID,
Production.ProductReview.ReviewerName = I.ReviewerName,
Production.ProductReview.ReviewDate = I.ReviewDate,
Production.ProductReview.EmailAddress = I.EmailAddress,
Production.ProductReview.Rating = I.Rating,
Production.ProductReview.Comments = I.Comments
FROM INSERTED I --tu znajdziemy nowe wartoci
JOIN Production.ProductReview p ON I.ProductReviewID = p.ProductReviewID
GO

CREATE TABLE master.dbo.logDDL
(id INT IDENTITY PRIMARY KEY,
uzytkownik SYSNAME,
czas DATETIME,
instrukcja SYSNAME,
obiekt SYSNAME,
opis XML)
GO
CREATE TRIGGER trLogDDL
ON ALL SERVER
FOR CREATE_DATABASE,ALTER_DATABASE, DROP_DATABASE,DDL_LOGIN_EVENTS
AS
DECLARE @doc AS XML
SET @doc = EVENTDATA()
INSERT INTO master.dbo.logDDL (uzytkownik, czas,instrukcja, obiekt, opis)
VALUES (
CAST(@doc.query ('data(//LoginName)') AS SYSNAME),
CAST(@doc.query ('data(//PostTime)') AS VARCHAR(23)),
CAST(@doc.query ('data(//EventType)') AS SYSNAME),
CAST(@doc.query ('data(//ObjectName)') AS SYSNAME),
@doc )
GO
CREATE DATABASE test
DROP DATABASE test
ALTER LOGIN danka 
WITH DEFAULT_DATABASE=AdventureWorks, CHECK_EXPIRATION=OFF, CHECK_POLICY=OFF
GO
SELECT uzytkownik, czas, instrukcja, obiekt
FROM master.dbo.logDDL
GO

CREATE TRIGGER trgTblPK 
ON DATABASE 
FOR CREATE_TABLE
AS
DECLARE @eventdata AS XML, @objectname AS NVARCHAR(257), @msg AS NVARCHAR(500)
SET @eventdata = EVENTDATA()
SET @objectname = QUOTENAME(@eventdata.value('(/EVENT_INSTANCE/SchemaName)[1]', 'sysname')) + N'.' + QUOTENAME(@eventdata.value('(/EVENT_INSTANCE/ObjectName)[1]', 'sysname'))
IF COALESCE( OBJECTPROPERTY(OBJECT_ID(@objectname), 'TableHasPrimaryKey'), 0) = 0
BEGIN
  SET @msg = N'Tabela ' + @objectname + ' nie ma klucza podstawowego.'
  RAISERROR(@msg, 16, 1)
  ROLLBACK
  RETURN
END
GO
CREATE TABLE tab6(col1 INT NOT NULL)
GO
CREATE TABLE tab6(col1 INT NOT NULL PRIMARY KEY)
GO

CREATE TRIGGER trLimitSesji
ON ALL SERVER 
WITH EXECUTE AS 'sa'
FOR LOGON
AS
IF ORIGINAL_LOGIN()= 'SQLSRV\szelor' AND HOST_NAME() <> 'SQLSRV'
ROLLBACK
GO