USE AdventureWorks
SELECT RAND(),NEWID()
FROM HumanResources.Shift
GO

CREATE FUNCTION ufnSilniaTSQL (@n INT)
RETURNS FLOAT AS
BEGIN
DECLARE @s FLOAT
DECLARE @l INT
SET @s=1
SET @l=2
WHILE @l<=@n
BEGIN
SET @s=@s*@l
SET @l=@l+1
END
RETURN @s
END
GO
CREATE FUNCTION ufnMinBrak() 
RETURNS INT AS
BEGIN
RETURN (SELECT MIN(IDENTITYCOL + 1) FROM dbo.tab1 a 
WHERE NOT EXISTS (SELECT * FROM dbo.tab1 b WHERE b.IDENTITYCOL = a.IDENTITYCOL+1))
END
GO
CREATE FUNCTION ufnSumaSprzed(@ProductID INT = NULL) 
RETURNS INT
WITH RETURNS NULL ON NULL INPUT AS
BEGIN
DECLARE @sp int
SELECT @sp = SUM(OrderQty)
FROM Sales.SalesOrderDetail WHERE ProductID = @ProductID
IF (@sp IS NULL)SET @sp = 0
RETURN @sp
END

SET IDENTITY_INSERT tab1 ON
INSERT INTO tab1 (kol1, kol2) 
VALUES (5,'BBB')
GO
SELECT DBO.ufnMinBrak()
GO
SELECT Name, dbo.ufnSumaSprzed(ProductID) AS Suma
FROM Production.Product
WHERE dbo.ufnSumaSprzed(ProductID)>5000
ORDER BY Suma DESC
GO

/*
Imports Microsoft.SqlServer.Server
Imports System.Data.SqlTypes

Public Class FunkcjeCLR
    <SqlFunction(isDeterministic:=True)> _
    Public Shared Function Silnia(ByVal n As SqlInt32) As SqlDouble
        Dim s As Double = 1
        Dim l As Integer
        For l = 2 To n
            s = s * l
        Next
        Return s
    End Function
End Class
*/

CREATE ASSEMBLY Funkcje
FROM 'C:\Szeryf\Visual Studio 2005\Projects\Funkcje\Funkcje\bin\Release\Funkcje.dll'
GO
CREATE FUNCTION ufnSilniaCLR (@n INT)
RETURNS FLOAT AS
EXTERNAL NAME Funkcje.[Funkcje.FunkcjeCLR].Silnia
GO
EXEC sp_configure 'clr enabled', 1
RECONFIGURE
GO
SELECT dbo.ufnSilniaCLR(3)
GO

CREATE TABLE tab5
(Licznik INT IDENTITY,
Silnia FLOAT,
Email varchar(50))
GO
DECLARE @l INT
SET @l=1
WHILE @l<171
BEGIN
INSERT INTO tab5(Silnia) VALUES (dbo.ufnSilniaTSQL(@l))
SET @l=@l+1
END
GO
TRUNCATE TABLE tab5
DBCC CHECKIDENT ('tab5',RESEED,1)
GO
DECLARE @l INT
SET @l=1
WHILE @l<171
BEGIN
INSERT INTO tab5(Silnia) VALUES (dbo.ufnSilniaCLR(@l))
SET @l=@l+1
END
GO

/*
<SqlFunction(isDeterministic:=True, dataAccess:=DataAccessKind.None)> _
    Public Shared Function RegExLike(ByVal tekst As SqlString, ByVal wzorzec As SqlString) As SqlBoolean
        Return (CType(System.Text.RegularExpressions.Regex.IsMatch(tekst.Value, wzorzec.Value, Text.RegularExpressions.RegexOptions.CultureInvariant), SqlBoolean))
    End Function
*/
ALTER ASSEMBLY Funkcje
FROM 'C:\Szeryf\Visual Studio 2005\Projects\Funkcje\Funkcje\bin\Release\Funkcje.dll'
GO
CREATE FUNCTION ufnLikeRegEx (@tekst NVARCHAR(MAX), @wzorzec NVARCHAR(MAX))
RETURNS BIT 
WITH RETURNS NULL ON NULL INPUT AS 
EXTERNAL NAME Funkcje.[Funkcje.FunkcjeCLR].RegExLike
GO
SELECT dbo.ufnLikeRegEx('marcin@foo.pl','[a-zA-Z0-9_\-]+@([a-zA-Z0-9_\-]+\.)'),
dbo.ufnLikeRegEx('danka@@foo.pl','[a-zA-Z0-9_\-]+@([a-zA-Z0-9_\-]+\.)')
GO

/*
<SqlFunction(isDeterministic:=True, isprecise:=True, dataAccess:=DataAccessKind.None)> _
    Public Shared Function RegEx(ByVal tekst As SqlString, ByVal wzorzec As SqlString, ByVal zastepca As SqlString) As SqlString
        Return System.Text.RegularExpressions.Regex.Replace(tekst.Value, wzorzec.Value, zastepca.Value)
    End Function
*/
CREATE FUNCTION ufnRegEx (@tekst NVARCHAR(MAX), @wzorzec NVARCHAR(MAX), @zastepca NVARCHAR(MAX))
RETURNS NVARCHAR(MAX) 
WITH RETURNS NULL ON NULL INPUT AS
EXTERNAL NAME Funkcje.[Funkcje.FunkcjeCLR].RegEx
GO
SELECT dbo.ufnRegEx('kur','k','t'), 
dbo.ufnRegEx('Cena: 31.95','\d+\.\d{2}','$$$&'),
dbo.ufnRegEx('Co12Sie89457Stalo094z00)(*literami?','[a-zA-Z]','')
GO

ALTER TABLE dbo.tab5 
ADD CONSTRAINT
CK_tab5 CHECK (dbo.ufnLikeRegEx(Email,'[a-zA-Z0-9_\-]+@([a-zA-Z0-9_\-]+\.)')=1)
GO
ALTER TABLE dbo.tab5 
ADD FakeEmail  AS dbo.ufnRegEx(Email,'([a-z]*)@([a-z]*)-(.+)','$1__$2/!$3')
GO
INSERT INTO dbo.tab5(Email)
SELECT EmailAddress
FROM Person.Contact
GO
SELECT * FROM dbo.tab5
WHERE Licznik IN(171,12213)
GO

CREATE FUNCTION ufnPodwaldni(@ManagerId int)
RETURNS TABLE AS
RETURN (SELECT FirstName, LastName
FROM HumanResources.Employee Employee 
JOIN Person.Contact Contact ON Employee.ContactID = Contact.ContactID
WHERE ManagerID = @ManagerId )
GO
SELECT * 
FROM ufnPodwaldni (3)
GO
UPDATE ufnPodwaldni (16)
SET FirstName = UPPER(FirstName)
WHERE LastName = 'Gilbert'
GO
CREATE FUNCTION ufnListaIndeksow (@tab sysname) 
RETURNS TABLE AS
RETURN (SELECT name, type_desc,is_unique,is_disabled
FROM sys.indexes WHERE object_id = object_id(@tab))  
GO
CREATE FUNCTION ufnHierarchia (@ile INT) 
RETURNS TABLE AS
RETURN
(WITH podwladni(ManagerID, EmployeeID, Pozycja) AS   -- definiujemy CTE
(SELECT ManagerID, EmployeeID, 0 AS Pozycja
  FROM HumanResources.Employee
  WHERE ManagerID IS NULL --Warunek brzegowy rekurencji
UNION ALL
SELECT e.ManagerID, e.EmployeeID, Pozycja + 1      -- to zapytanie bdzie wykonywane 
FROM HumanResources.Employee e                     -- dopki bdzie zwraca wiersze
JOIN podwladni d ON e.ManagerID = d.EmployeeID)    -- a wic a odczytani zostan wszyscy podwadni
SELECT ManagerID, EmployeeID, Pozycja              -- zwracamy uytkownikowi wynik CTE
FROM podwladni 
WHERE Pozycja <= @ile)                             -- eliminujc osoby na niszych stanowiskach
GO

CREATE FUNCTION ufnDanePracownikow(@format char(1))
RETURNS @tab_Pracownicy TABLE (ID int PRIMARY KEY, Dane nvarchar(200)) AS
BEGIN
IF (@format = 'S')
INSERT @tab_Pracownicy
SELECT EmployeeID, LastName
FROM HumanResources.vEmployee
ELSE IF (@format = 'M')
INSERT @tab_Pracownicy
SELECT EmployeeID, FirstName + ' ' + LastName
FROM HumanResources.vEmployee
ELSE IF (@format = 'L')
INSERT @tab_Pracownicy
SELECT EmployeeID, FirstName + ' ' + LastName + ' ' + JobTitle + ' ' + EmailAddress
FROM HumanResources.vEmployee
RETURN
END
GO
SELECT * 
FROM ufnDanePracownikow('L')
GO
CREATE FUNCTION ufnStawki () 
RETURNS @tab_stawki TABLE(UnitedStates DECIMAL (5,2), Canada DECIMAL (5,2), France DECIMAL (5,2),Germany DECIMAL (5,2),None DECIMAL (5,2)) AS
BEGIN
INSERT INTO @tab_stawki
SELECT 5.0, 3.0, 2.5, 4.5, 2.2
RETURN
END
GO
SELECT s.SalesYTD, t.CountryRegionCode, Stawka = 
  CASE t.CountryRegionCode
  WHEN 'US' THEN c.UnitedStates
  WHEN 'CA' THEN c.Canada
  WHEN 'FR' THEN c.France
  WHEN 'DE' THEN c.Germany
  ELSE c.None
  END
FROM Sales.SalesPerson s
LEFT OUTER JOIN Sales.SalesTerritory t ON s.TerritoryID = t.TerritoryID
CROSS APPLY (SELECT * FROM ufnStawki ()) c
GO