USE AdventureWorks
GO
CREATE VIEW vPracownicySort AS 
SELECT TOP 100 PERCENT 
c.LastName, e.EmployeeID, c.Title, c.FirstName, c.MiddleName, e.Title AS Stanowisko, c.Phone, c.EmailAddress, COALESCE (a.AddressLine1,'') + COALESCE (a.AddressLine2,'') Adres, a.City, sp.Name Stan, a.PostalCode, cr.Name AS Region ,c.AdditionalContactInfo
FROM HumanResources.Employee e INNER JOIN Person.Contact c ON c.ContactID = e.ContactID
JOIN HumanResources.EmployeeAddress ea ON e.EmployeeID = ea.EmployeeID 
JOIN Person.Address a ON ea.AddressID = a.AddressID
JOIN Person.StateProvince sp ON sp.StateProvinceID = a.StateProvinceID
JOIN Person.CountryRegion cr ON cr.CountryRegionCode = sp.CountryRegionCode
ORDER BY c.LastName
GO
SELECT * FROM 
vPracownicySort
GO

CREATE VIEW vJednostkiAlokacji 
WITH ENCRYPTION AS
SELECT OBJECT_NAME(i.object_id) Tabela, i.name Indeks, i.type_desc Typ_indeksu, rows, a.allocation_unit_id, a.type_desc, total_pages
FROM sys.indexes i 
JOIN sys.partitions p ON i.object_id=p.object_id AND i.index_id = p.index_id
JOIN sys.allocation_units a ON p.partition_id = a.container_id
GO
SELECT definition 
FROM sys.sql_modules
WHERE object_id=OBJECT_ID('vJednostkiAlokacji')
GO
EXEC sp_helptext 'vJednostkiAlokacji'
GO
SELECT * FROM vJednostkiAlokacji
WHERE tabela = 'Illustration'
GO
CREATE VIEW v2 
WITH SCHEMABINDING AS
SELECT Name, ListPrice
FROM Production.Product
WHERE ListPrice >500
GO
UPDATE v2
SET ListPrice=ListPrice/5
WHERE Name='Road-250 Red, 52'
GO
ALTER VIEW v2 
WITH SCHEMABINDING AS
SELECT Name, ListPrice
FROM Production.Product
WHERE ListPrice >500
WITH CHECK OPTION
GO
UPDATE v2
SET ListPrice=ListPrice/5
WHERE Name='ML Road Frame - Red, 52'
GO
ALTER VIEW v2 
WITH SCHEMABINDING, VIEW_METADATA AS
SELECT Name, ListPrice
FROM Production.Product
WHERE ListPrice >500
WITH CHECK OPTION
GO

CREATE VIEW vSprzedawcy 
WITH SCHEMABINDING AS
SELECT e.EmployeeID, c.Title, c.FirstName, c.MiddleName, c.LastName, c.Suffix, e.Title AS JobTitle, c.Phone, c.EmailAddress, c.EmailPromotion, a.AddressLine1, 
a.AddressLine2, a.City, sp.Name AS StateProvinceName, a.PostalCode
FROM HumanResources.Employee AS e 
JOIN Person.Contact AS c ON c.ContactID = e.ContactID 
JOIN HumanResources.EmployeeAddress AS ea ON e.EmployeeID = ea.EmployeeID 
JOIN Person.Address AS a ON ea.AddressID = a.AddressID 
JOIN Person.StateProvince AS sp ON sp.StateProvinceID = a.StateProvinceID
GO
CREATE UNIQUE CLUSTERED INDEX IX_vSprzedawcy 
ON vSprzedawcy(EmployeeID)
GO
CREATE VIEW vSumaSprzed 
WITH SCHEMABINDING AS
SELECT oh.SalesOrderID, SUM(od.UnitPrice) AS Suma, COUNT_BIG(*) as licznik
FROM Sales.SalesOrderDetail od 
JOIN Sales.SalesOrderHeader oh ON od.SalesOrderID = oh.SalesOrderID
GROUP BY oh.SalesOrderID
GO
CREATE UNIQUE CLUSTERED INDEX IX_vSumaSprzed 
ON vSumaSprzed(SalesOrderID)
GO

SET STATISTICS IO ON
GO
SELECT * FROM dbo.vSprzedawcy
GO
SELECT * FROM dbo.vSprzedawcy
WITH (NOEXPAND)
GO
CREATE VIEW vCity 
WITH SCHEMABINDING AS
SELECT AddressID, City
FROM Person.Address
WHERE City NOT IN('Paris', 'London')
GO
CREATE UNIQUE CLUSTERED INDEX IX_vCity 
ON vCity(AddressID)
CREATE INDEX IX_vCityNCL 
ON vCity(City)
GO
SELECT EmployeeID, City
FROM vCity 
JOIN HumanResources.EmployeeAddress e ON vCity.AddressID = vCity.AddressID
WHERE City IN ('Baltimore','Sandy','Peoria')

SELECT EmployeeID, City
FROM vCity WITH (NOEXPAND) 
JOIN HumanResources.EmployeeAddress e ON vCity.AddressID = vCity.AddressID
WHERE City IN ('Baltimore','Sandy','Peoria')
GO
SET STATISTICS IO OFF
GO

CREATE TABLE tab4
(kol1 int PRIMARY KEY, 
kol2 char(30))
GO
CREATE VIEW dbo.vTab4 
WITH SCHEMABINDING AS
SELECT kol2
FROM dbo.tab4
WHERE kol2 IS NOT NULL
GO
CREATE UNIQUE CLUSTERED INDEX IX_vTab4
ON vTab4(kol2)
GO
INSERT INTO tab4 VALUES(1,'a')
INSERT INTO tab4 VALUES(2,NULL)
INSERT INTO tab4 VALUES(3,NULL)
INSERT INTO tab4 VALUES(4,'a')
GO

SELECT * 
INTO ProdSub1
FROM Production.Product
WHERE ProductSubcategoryID <10
GO
SELECT * 
INTO ProdSub2
FROM Production.Product
WHERE ProductSubcategoryID >=10
GO
CREATE VIEW dbo.Produkt AS 
SELECT * FROM ProdSub1
UNION ALL 
SELECT * FROM ProdSub2
GO

EXEC sp_depends 'dbo.vCity'
GO
SELECT DISTINCT OBJECT_NAME(object_id) AS Nazwa
FROM sys.sql_dependencies
WHERE referenced_major_id = OBJECT_ID(N'AdventureWorks.HumanResources.Employee')
GO
CREATE VIEW v1
AS SELECT * FROM dbo.tab3
GO
SELECT * FROM v1
GO
ALTER TABLE tab3
ADD kol4 INT
SELECT * FROM v1
GO
ALTER TABLE tab3
DROP COLUMN kol2
SELECT * FROM v1
GO
DECLARE @Widok VARCHAR(8000)
DECLARE @Cur  CURSOR  
DECLARE @cSQL VARCHAR(8000)
SET @Cur = CURSOR FOR SELECT QUOTENAME(table_schema)+'.'+QUOTENAME(table_name) 
FROM INFORMATION_SCHEMA.VIEWS 
WHERE OBJECTPROPERTY(OBJECT_ID(QUOTENAME(table_schema)+'.'+QUOTENAME(table_name)),'IsSchemaBound')=0
OPEN @Cur
FETCH NEXT FROM @Cur INTO @Widok
WHILE @@FETCH_STATUS = 0
BEGIN
SET @cSQL = 'EXEC sp_refreshview ''' + @Widok +''''
EXEC (@cSQL)
FETCH NEXT FROM @Cur INTO @Widok    
END
DEALLOCATE @Cur
GO

CREATE VIEW Test.vTab3 AS
SELECT * 
FROM test.T3
GO
GRANT SELECT 
ON Test.vTab3 
TO Danka
GO
EXECUTE AS LOGIN = 'Danka'
SELECT * 
FROM test.T3
GO
SELECT * 
FROM test.vTab3
GO
REVERT
ALTER AUTHORIZATION 
ON test.vTab3 
TO Danka
GO
EXECUTE AS LOGIN = 'Danka'
SELECT * 
FROM test.vTab3
GO
REVERT
