USE AdventureWorks
GO
EXEC dbo.sp_changedbowner 'sa'
GO

/*
BACKUP DATABASE $(db) 
TO $(urz)

sqlcmd -i c:\skrypt.sql -v db=AdventureWorks -v urz=BacDevAdvWorks

sqlcmd  -Q "SELECT * FROM AdventureWorks.Production.Product" -o "c:\produkty.txt"

bcp AdventureWorks.Production.Product out "Produkty.txt" -T -S ex -c
BULK INSERT AdventureWorks.Produkty
FROM 'C:\Documents and Settings\szelor\Produkty.txt'
*/

SELECT *
FROM sys.dm_exec_sessions
WHERE session_id=@@SPID
GO
SELECT --Wywoujemy trzy podzapytania 
(SELECT COUNT(ProductID) 
FROM Production.Product 
WHERE Class = 'L') AS klasaL,
(SELECT COUNT(ProductID) FROM 
Production.Product 
WHERE Class <> 'L') as pozostae, 
(SELECT COUNT(ProductID)    
FROM Production.Product) as wszystkie
GO
SELECT NULL/0, 'ala' + NULL, 5 + NULL, 10 * NULL, NULL + NULL 
GO
SELECT ProductID, COALESCE(Class,'Nieznana')
FROM Production.Product
GO

SELECT SalesOrderID 
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '20010701' AND '20010702'
GO
SELECT DATEDIFF(YEAR,'20071231','20080101')
GO
SELECT DATEADD(DAY,DATEDIFF(DAY,0,GETDATE()),0)
GO
SELECT DATEPART(WEEKDAY,GETDATE()) , DATENAME(WEEKDAY,GETDATE()), DATEDIFF(DAY,'19000101',GETDATE()) %7
SET DATEFIRST 4
SELECT DATEPART(WEEKDAY,GETDATE()), DATENAME(WEEKDAY,GETDATE()), DATEDIFF(DAY,'19000101',GETDATE()) %7
GO

DECLARE @ascii AS CHAR(8000)
DECLARE @unicode AS NCHAR(8000)
GO
DECLARE @max AS VARCHAR(MAX)
SET @max = 'a po suszy szosa scha'
PRINT LEN(@max)
SET @max.WRITE ('sucha',17,5)
PRINT UPPER(@max)
GO

SELECT * 
FROM OPENROWSET(BULK 'C:\WINDOWS\kawa.bmp', SINGLE_BLOB) AS rysunek
GO

SELECT ProductID AS "@ProductID", Name AS "*", Size AS "Description/@Size" 
FROM Production.Product 
FOR XML PATH
GO

DECLARE @xml XML
SELECT @xml = BulkColumn 
FROM OPENROWSET(BULK 'c:\doc.xml', SINGLE_BLOB) as x
SELECT @xml

DECLARE @docHandle int 
EXEC sp_xml_preparedocument @docHandle OUTPUT, @xml 
SELECT * 
FROM OPENXML(@docHandle, '/Orders/Sales.SalesOrderHeader', 2) 
WITH (SalesOrderID int, CustomerID int, TotalDue smallmoney) 
EXEC sp_xml_removedocument @docHandle
GO

DECLARE @licznik int
SET @licznik = @licznik+1
PRINT @licznik
GO
SELECT '1'+1+'1', '1'+'1'+1
GO
SELECT 10/-1*5, (10/-1)*5
GO

DECLARE @tab AS TABLE 
(kol1 INT PRIMARY KEY, 
kol2 VARCHAR(20) UNIQUE)

BEGIN TRAN
INSERT INTO @tab VALUES (1,'test')
ROLLBACK TRAN
SELECT * FROM @tab
GO

CREATE TABLE tab1 
(kol1 int IDENTITY (1,1), 
kol2 varchar(30))
GO
DBCC CHECKIDENT ('tab1', RESEED, 1)
GO
INSERT INTO tab1 (kol1, kol2) 
VALUES (17,'AAA')
GO
SET IDENTITY_INSERT tab1 ON
INSERT INTO tab1 (kol1, kol2) 
VALUES (17,'AAA')
GO
SELECT IDENTITYCOL 
FROM dbo.tab1
GO
SELECT IDENT_SEED ('dbo.tab1'), IDENT_INCR ('dbo.tab1')  
GO
SELECT IDENT_CURRENT('dbo.tab1')
GO
ALTER TABLE tab1
ADD kol3 AS 10*kol1
GO
ALTER TABLE tab1
ADD kol4 AS CAST(kol1/10 AS FLOAT) PERSISTED
GO
SELECT * 
INTO tab2
FROM HumanResources.Department
WHERE 1=2
GO
ALTER TABLE dbo.tab1 
ADD CONSTRAINT PK_tab1 PRIMARY KEY (kol1)
GO
ALTER TABLE dbo.tab1 
ADD CONSTRAINT UQ_tab1_kol2 UNIQUE (kol2)
GO
SELECT s.name AS schemat, t.name AS tabela, k.name AS ograniczenie, k.type_desc as typ, c.name AS kolumna
FROM sys.key_constraints AS k 
JOIN sys.tables AS t ON t.object_id = k.parent_object_id
JOIN sys.schemas AS s ON s.schema_id = t.schema_id
JOIN sys.index_columns AS ic ON ic.object_id = t.object_id and ic.index_id = k.unique_index_id
JOIN sys.columns AS c ON c.object_id = t.object_id and c.column_id = ic.column_id
ORDER BY schemat, tabela, ograniczenie
GO
ALTER TABLE dbo.tab1 
ADD CONSTRAINT DF_tab1_kol2 DEFAULT ('AAA') FOR kol2
GO
ALTER TABLE dbo.tab1 
ADD CONSTRAINT CK_tab1_kol4 CHECK (kol4 < kol1)
GO
CREATE TABLE tab3 
(kol1 INT PRIMARY KEY, 
kol2 VARCHAR(20),
kol3 INT CONSTRAINT FK_tab2_tab1 REFERENCES tab1 (kol1)  
ON DELETE SET NULL ON UPDATE SET DEFAULT)
GO
ALTER TABLE tab1 
NOCHECK CONSTRAINT ALL
GO
ALTER TABLE tab1 
WITH NOCHECK CHECK CONSTRAINT ALL
GO
DBCC CHECKCONSTRAINTS (tab1)
GO
DECLARE @FK VARCHAR(8000) 
DECLARE @Cur CURSOR 
SET @Cur = CURSOR FOR SELECT 'ALTER TABLE ' + QUOTENAME(s.name)+'.'+ QUOTENAME(object_name(fk.parent_object_id)) + ' DROP CONSTRAINT ' + QUOTENAME(fk.name)
FROM sys.foreign_keys fk JOIN sys.tables AS t ON t.object_id = fk.parent_object_id
JOIN sys.schemas AS s ON s.schema_id = t.schema_id
WHERE object_name(fk.parent_object_id)='Product' AND s.name = 'Production'
OPEN @Cur
FETCH NEXT FROM @Cur INTO @FK
WHILE @@FETCH_STATUS = 0
BEGIN
PRINT @FK 
-- EXEC (@FK) -- Po skasowaniu komentarza instrukcje bd wykonane
FETCH NEXT FROM @Cur INTO @FK
END
DEALLOCATE @Cur
GO

SELECT * 
INTO #temp1
FROM HumanResources.Employee
SELECT name 
FROM tempdb.sys.tables
GO
ALTER TABLE #temp1 
ADD kolx INT
GO

USE master
GO
CREATE PROC sp_globsrv AS
CREATE TABLE ##globsrv (kol1 INT)
GO
EXEC sp_procoption 'sp_globsrv','startup','true' 
GO

EXEC sp_configure 'user instances enabled',1
GO
/*
<connectionStrings>
     <add name="TestUserInstance.Settings.Database1ConnectionString" 
          connectionString="Data Source=.\SQLEXPRESS;
          AttachDbFilename=|DataDirectory|\ AdventureWorks_Data.mdf;
          Integrated Security=True;
          User Instance=True"
          providerName="System.Data.SqlClient" />
</connectionStrings>
*/
SELECT owning_principal_name, instance_pipe_name, heart_beat 
FROM sys.dm_os_child_instances 
GO