EXEC master.dbo.sp_addumpdevice  
@devtype = N'disk',
@logicalname = N'BacDevAdvWorks', 
@physicalname = N'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\Backup\Advwenture Works.bak'
GO
/*
RESTORE LABELONLY 
FROM DISK = 'C:\Backup\AdvwentureWorks.bak'
GO
RESTORE FILELISTONLY 
FROM BacDevAdvWorks
*/
BACKUP DATABASE AdventureWorks
TO BacDevAdvWorks
WITH FORMAT , EXPIREDATE = N'05/08/2007 00:00:00', NAME = N'Pena kopia bazy AdvWorks'
GO
BACKUP DATABASE AdventureWorks
TO BacDevAdvWorks
WITH DIFFERENTIAL, RETAINDAYS  = 1, NAME = 'Rnicowa kopia bazy AdvWorks'
GO
BACKUP LOG AdventureWorks
TO BacDevAdvWorks
GO
BACKUP LOG AdventureWorks
TO DISK = 'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\Backup\LogTail.bak'
WITH NO_TRUNCATE
GO

DECLARE @opis VARCHAR(250)  
SET @opis = 'Pena kopia bazy AdventureWorks utworzona ' + CONVERT(CHAR(16), GETDATE(), 120)
BACKUP DATABASE AdventureWorks 
TO BacDevAdvWorks 
WITH INIT, NAME =  @opis , RETAINDAYS  = 7
GO
--sqlcmd -S .\sqlexpress -i c:\backup\AdvWorkFull.sql

/*
Imports Microsoft.SqlServer.Management.Smo
Imports Microsoft.SqlServer.Management.Common
Module Module1
    Sub Main()
        Dim srv As New Server(".\SQLEXPRESS")
        Dim bk As New Microsoft.SqlServer.Management.Smo.Backup
        Dim bdi As BackupDeviceItem
        bdi = New BackupDeviceItem("TestSMOBackup", DeviceType.File)
        bk.Devices.Add(bdi)
        bk.Action = BackupActionType.Database
        bk.Database = "AdventureWorks"
        Dim backupdate As New Date
        backupdate = New Date(2007, 5, 9)
        bk.ExpirationDate = backupdate
        bk.SqlBackup(srv)
        bk.Devices.Remove(bdi)
        Console.WriteLine("Pena kopia wykonana pomylnie.")
    End Sub
End Module
*/

SELECT MAX(ISNULL(DATEDIFF(dd,b.backup_start_date,getdate()),0)) 'Ilo dni', b.type, 
d.name 
FROM master..sysdatabases d WITH (NOLOCK) 
LEFT JOIN msdb..backupset b WITH (NOLOCK) ON d.name = b.database_name 
AND b.backup_start_date = -- Odczytujemy ostatni dat wykonania kopii bazy o tej samej nazwie
(SELECT MAX(backup_start_date) 
FROM msdb..backupset b2 
WHERE b.database_name = b2.database_name) 
WHERE d.name != 'tempdb' -- Baza tempdb nie jest kopiowana
GROUP BY d.name, b.type
ORDER BY d.name
GO
USE master
RESTORE DATABASE AdventureWorks 
WITH RECOVERY
GO
RESTORE DATABASE AdventureWorks 
FROM  BacDevAdvWorks 
WITH  NORECOVERY, FILE = 1, REPLACE
GO
RESTORE DATABASE AdventureWorks 
FROM  BacDevAdvWorks 
WITH  NORECOVERY, FILE = 2
GO
RESTORE LOG AdventureWorks 
FROM  BacDevAdvWorks 
WITH  NORECOVERY, FILE = 2
GO
RESTORE LOG AdventureWorks 
FROM  BacDevAdvWorks 
WITH  NORECOVERY, FILE = 3
GO
RESTORE LOG AdventureWorks 
FROM BacDevAdvWorks 
WITH FILE = 3 -- ,STOPAT = N'2007-05-02T11:29:00'
GO

/*
BACKUP LOG AdventureWorks
TO BacDevAdvWorks

RESTORE DATABASE AdventureWorks 
PAGE = '1:21490, 1:20648, 1:21491, 1:20651'
FROM  BacDevAdvWorks 
WITH  NORECOVERY, FILE = 1, REPLACE
*/

/*
Imports Microsoft.SqlServer.Management.Smo

Module Module1

    Sub Main()
        Dim svr As Server = New Server(".\SQLEXPRESS")
        Dim res As Restore = New Restore
        Dim bdi As New BackupDeviceItem("BacDevAdvWorks", DeviceType.LogicalDevice)
        res.Devices.Add(bdi)
        If res.SqlVerify(svr) = True Then
            Console.WriteLine("OK")
        End If
    End Sub

End Module
*/
A
/*
RESTORE DATABASE KopiaAdventureWorks 
FROM BacDevAdvWorks
WITH  FILE = 1, 
MOVE N'AdventureWorks_Data' TO N'g:\Data\KopiaAdventureWorks.mdf',  
MOVE N'AdventureWorks_Log' TO N'g:\Data\KopiaAdventureWorks.ldf'
*/

--start /wait setup.exe /qn INSTANCENAME=SQLEXPRESS REINSTALL=SQL_Engine REBUILDDATABASE=1 SAPWD=<Haso konta sa> 

