SELECT name, type_desc FROM sys.system_objects 
WHERE name LIKE N'dm_%' 
ORDER BY name
GO

SELECT net_transport
FROM sys.dm_exec_connections
WHERE session_id=@@SPID
GO

EXEC sp_configure 'show advanced options',1
RECONFIGURE
-- Teraz zmieniamy dan opcj
EXEC sp_configure 'show advanced options',0
RECONFIGURE
GO
EXEC sp_configure 'priority boost',1
RECONFIGURE
GO
EXEC sp_configure 'recovery interval',5
RECONFIGURE
EXEC sp_configure 'query wait (s)',-1
RECONFIGURE
GO
EXEC sp_configure 'Query Governor Cost Limit',300
RECONFIGURE
GO
EXEC sp_configure 'xp_cmdshell',1
RECONFIGURE
GO

USE master
GO
CREATE DATABASE [KOPIA mssqlsystemresource] ON 
(FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\Data\Kopia mssqlsystemresource.mdf' ),
(FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\Data\Kopia mssqlsystemresource.ldf' )
 FOR ATTACH
GO
/*
C:\>"C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\Binn\sqlservr.exe" -m -s SQLEXPRESS
USE MSSQLSYSTEMRESOURCE
GO
*/

SELECT *
FROM sys.database_files 
GO
USE tempdb
GO
CREATE TABLE tbl1 (kol1 VARCHAR(4500), kol2 VARCHAR(4500))
GO
INSERT INTO tbl1
VALUES (REPLICATE('A',4500),REPLICATE('B',4500))
GO
ALTER TABLE tbl1
ADD kol3 TEXT
GO
EXEC sp_tableoption 'tbl1','text in row',2000
GO
DBCC IND (tempdb,tbl1,-1)
DBCC TRACEON (3604)
DBCC PAGE (tempdb,1,174,1)
GO

BACKUP LOG AdventureWorks
TO DISK = 'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\Backup\AdvLog.bak'
GO
DBCC OPENTRAN (AdventureWorks)
GO
KILL 53
GO
DBCC SQLPERF ('logspace')
GO
ALTER DATABASE AdventureWorks 
ADD LOG FILE (
NAME = N'TempLog', FILENAME = N'g:\TempLog.ldf' , SIZE = 102400KB ) 
GO
SELECT DB_NAME(s.database_id), recovery_model_desc, last_log_backup_lsn
FROM sys.database_recovery_status s
JOIN sys.databases d ON s.database_id = d.database_id
WHERE s.database_id>4
GO

CREATE DATABASE db1
GO
SELECT *
INTO db1..tab1
FROM AdventureWorks.HumanResources.Employee
GO
ALTER DATABASE db1 SET SINGLE_USER
WITH ROLLBACK AFTER 5
GO
DBCC CHECKDB (db1,REPAIR_REBUILD)
GO
USE db1
DBCC CHECKCONSTRAINTS
WITH ALL_CONSTRAINTS  
GO
DBCC CHECKDB (db1,REPAIR_ALLOW_DATA_LOSS)
GO
ALTER DATABASE db1 
SET  MULTI_USER 
GO
BEGIN TRAN
UPDATE db1..tab1
SET LoginID = UPPER(LoginID)
GO
SELECT state_desc 
FROM sys.databases
WHERE name = 'db1'
GO
SELECT * 
FROM db1..tab1
GO
ALTER DATABASE db1 
SET EMERGENCY
GO
SELECT * 
FROM db1..tab1
GO

SELECT name
FROM sys.objects
WHERE type = 'S'
ORDER BY name 
GO
SELECT DatabasePropertyEx('AdventureWorks' , 'status')
GO

ALTER DATABASE AdventureWorks 
SET RECOVERY FULL
GO
ALTER DATABASE AdventureWorks 
SET RESTRICTED_USER
WITH ROLLBACK IMMEDIATE
GO
USE AdventureWorks
SET ANSI_NULLS ON
SELECT COUNT(*)
FROM Person.Address
WHERE AddressLine2 = NULL
GO
SET ANSI_NULLS OFF
SELECT COUNT(*)
FROM Person.Address
WHERE AddressLine2 = NULL
GO

USE master
GO
ALTER DATABASE AdventureWorks 
ADD FILE 
(NAME = N'AdvWorks', FILENAME = N'c:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\DATA\AdvWorks.ndf' , SIZE = 51200KB) 
TO FILEGROUP [PRIMARY]
GO
SELECT *
INTO AdventureWorks..tab1
FROM AdventureWorks.Sales.SalesOrderDetail
GO
ALTER DATABASE AdventureWorks
REMOVE FILE AdvWorks
GO
USE AdventureWorks
DBCC SHRINKFILE (AdvWorks, EMPTYFILE)
GO
ALTER DATABASE AdventureWorks
REMOVE FILE AdvWorks
GO

SELECT o.name as tabela, k.name as kolumna, t.name AS typ 
FROM sys.columns k 
JOIN sys.objects  o ON k.object_id = o.object_id 
JOIN sys.types t ON k.system_type_id = t.system_type_id 
WHERE (OBJECTPROPERTY(k.object_id, N'IsSystemTable') = 0)
GO
SELECT name, definition 
FROM sys.objects o
JOIN sys.sql_modules s ON o.object_id=s.object_id
GO
SELECT login_name, COUNT(session_id) lsesji, SUM (reads*8) odczyt, SUM(writes*8) zapis
FROM sys.dm_exec_sessions 
GROUP BY login_name
ORDER BY count(session_id) DESC
GO
SELECT login_name, c.session_id, connect_time, client_net_address
FROM sys.dm_exec_connections c
JOIN sys.dm_exec_sessions s ON c.session_id = s.session_id
GO
SELECT transaction_type, COUNT(transaction_id)
FROM sys.dm_tran_active_transactions
GROUP BY transaction_type
GO
SELECT query_plan 
FROM sys.dm_exec_cached_plans 
CROSS APPLY sys.dm_exec_query_plan (plan_handle)
GO
SELECT sql.text, qs.execution_count, p.query_plan
FROM sys.dm_exec_query_stats qs 
CROSS APPLY sys.dm_exec_sql_text(sql_handle) sql
CROSS APPLY sys.dm_exec_query_plan(plan_handle) p
WHERE query_plan.exist('
declare default element namespace "http://schemas.microsoft.com/sqlserver/2004/07/showplan";
/ShowPlanXML/BatchSequence/Batch/Statements//RelOp/@PhysicalOp[. = ''Clustered Index Scan''] ') = 1
GO

