USE master
GO
ALTER DATABASE  AdventureWorks
SET SINGLE_USER 
WITH ROLLBACK IMMEDIATE 
GO
SP_DETACH_DB 'SUSDB'
GO
--msiexec /x {CEB5780F-1A70-44A9-850F-DE6C4F6AA8FB} callerid=ocsetup.exe
--msiexec /x {BDD79957-5801-4A2D-B09E-852E7FA64D01} callerid=ocsetup.exe

USE AdventureWorks2000
GO
DBCC CHECKDB
GO
ALTER DATABASE AdventureWorks2000
SET READ_ONLY
WITH ROLLBACK IMMEDIATE
GO
BACKUP DATABASE AdventureWorks2000
TO DISK ='E:\aw2k.bak'
WITH INIT
GO
RESTORE VERIFYONLY 
FROM DISK ='E:\aw2k.bak'
GO
RESTORE DATABASE AdventureWorks2000
FROM DISK = 'E:\aw2k.bak'
WITH MOVE 'AdventureWorks2000_Data' 
TO 'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\Data\AW2K.MDF',
MOVE 'AdventureWorks2000_Log' TO 'E:\aw2k.ldf',
MOVE 'TransactionHistory2000' TO 'G:\TransactionHistory2000.NDF'
GO
ALTER DATABASE AdventureWorks2000
SET READ_WRITE
GO

EXEC sp_change_users_login 'Report'
GO
EXEC sp_change_users_login 'Auto_Fix', 'danka', NULL, 'Pa$$w0rd'
GO

USE AdventureWorks2000
GO
DECLARE @User VARCHAR(8000)
DECLARE @Cur  CURSOR  
DECLARE @cSQL VARCHAR(8000)
SET @Cur = CURSOR FOR SELECT name FROM sys.sysusers WHERE uid>4 AND islogin=1
OPEN @Cur
FETCH NEXT FROM @Cur INTO @User
WHILE @@FETCH_STATUS = 0
BEGIN
SET @cSQL = ' ALTER USER ' + @User + ' WITH DEFAULT_SCHEMA=[dbo]'
EXEC (@cSQL)
--PRINT @cSQL --po skasowaniu komentarza zobaczymy wykonywane instrukcje
FETCH NEXT FROM @Cur INTO @User    
END
DEALLOCATE @Cur
GO

DBCC CHECKDB ('AdventureWorks2000') 
WITH DATA_PURITY
GO
EXEC dbo.sp_dbcmptlevel 'AdventureWorks2000', 90
GO
EXEC sp_updatestats 
GO
SELECT O.name AS Tabela, rows AS lWierszy
FROM sys.sysobjects O LEFT JOIN sys.sysindexes I ON O.id = I.id 
WHERE I.indid < 2 
AND OBJECTPROPERTY(O.id, N'IsTable') = 1 
AND O.status >= 0
AND  O.name LIKE 'A%'   -- Wybieramy tabele o nazwach zaczynajcych si od litery A
ORDER BY Tabela

/*
SELECT DISTINCT object_name(object_id) as nazwa, partition_number as partycja, rows 
FROM sys.partitions p JOIN sys.allocation_units a 
ON p.partition_id = a.container_id 
ORDER BY nazwa
*/
GO
DBCC UPDATEUSAGE ('AdventureWorks2000')
GO
USE master
GO
ALTER DATABASE tempdb MODIFY FILE ( NAME = N'tempdev', SIZE = 102400KB )
GO
ALTER DATABASE tempdb MODIFY FILE ( NAME = N'templog', SIZE = 30720KB )
GO



