Listing 17.1
DECLARE
	gross NUMBER;
	budget NUMBER;
	profit NUMBER;
	movie_id INT(6);
BEGIN
	gross := 50;
	budget := 75;
	movie_id := 1;
	profit := budget - gross;
	INSERT INTO Movie_Profit VALUES (movie_id, profit);
END;
.
/


Listing 17.2
DECLARE
	gross NUMBER := 75;
	budget NUMBER := 50;
	profit NUMBER;
	movie_id INT(6) := 1;
BEGIN
	profit := budget - gross;
	INSERT INTO Movie_Profit VALUES (movie_id, profit);
END;
.
/


Listing 17.3
DECLARE
	gross NUMBER := 75;
	budget NUMBER := 50;
	profit NUMBER;
	movie_id INT(6) := 1;
BEGIN
	gross := 77;
	budget := 56;
	movie_id := 8;
	profit := budget - gross;
	INSERT INTO Movie_Profit VALUES (movie_id, profit);
END;
.
/


Listing 17.4
DECLARE
	profit NUMBER;
	CURSOR movies_cursor IS
		SELECT movie_id, budget, gross
		FROM Movies;
	movies_rec movies_cursor%ROWTYPE;


Listing 17.5
DECLARE 
	crow INT := 10;
BEGIN
	IF crow < 10 THEN
		INSERT INTO Test
		VALUES (crow);
	ELSIF crow > 10 THEN
		INSERT INTO Test
		VALUES (crow * 2);
	ELSE	
		INSERT INTO Test
		VALUES (crow / 2);
	END IF;
END;
.
/


Listing 17.6
DECLARE 
	crow INT := 10;
BEGIN
	IF crow > 5 THEN
		IF crow < 15 THEN
		INSERT INTO Test
			VALUES (crow);
		END IF;
	END IF;
END;


Listing 17.7
DECLARE 
	crow INT := 1;
BEGIN
	LOOP
		INSERT INTO Test
		VALUES (crow);
		EXIT WHEN crow = 10;
		crow := crow + 1;
	END LOOP;
END;
.
/


Listing 17.8
DECLARE 
	crow INT;
BEGIN
	FOR crow IN 1 .. 10 LOOP
		INSERT INTO Test
		VALUES (crow);
	END LOOP;
END;
.
/


Listing 17.9
DECLARE
	profit NUMBER;
	temp NUMBER;
	CURSOR movies_cursor IS
		SELECT movie_id, budget, gross
		FROM Movies;
	movies_rec movies_cursor%ROWTYPE;
BEGIN
	FOR movies_rec IN movies_cursor LOOP
		temp := movies_rec.gross - movies_rec.budget;
		INSERT INTO Movie_Profit
		VALUES (movies_rec.movie_id, temp);
	END LOOP;
END;
.
/


Listing 17.10
DECLARE 
	crow INT := 1;
BEGIN
	WHILE crow <= 10 LOOP
		INSERT INTO Test
		VALUES (crow);
		crow := crow + 1;
	END LOOP;
END;
.
/


Listing 17.11
DECLARE
	profit NUMBER;
	CURSOR movies_crsr IS
		SELECT movie_id, budget, gross
		FROM Movies;
	movies_rec movies_crsr%ROWTYPE;
BEGIN
	OPEN movies_crsr;
	WHILE movies_crsr%FOUND LOOP
		FETCH movies_crsr INTO movies_rec;
		INSERT INTO Movie_Profit
		VALUES (movies_rec.movie_id, 
(movies_rec.gross - movies_rec.budget));
	END LOOP;
END;
.
/



Listing 17.12
DECLARE 
	crow INT;
	bar VARCHAR2(20);
BEGIN
	crow := 5;
	bar := 'baz';
	INSERT INTO Test
	VALUES (crow + bar);
EXCEPTION
	WHEN INVALID_NUMBER THEN
		INSERT INTO Test
		VALUES ('Bd');
END;
.
/


Listing 17.13
DECLARE
	crow INT;
	number_too_large EXCEPTION;
BEGIN
	FOR crow IN 1 .. 100 LOOP
		IF crow = 99 THEN
			RAISE number_too_large;
		END IF;
	END LOOP;
EXCEPTION
	WHEN number_too_large THEN
		RAISE_APPLICATION_ERROR (-20001, 'Liczba jest zbyt dua.');
END;
.
/


Listing 17.14
CREATE OR REPLACE PROCEDURE calculate_profit
	(
gross IN NUMBER,
	budget IN NUMBER,
	profit OUT NUMBER,
	movie_id IN OUT INT(6)
)
AS
BEGIN
	profit := budget - gross;
	INSERT INTO Movie_Profit VALUES (movie_id, profit);
END;


Listing 17.15
CREATE OR REPLACE FUNCTION get_profit
(in_movie_id IN INT)
RETURN NUMBER
IS profit NUMBER;
BEGIN
SELECT gross - budget INTO profit
WHERE movie_id = in_movie_id;
RETURN (profit);
END;


Listing 17.16
SELECT movie_title, get_profit(movie_id)
FROM Movies


Listing 17.17
CREATE OR REPLACE PACKAGE movie_profit
AS
	FUNCTION get_profit 
		(movie_id IN INT);
PROCEDURE store_studio_profit
	(studio IN NUMBER,
	profit IN NUMBER);
END movie_profit; 


Listing 17.18
CREATE OR REPLACE PACKAGE BODY movie_profit
AS
FUNCTION get_profit
(in_movie_id IN INT)
RETURN NUMBER
IS profit NUMBER;
BEGIN
SELECT gross - budget INTO profit
WHERE movie_id = in_movie_id;
RETURN (profit);
END get_profit;
PROCEDURE store_studio_profit
(studio IN NUMBER,
	profit IN NUMBER)
AS
BEGIN
INSERT INTO studio_profit
(studio_id, date_of_entry, studio_profit)
VALUES
(studio, SYSDATE, profit);
END store_studio_profit;
END movie_profit;


Listing 17.19
DECLARE 
CURSOR movies_cursor IS
	SELECT movie_title
	FROM Movies
	WHERE studio_id = 1;
movie_rec movies_cursor%ROWTYPE;
BEGIN
	WHILE movies_cursor%FOUND LOOP
		FETCH movies_cursor INTO movie_rec;
		PUT_LINE (movie_rec.movie_title);
	END LOOP;
END;
.
/


Listing 17.20
CREATE OR REPLACE TRIGGER movies_insert
BEFORE INSERT ON Movies
FOR EACH ROW WHEN (new.budget < 10)
DECLARE
	budget_too_low EXCEPTION;
BEGIN
	RAISE budget_too_low;
EXCEPTION
	WHEN budget_too_low THEN
		RAISE_APPLICATION_ERROR (-20001,
         'Budet filmu jest zbyt niski.');

END;


Listing 17.21
INSERT INTO Movies
(movie_id, movie_title, studio_id, director_id, 
budget, gross, release_date)
VALUES
(15, 'Test Movie', 1, 2, 15, 15, '21-MAY-99');


Listing 17.22
INSERT INTO Movies
(movie_id, movie_title, studio_id, director_id, 
budget, gross, release_date)
VALUES
(16, 'Test Movie', 1, 2, 5, 5, '21-MAY-99');


Listing 17.23
CREATE VIEW Movie_Roles_Test (movie_id, title, role)
AS 
SELECT Movies.movie_id, movie_title, role
FROM Movies, Cast_Movies
WHERE Movies.movie_id = 3
AND Movies.movie_id = Cast_Movies.movie_id


Listing 17.24
CREATE OR REPLACE TRIGGER movie_roles_update
INSTEAD OF UPDATE ON Movies_Roles_Test
FOR EACH ROW
BEGIN
UPDATE Movies
SET title = :new.title
WHERE movie_id = :new.movie_id;
UPDATE Cast_Movies
SET role = :new.role
WHERE movie_id = :new.movie_id
AND role = :old.role;
END;


