Listing 15.1
CREATE PROCEDURE get_movie_titles
AS
SELECT movie_title
FROM Movies

GO


Listing 15.2
get_movies_titles


Listing 15.3
IF object_id('get_movie_titles') IS NOT NULL
BEGIN
	DROP PROCEDURE get_movie_titles
END

GO


Listing 15.4
CREATE PROCEDURE get_movie_titles @studio_id INTEGER
AS
SELECT movie_title
FROM Movies
WHERE studio_id = @studio_id

GO


Listing 15.5
get_movie_titles 1


Listing 15.6
IF object_id('get_movie_titles') IS NOT NULL
BEGIN
	DROP PROCEDURE get_movie_titles
END

GO

CREATE PROCEDURE get_movie_titles @studio_id INTEGER,
@director_id INTEGER
AS
SELECT movie_title
FROM Movies
WHERE studio_id = @studio_id
AND director_id = @director_id

GO

get_movie_titles 3, 9


Listing 15.7
DECLARE @studio_id VARCHAR(25)

SELECT @studio_id = '3'

PRINT @studio_id


Listing 15.8
DECLARE @cnt INT

SELECT @cnt = COUNT(*)
FROM Movies

PRINT CONVERT(VARCHAR(25), @cnt)

GO


Listing 15.9
DECLARE @average VARCHAR(25)

SELECT @average = CONVERT(VARCHAR(25), (SELECT AVG(budget) FROM Movies))

PRINT @average

GO


Listing 15.10
	DECLARE @title VARCHAR(25)

SELECT @title = movie_title
FROM Movies

PRINT @title

GO


Listing 15.11
DECLARE @var VARCHAR(25)

SELECT @var = CONVERT(VARCHAR(25), AVG(budget))
FROM Movies
WHERE budget < 0

PRINT @var

GO


Listing 15.12
DECLARE @var DEC
SEELCT @var = ISNULL(AVG(budget), 0)
FROM Movies
WHERE budget < 0

PRINT @var

GO


Listing 15.13
DECLARE @thing INT
SELECT @thing = 10
IF @thing > 5 
	UPDATE Movies
	SET release_date = GETDATE()
	WHERE movie_id = @thing
GO


Listing 15.14
DECLARE @thing INT
SELECT @thing = 10
IF @thing > 5 AND @thing < 10
	UPDATE Movies
	SET release_date = GETDATE()
	WHERE movie_id = @thing
GO


Listing 15.15
IF (SELECT COUNT(*) FROM Movies) < 15 
	SELECT movie_title
	FROM Movies


Listing 15.l6
IF EXISTS (SELECT movie_id FROM Movies WHERE studio_id = 10)
	SELECT DISTINCT studio_id
	FROM Movies


Listing 15.17
DECLARE @new_revenue DEC

IF EXISTS (SELECT movie_id FROM Movies WHERE studio_id = 1)
	BEGIN
		SELECT @new_revenue = 50

		UPDATE Movies
		SET gross = @new_revenue
		WHERE studio_id = 1
	END


Listing 15.18
IF EXISTS (SELECT * FROM Movies WHERE studio_id = 8) 
	SELECT COUNT(*) FROM Movies 
WHERE studio_id = 8
ELSE
	PRINT "Nie znaleziono pasujcych filmw."


Listing 15.19
DECLARE @thing INT
SELECT @thing = 7
IF @thing > 5
	IF @thing > 10
		PRINT "Zmienna num jest wiksza od 10"
	ELSE
		PRINT "Zmienna num jest wiksza od 5"
ELSE
	PRINT "Zmienna num jest mniejsza lub rwna 5"


Listing 15.20
DECLARE @first_value INT
DECLARE @second_value INT
SELECT @first_value = 1
SELECT @second_value = 2
IF @first_value = 1
	IF @second_value = 2
		PRINT "Both conditions were true."


Listing 15.21
DECLARE @first_value INT
DECLARE @second_value INT
SELECT @first_value = 1
SELECT @second_value = 2
IF @first_value = 1 AND @second_value = 2
	PRINT "Oba warunki s prawidowe."


Listing 15.22
DECLARE @foo INT
DECLARE @bar INT
DECLARE @display VARCHAR(25)
SELECT @foo = 1
SELECT @bar = 2

IF @foo > 10
	BEGIN
		SELECT @display = CONVERT(VARCHAR(25), @foo - @bar)
		PRINT @display
	END
ELSE
	BEGIN
		SELECT @display = CONVERT(VARCHAR(25), @foo + @bar)
		PRINT @display
	END


Listing 15.23
DECLARE @foo INT
DECLARE @display VARCHAR(25)
SELECT @foo = 1
WHILE @foo < 5
	BEGIN
		SELECT @display = CONVERT(VARCHAR(25), @foo)
		PRINT @display
		SELECT @foo = @foo + 1
	END


Listing 15.24
DECLARE @foo INT
SELECT @foo = 1
WHILE @foo <> 10 
	BEGIN 
		PRINT @foo
		SELECT @foo = @foo + 2
	END


Listing 15.25
DECLARE @total INT
WHILE 1 = 1
	BEGIN
		SELECT @total = COUNT(*) FROM A_Table
		IF @total > 100
			BREAK
		INSERT INTO A_Table 
		(primary_key) 
		VALUES (@total + 1)
	END


Listing 15.26
DECLARE @total_studios INT
DECLARE @cnt INT
DECLARE @rev INT
SELECT @studios = MAX(studio_id)
FROM Movies
WHILE @cnt <= @total_studios
	BEGIN
		SELECT @rev = SUM(gross)
		FROM Movies
		WHERE studio_id = @cnt
		IF @rev < 100
			CONTINUE
		SELECT movie_title
		FROM Movies
		WHERE studio_id = @cnt
	END


Listing 15.27
DECLARE @day INT
DECLARE @hour INT
DECLARE @display VARCHAR(25)
SELECT @day = 1
WHILE @day <= 7
	BEGIN
	SELECT @display = CONVERT(VARCHAR(25), @day)
	PRINT @display
	SELECT @hour = 1
	WHILE @hour <= 24
		BEGIN
		SELECT @display = CONVERT(VARCHAR(25), @hour)
		PRINT @display
		SELECT @hour = @hour + 1
		END
	SELECT @day = @day + 1
	END


Listing 15.28
DECLARE get_movies CURSOR
FOR SELECT movie_title, gross, budget
FROM Movies
OPEN get_movies
-- Pobieranie pierwszego wiersza z kursora
FETCH get_movies INTO @title, @gross, @budget
-- Iteracyjne przetworzenie pozostaych wierszy
WHILE @@fetch_status = 0
	BEGIN
	IF @gross >= @budget 
		PRINT UPPER(@title)
	ELSE
		PRINT LOWER(@title)
FETCH get_movies INTO @title, @gross, @budget
	END


Listing 15.29
CREATE TRIGGER movies_insert
ON Movies
FOR INSERT
AS
BEGIN
	IF budget > 100
		BEGIN
	ROLLBACK TRANSACTION
			PRINT "Pole budget nie moe przekracza wartoci 100"
		END
END


Listing 15.30
INSERT INTO Movies
(movie_id, movie_title, studio_id, director_id, gross,
budget, release_date)
VALUES
(15, 'Test', 3, 5, 50, 101, GetDate())


Listing 15.31
CREATE TRIGGER movie_update
ON Movies
FOR UPDATE
AS
BEGIN
    IF UPDATE(movie_title)
        BEGIN
            ROLLBACK TRANSACTION
            PRINT "Tytu filmu nie moe by zmieniony."
        END
END


Listing 15.32
UPDATE Movies
SET movie_title = 'Nowy Tytu'
WHERE movie_id = 1


UPDATE Movies
SET budget = 25
WHERE movie_id = 1


