-- Wczytaj bazę sqlda.

$ psql sqlda

-- Pobierz kolumnę sales_transaction_date z transakcjami dotyczącymi modelu Lemon z 2013 r. Wstaw tę kolumnę do tabeli lemon_sales.

sqlda=# SELECT sales_transaction_date INTO lemon_sales FROM sales WHERE product_id=3;

-- Zlicz rekordy z transakcjami dotyczące modelu Lemon z 2013 r.

sqlda=# SELECT count(sales_transaction_date) FROM lemon_sales;

-- Wyświetl najnowszą wartość z kolumny sales_transaction_date. Użyj do tego funkcji max.

sqlda=# SELECT max(sales_transaction_date) FROM lemon_sales;

-- Przekształć typ kolumny sales_transaction_date na date.

sqlda=# ALTER TABLE lemon_sales ALTER COLUMN sales_transaction_date TYPE DATE;

-- Określ liczbę transakcji z poszczególnych dni z tabeli lemon_sales. Wstaw wynikowe dane do tabeli lemon_sales_count.

sqlda=# SELECT *, COUNT(sales_transaction_date) INTO lemon_sales_count FROM lemon_sales GROUP BY sales_transaction_date ORDER BY sales_transaction_date;

-- Oblicz sumę skumulowaną liczby transakcji i wstaw wyniki do nowej tabeli, lemon_sales_sum.

sqlda=# SELECT *, sum(count) OVER (ORDER BY sales_transaction_date) INTO lemon_sales_sum FROM lemon_sales_count;

-- Za pomocą funkcji lag wyznacz wartości kolumny sum sprzed siedmiu dni i wstaw wyniki do tabeli lemon_sales_delay.

sqlda=# SELECT *, lag(sum, 7) OVER (ORDER BY sales_transaction_date) INTO lemon_sales_delay FROM lemon_sales_sum;

-- Oblicz tempo przyrostu liczby sprzedaży na podstawie danych z tabeli lemon_sales_delay. Zapisz wynikową tabelę pod nazwą lemon_sales_growth. 
-- Kolumnę z tempem przyrostu nazwij volume.

sqlda=# SELECT *, (sum-lag)/lag AS volume INTO lemon_sales_growth FROM lemon_sales_delay;

-- Zbadaj pierwsze 22 rekordy z tabeli lemon_sales_growth, analizując dane z kolumny volume.

sqlda=# SELECT * FROM lemon_sales_growth LIMIT 22;

