-- Utwórz bazę danych smalljoins na serwerze PostgreSQL.

$ createdb smalljoins

-- Wczytaj plik smalljoins.dump.

$psql smalljoins < smalljoins.dump

-- Otwórz bazę danych.

$ psql smalljoins

-- Zbadaj informacje dostępne w tabeli customers.

smalljoins=# SELECT * FROM customers;

-- Sprawdź informacje dostępne w tabeli order_info.

smalljoins=# SELECT * FROM order_info;

-- Wykonaj złączenie INNER JOIN, aby pobrać z obu tabel wszystkie kolumny (ale bez powielania kolumny customer_id).

smalljoins=# SELECT customers.*, order_info.order_id, order_info.product_code, order_info.qty FROM customers INNER JOIN order_info ON customers.customer_id=order_info.customer_id;

-- Zapisz wyniki tej kwerendy w odrębnej tabeli. W tym celu dodaj do kwerendy fragment INTO nazwa_tabeli.

smalljoins=# SELECT customers.*, order_info.order_id, order_info.product_code, order_info.qty INTO join_results FROM customers INNER JOIN order_info ON customers.customer_id=order_info.customer_id;

-- Użyj instrukcji EXPLAIN ANALYZE, aby oszacować czas potrzebny na przeprowadzenie złączenia.

smalljoins=# EXPLAIN ANALYZE SELECT customers.*, order_info.order_id, order_info.product_code, order_info.qty FROM customers INNER JOIN order_info ON customers.customer_id=order_info.customer_id;

-- Pobierz wszystkie wartości kolumny customer_id z tabeli order_info i 
-- użyj instrukcji EXPLAIN ANALYZE do ustalenia, ile czasu zajmuje wykonanie poszczególnych kwerend.

smalljoins=# EXPLAIN ANALYZE SELECT * FROM customers WHERE customer_id IN (SELECT customer_id FROM order_info);

-- Wykonaj złączenie lewostronne, używając tabeli customers jako lewej i tabeli order_info jako prawej.

smalljoins=# SELECT customers.*, order_info.order_id, order_info.product_code, order_info.qty FROM customers LEFT JOIN order_info ON customers.customer_id=order_info.customer_id;

-- Użyj instrukcji EXPLAIN ANALYZE, aby określić czas i koszt wykonania złączenia.

smalljoins=# EXPLAIN ANALYZE SELECT customers.*, order_info.order_id, order_info.product_code, order_info.qty FROM customers LEFT JOIN order_info ON customers.customer_id=order_info.customer_id;

-- Zastąp złączenie lewostronne z kroku 11. złączeniem prawostronnym i przyjrzyj się wynikom.

smalljoins=# EXPLAIN ANALYZE SELECT customers.*, order_info.order_id, order_info.product_code, order_info.qty FROM customers RIGHT JOIN order_info ON customers.customer_id=order_info.customer_id;

-- Użyj instrukcji EXPLAIN ANALYZE, aby ocenić czas i koszt przeprowadzenia złączenia prawostronnego.

smalljoins=# EXPLAIN ANALYZE SELECT customers.*, order_info.order_id, order_info.product_code, order_info.qty FROM customers RIGHT JOIN order_info ON customers.customer_id=order_info.customer_id;

-- Wstaw do tabeli order_info dodatkowy wiersz z wartością pola customer_id, która nie występuje w tabeli customers.

smalljoins=# INSERT INTO order_info (order_id, customer_id, product_code, qty) VALUES (1621, 6, 'MEL386', 1);

-- Zastąp złączenie lewostronne z kroku 11. pełnym złączeniem zewnętrznym i przyjrzyj się wynikom.

smalljoins=# SELECT customers.*, order_info.order_id, order_info.product_code, order_info.qty FROM customers FULL OUTER JOIN order_info ON customers.customer_id=order_info.customer_id;

-- Użyj instrukcji EXPLAIN ANALYZE, aby ocenić wydajność kwerendy.

smalljoins=# EXPLAIN ANALYZE SELECT customers.*, order_info.order_id, order_info.product_code, order_info.qty FROM customers FULL OUTER JOIN order_info ON customers.customer_id=order_info.customer_id;










