-- Wczytaj bazę sqlda.

$ psql sqlda

-- Oblicz dzienną sumę skumulowaną liczby transakcji, używając instrukcji OVER i ORDER BY. Wstaw wyniki do nowej tabeli, bat_sales_growth.

sqlda=# SELECT *, sum(count) OVER (ORDER BY sales_transaction_date) INTO bat_sales_growth FROM bat_sales_daily;

-- Pobierz wartość kolumny sum sprzed siedmiu dni (za pomocą funkcji lag), a następnie wstaw wszystkie kolumny 
-- z tabeli bat_sales_daily i nową kolumnę lag do nowej tabeli, bat_sales_daily_delay. Kolumna lag informuje o poziomie 
-- sprzedaży sprzed tygodnia, co pozwala porównywać aktualną sprzedaż z poziomem z wcześniejszego tygodnia.

sqlda=# SELECT *, lag(sum, 7) OVER (ORDER BY sales_transaction_date) INTO bat_sales_daily_delay FROM bat_sales_growth;

-- Sprawdź pierwszych 15 wierszy z tabeli bat_sales_growth.

sqlda=# SELECT * FROM bat_sales_daily_delay LIMIT 15;

-- Oblicz procentowy przyrost liczby transakcji, porównując aktualną liczbę 
-- sprzedaży z poziomem sprzed tygodnia. Wstaw wynikowe wartości do nowej tabeli, bat_sales_delay_vol.

sqlda=# SELECT *, (sum-lag)/lag AS volume INTO bat_sales_delay_vol FROM bat_sales_daily_delay ;

-- Porównaj pierwsze 22 wartości z tabeli bat_sales_delay_vol, aby przekonać się o spadku sprzedaży.

sqlda=# SELECT * FROM bat_sales_delay_vol LIMIT 22;




