-- Otwieranie PostgreSQL i nawiąż połączenie z bazą sqlda.

C:\> psql sqlda

-- Zacznij od tabeli customers i użyj polecenia EXPLAIN, aby ustalić koszt kwerendy i liczbę wierszy zwracanych, gdy 
-- pobierane są wszystkie rekordy z kolumną state o wartości FO

sqlda=# EXPLAIN SELECT * FROM customers WHERE state='FO';

-- Ustal, ile unikatowych wartości występuje w kolumnie state. Ponownie użyj polecenia EXPLAIN.

sqlda=# EXPLAIN SELECT DISTINCT state FROM customers;

-- Utwórz indeks ix_state dla kolumny state z tabeli customers.

sqlda=# CREATE INDEX ix_state ON customers(state);

-- Ponownie uruchom instrukcję EXPLAIN.

sqlda=# EXPLAIN SELECT * FROM customers WHERE state='FO';

-- Użyj polecenia EXPLAIN, aby wyświetlić plan wykonywania kwerendy wyszukującej w bazie wszystkie rekordy z danymi mężczyzn.

sqlda=# EXPLAIN SELECT * FROM customers WHERE gender='M';

-- Utwórz indeks ix_gender dla kolumny gender z tabeli customers.

sqlda=# CREATE INDEX ix_gender ON customers(gender);

-- Upewnij się, że indeks jest dostępny. W tym celu użyj instrukcji \d.

\d customers;

-- Ponownie uruchom instrukcję EXPLAIN.

sqlda=# EXPLAIN SELECT * FROM customers WHERE gender='M';

-- Użyj instrukcji EXPLAIN, aby wyświetlić plan wykonywania kwerendy wyszukującej 
-- dane klientów zamieszkujących obszar o szerokości geograficznej od 30 do 38 stopni

sqlda=# EXPLAIN SELECT * FROM customers WHERE (latitude < 38) AND (latitude > 30);

-- Utwórz indeks ix_latitude dla kolumny latitude z tabeli customers.

sqlda=# CREATE INDEX ix_latitude ON customers(latitude);

-- Użyj instrukcji EXPLAIN do pobrania planu wykonywania kwerendy zwracającej dane z tabeli customers 
-- dotyczące klientów, których szerokość geograficzna miejsca zamieszkania wynosi od 30 do 38 stopni.

sqlda=# EXPLAIN SELECT * FROM customers WHERE (latitude < 38) AND (latitude > 30);

-- Użyj instrukcji EXPLAIN ANALYZE do pobrania planu wykonywania kwerendy zwracającej dane z tabeli customers 
-- dotyczące klientów, których szerokość geograficzna miejsca zamieszkania wynosi od 30 do 38 stopni.

sqlda=# EXPLAIN ANALYZE SELECT * FROM customers WHERE (latitude < 38) AND (latitude > 30);

-- Utwórz następny indeks, z wartościami kolumny latitude z tabeli customers większymi niż 30 i mniejszymi niż 38.

sqlda=# CREATE INDEX ix_latitude_less ON customers(latitude) WHERE (latitude < 38) and (latitude > 30); 

-- Użyj instrukcji EXPLAIN ANALYZE do pobrania planu wykonywania kwerendy zwracającej dane z tabeli customers 
-- dotyczące klientów, których szerokość geograficzna miejsca zamieszkania wynosi od 30 do 38 stopni.

sqlda=# EXPLAIN ANALYZE SELECT * FROM customers WHERE (latitude < 38) AND (latitude > 30);



