-- Nawiązywanie połączenia z bazą sqlda.

$ psql sqlda

-- Tworzenie funkcji max_sale, która nie przyjmuje żadnych argumentów wejściowych, ale zwraca
-- wartość liczbową big_sale.

sqlda=# CREATE FUNCTION max_sale() RETURNS integer AS $big_sale$

-- Deklaracja zmiennej big_sale i początek funkcji.

sqlda$# DECLARE big_sale numeric;
sqlda$# BEGIN 

-- Zapisywanie maksymalnej wartości sprzedaży w zmiennej big_sale.

sqlda$# SELECT MAX(sales_amount) INTO big_sale FROM sales; 

-- Zwracanie wartości zmiennej big_sale.

sqlda$# RETURN big_sale; 

-- Kończenie funkcji i podanie specyfikacji języka.

sqlda$# END; $big_sale$
sqlda-# LANGUAGE PLPGSQL; 

-- Wywołanie funkcji w celu pobrania najwyższej wartości sprzedaży z bazy danych.

sqlda=# SELECT MAX(sales_amount) FROM sales;
