-- Umieść każdą transakcję sprzedaży w odrębnym wierszu, używając funkcji JSONB_ARRAY_ELEMENTS.

CREATE TEMP TABLE customer_sales_single_sale_json AS (
    SELECT
        customer_json,
        JSONB_ARRAY_ELEMENTS(customer_json -> 'sales') AS sale_json
    FROM customer_sales LIMIT 10
);

-- Przefiltruj dane wyjściowe i pobierz rekordy, w których kolumna product_name ma wartość 'Blade'.

SELECT DISTINCT customer_json FROM customer_sales_single_sale_json WHERE sale_json ->> 'product_name' = 'Blade' ;

-- Użyj funkcji JSONB_PRETTY(), aby sformatować dane wyjściowe i poprawić czytelność wyników.

SELECT DISTINCT JSONB_PRETTY(customer_json) FROM customer_sales_single_sale_json WHERE sale_json ->> 'product_name' = 'Blade' ;

-- Wykonaj te same operacje, używając wyrażeń JSONPath.

CREATE TEMP TABLE blade_customer_sales AS (
  SELECT
    jsonb_path_query(
      customer_json,
      '$ ? (@.sales[*].product_name == "Blade")'
    ) AS customer_json
  FROM customer_sales
);

SELECT JSONB_PRETTY(customer_json) FROM blade_customer_sales;

-- W ostatnim kroku zlicz klientów, którzy kupili model Blade.

SELECT COUNT(1) FROM blade_customer_sales;
