-- Sprawdź, jakie dane są dostępne w tabeli customer_survey.

SELECT * FROM customer_survey limit 5;

-- Przekształcanie tablicy.

SELECT UNNEST(STRING_TO_ARRAY(feedback, ' ')) AS word, rating FROM customer_survey limit 10;

-- Ustandaryzuj tekst, używając funkcji ts_lexize i stemmera dla języka angielskiego — 'english_stem'. 
-- Następnie usuń z pierwotnego tekstu znaki, które nie są literami. Użyj do tego funkcji REGEXP_REPLACE.

SELECT 
    (TS_LEXIZE('english_stem',
               UNNEST(STRING_TO_ARRAY(
                   REGEXP_REPLACE(feedback, '[^a-zA-Z]+', ' ', 'g'),
                   ' ')
               )))[1] AS token,
    rating
FROM customer_survey 
LIMIT 10;

-- Znajdź średnia ocenę powiązaną z każdym tokenem. Użyj do tego klauzuli GROUP BY.

SELECT
    (TS_LEXIZE('english_stem',
               UNNEST(STRING_TO_ARRAY(
                   REGEXP_REPLACE(feedback, '[^a-zA-Z]+', ' ', 'g'),
                   ' ')
               )))[1] AS token,
    AVG(rating) AS avg_rating
FROM customer_survey 
GROUP BY 1
HAVING COUNT(1) >= 3
ORDER BY 2
;

-- Zweryfikuj założenia. W tym celu użyj wyrażenia ILIKE, aby przefiltrować odpowiedzi ankietowe zawierające poszczególne tokeny.

SELECT * FROM customer_survey WHERE feedback ILIKE '%pop%';

