-- Użyj złączenia INNER JOIN do złączenia tabeli customers z tabelą sales.
-- Użyj złączenia INNER JOIN do złączenia tabeli products z tabelą sales.
-- Użyj złączenia LEFT JOIN, aby złączyć tabelę dealerpships z tabelą sales.
-- Zwróć wszystkie kolumny z tabel customers i products.
-- Zwróć też wartości kolumny dealership_id z tabeli sales, ale jeśli ta wartość to NULL, zastąp ją liczbą -1.

SELECT 
c.*,
p.*,
COALESCE(s.dealership_id, -1),
CASE WHEN p.base_msrp - s.sales_amount >500 THEN 1 ELSE 0 END AS high_savings 
FROM sales s
INNER JOIN customers c ON c.customer_id=s.customer_id
INNER JOIN products p ON p.product_id=s.product_id
LEFT JOIN dealerships d ON s.dealership_id = d.dealership_id;
