﻿Function Install-Sql2014
{
	param
	(
		[Parameter(Position=0,Mandatory=$false)][string] $Path,
		[Parameter(Position=1,Mandatory=$false)][string] $InstanceName = "MSSQLSERVER",
		[Parameter(Position=2,Mandatory=$false)][string] $ServiceAccount,
		[Parameter(Position=3,Mandatory=$false)][string] $ServicePassword,
		[Parameter(Position=4,Mandatory=$false)][string] $SaPassword,
		[Parameter(Position=5,Mandatory=$false)][string] $LicenseKey,
		[Parameter(Position=6,Mandatory=$false)][string] $SqlCollation = "SQL_Latin1_General_CP1_CI_AS",
		[Parameter(Position=7,Mandatory=$false)][switch] $NoTcp,
		[Parameter(Position=8,Mandatory=$false)][switch] $NoNamedPipes
	)
	
	#Tworzenie instrukcji instalacji
	if ($Path -eq $null -or $Path -eq "")
	{
		#Brak ścieżki oznacza, że plik instalacyjny znajduje się w bieżącym katalogu
		$command = 'setup.exe /Action="Install"'
	}
	else
	{
		#Upewnij się, że ścieżka kończy się lewym ukośnikiem
		if(!$Path.EndsWith("\"))
		{
			$Path += "\"
		}
		
		$command = $path + 'setup.exe /Action="Install"'
	}
	
	#Akceptacja licencji (wymagane przy instalacji z poziomu wiersza poleceń)
	$command += ' /IACCEPTSQLSERVERLICENSETERMS'
	
	#Użycie trybu QuietSimple (z paskiem postępu, ale bez interakcji)
	$command += ' /QS'
	
	#Ustawianie instalowanych funkcji
	$command += ' /FEATURES=SQLENGINE,CONN,BC,SSMS,ADV_SSMS'
	
	#Ustawianie nazwy egzemplarza
	$command += (' /INSTANCENAME="{0}"' -f $InstanceName)
	
	#Ustawianie klucza licencyjnego, jeśli jest dostępny; W przeciwnym razie instalowana jest edycja Evaluation
	if ($LicenseKey -ne $null -and $LicenseKey -ne "")
	{
		$command += (' /PID="{0}"' -f $LicenseKey)
	}
	
	#Sprawdzanie, czy ustawiono konto usługowe
	if ($ServiceAccount -ne $null -and $ServiceAccount -ne "")
	{
		#Ustawianie konta usługowego dla silnika bazodanowego
		$command += (' /SQLSVCACCOUNT="{0}" /SQLSVCPASSWORD="{1}" /SQLSVCSTARTUPTYPE="Automatic"' -f $ServiceAccount, $ServicePassword)
		#Ustawianie konta usługowego dla narzędzia SQL Server Agent
		$command += (' /AGTSVCACCOUNT="{0}" /AGTSVCPASSWORD="{1}" /AGTSVCSTARTUPTYPE="Automatic"' -f $ServiceAccount, $ServicePassword)
	}
	else
	{
		#Ustawianie konta usługowego dla silnika bazodanowego na Local System
		$command += ' /SQLSVCACCOUNT="NT AUTHORITY\SYSTEM" /SQLSVCSTARTUPTYPE="Automatic"'
		#Ustawianie konta usługowego dla narzędzia SQL Server Agent na Local System
		$command += ' /AGTSVCACCOUNT="NT AUTHORITY\SYSTEM" /AGTSVCSTARTUPTYPE="Automatic"'
	}
	
	#Ustawianie trybu uwierzytelniania z systemu SQL Server, jeśli podane zostało hasło dla użytkownika SA
	if ($SaPassword -ne $null -and $SaPassword -ne "")
	{
		$command += (' /SECURITYMODE="SQL" /SAPWD="{0}"' -f $SaPassword)
	}
	
	#Dodawanie bieżącego użytkownika jako administratora systemu
	$command += (' /SQLSYSADMINACCOUNTS="{0}"' -f [Security.Principal.WindowsIdentity]::GetCurrent().Name)
	
	#Ustawianie kolacji bazy danych
	$command += (' /SQLCOLLATION="{0}"' -f $SqlCollation)
	
	#Włączanie lub wyłączanie protokołu TCP
	if ($NoTcp)
	{
		$command += ' /TCPENABLED="0"'
	}
	else
	{
		$command += ' /TCPENABLED="1"'
	}
	
	#Włączanie lub wyłączanie protokołu Named Pipes
	if ($NoNamedPipes)
	{
		$command += ' /NPENABLED="0"'
	}
	else
	{
		$command += ' /NPENABLED="1"'
	}
	
	if ($PSBoundParameters['Debug']) 
	{
		Write-Output $command
	}
	else
	{
		Invoke-Expression $command
	}
}