//tag::all[]
//tag::allButValidation[]
package tacos;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

import org.hibernate.validator.constraints.CreditCardNumber;

import lombok.Data;

@Data
public class Order {

  //end::allButValidation[]
  @NotBlank(message="Podanie imienia i nazwiska jest obowiązkowe")
  //tag::allButValidation[]
  private String name;
  //end::allButValidation[]

  @NotBlank(message="Podanie ulicy jest obowiązkowe")
  //tag::allButValidation[]
  private String street;
  //end::allButValidation[]

  @NotBlank(message="Podanie miejscowości jest obowiązkowe")
  //tag::allButValidation[]
  private String city;
  //end::allButValidation[]

  @NotBlank(message="Podanie województwa jest obowiązkowe")
  //tag::allButValidation[]
  private String state;
  //end::allButValidation[]

  @NotBlank(message="Podanie kodu pocztowego jest obowiązkowe")
  //tag::allButValidation[]
  private String zip;
  //end::allButValidation[]

  @CreditCardNumber(message="To nie jest prawidłowy numer karty kredytowej")
  //tag::allButValidation[]
  private String ccNumber;
  //end::allButValidation[]

  @Pattern(regexp="^(0[1-9]|1[0-2])([\\/])([1-9][0-9])$",
           message="Wartość musi być w formacie MM/RR")
  //tag::allButValidation[]
  private String ccExpiration;
  //end::allButValidation[]

  @Digits(integer=3, fraction=0, message="Nieprawidłowy kod CVV")
  //tag::allButValidation[]
  private String ccCVV;

}
//end::allButValidation[]
//end::all[]
