package com.apress.springrecipes.springintegration;

import org.apache.commons.lang.exception.ExceptionUtils;

import org.apache.log4j.Logger;

import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessagingException;


public class DefaultErrorHandlingServiceActivator {
    private static final Logger logger = Logger.getLogger(DefaultErrorHandlingServiceActivator.class);

    @ServiceActivator
    public void handleThrowable(Message<Throwable> errorMessage)
        throws Throwable {
        Throwable throwable = errorMessage.getPayload();
        logger.debug(String.format("Komunikat: %s. Ślad stosu:%s", throwable.getMessage(), ExceptionUtils.getFullStackTrace(throwable)));

        if (throwable instanceof MessagingException) {
            Message<?> failedMessage = ((MessagingException) throwable).getFailedMessage();

            if (failedMessage != null) {
                // Wykorzystanie pierwotnego komunikatu
            }
        } else {
			// Błąd został zgłoszony w trakcie wykonywania kodu w jednym z utworzonych przez Ciebie komponentów
        }
    }
}
