// Końcowa wersja
package com.apress.springrecipes.court.web;

import com.apress.springrecipes.court.domain.Reservation;
import com.apress.springrecipes.court.service.ReservationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@Controller
// Wiązanie kontrolera z adresem URL /reservationQuery
// Początkowy widok jest określany na podstawie nazwy zwracanej przez domyślną metodę obsługi żądań GET.
@RequestMapping("/reservationQuery")
public class ReservationQueryController {
    private ReservationService reservationService;

	// Podłączanie dostępnej w kontekście aplikacji usługi w konstruktorze
    @Autowired
    public ReservationQueryController(ReservationService reservationService) {
        this.reservationService = reservationService;
    }


	// Kontroler zawsze najpierw szuka domyślnej metody obsługi żądań GET (niezależnie od jej nazwy).
	// Tu ta metoda to setupForm, co ułatwia jej identyfikację
    @RequestMapping(method = RequestMethod.GET)
    public void setupForm() {
		// Metoda zwraca void, dlatego używany jest widok domyślny (reservationQuery).
		// Na podstawie konfiguracji widok reservationQuery jest wiązany
		// z plikiem JSP /WEB-INF/jsp/reservationQuery.jsp 
    }

	// Kontroler zawsze najpierw szuka domyślnej metody obsługi żądań POST (niezależnie od jej nazwy),
	// gdy dane są przesyłane pod dany adres URL (@RequestMapping(/reservationQuery)).
	// Tu ta metoda to submitForm, co ułatwia jej identyfikację	
    @RequestMapping(method = RequestMethod.POST)
	// Przesyłane dane są dostępne w polu courtName. Używany jest też obiekt Model
	// do zwrócenia wyników
    public String sumbitForm(@RequestParam("courtName")
    String courtName, Model model) {
        // Tworzenie listy rezerwacji
        List<Reservation> reservations = java.util.Collections.emptyList();

		// Zgłaszanie zapytania, jeśli parametr jest różny od null
        if (courtName != null) {
            reservations = reservationService.query(courtName);
        }

		// Dodawanie rezerwacji do modelu
        model.addAttribute("reservations", reservations);

		// Zwracanie łańcucha znaków z widokiem.
		// Na podstawie konfiguracji widok reservationQuery jest wiązany
		// z plikiem JSP /WEB-INF/jsp/reservationQuery.jsp 
        return "reservationQuery";
    }
}
