// Wersja końcowa 
package com.apress.springrecipes.court.web;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;


@Controller
public class AboutController {
    @Value("#{ messageSource.getMessage('admin.email',null,'en')}")
    private String email;

    // Metoda bezpośrednio powiązana z adresem URL /about
    @RequestMapping("/about")
    // Metoda przyjmuje obiekt Model, aby ustawić adres e-mail
    public String courtReservation(Model model) {
        // Dodanie adresu e-mail do modelu, aby można go było wyświetlić w widoku
        model.addAttribute("email", email);

        // Zwracanie widoku about. Jest on wiązany z plikiem
        // /WEB-INF/jsp/welcome.jsp
        return "about";
    }
}
