package com.apress.springrecipes.course;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import java.util.GregorianCalendar;
import java.util.List;


public class Main {
    public static void main(String[] args) {
        ApplicationContext context = new ClassPathXmlApplicationContext("beans-jpa.xml"); // Lub 'beans-hibernate.xml' 

        CourseDao courseDao = (CourseDao) context.getBean("courseDao");

        Course course = new Course();
        course.setTitle("Platforma Spring");
        course.setBeginDate(new GregorianCalendar(2007, 8, 1).getTime());
        course.setEndDate(new GregorianCalendar(2007, 9, 1).getTime());
        course.setFee(1000);
        courseDao.store(course);

        List<Course> courses = courseDao.findAll();
        Long courseId = courses.get(0).getId();

        course = courseDao.findById(courseId);
        System.out.println("Tytuł kursu: " + course.getTitle());
        System.out.println("Data rozpoczęcia: " + course.getBeginDate());
        System.out.println("Data zakończenia: " + course.getEndDate());
        System.out.println("Opłata: " + course.getFee());

        courseDao.delete(courseId);
    }
}
