package com.apress.springrecipes.board.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;


import com.apress.springrecipes.board.service.MessageBoardService;
import com.apress.springrecipes.board.domain.Message;


// Wiązanie kontrolera z adresem URL /reservationForm.
// Początkowy widok jest określany na podstawie nazwy zwróconej przez
// domyślną metodę obsługi żądań GET.
@Controller
@RequestMapping("/messagePost*")
//@SessionAttributes("message") 
public class MessagePostController {

    private MessageBoardService messageBoardService;


    @Autowired
    public void MessagePostController(MessageBoardService messageBoardService) {
        this.messageBoardService = messageBoardService;
    }

	// Kontroler zawsze najpierw próbuje wywołać domyślną metodę obsługi żądań GET (niezależnie od jej nazwy).
	// Tu ta metoda nosi nazwę setupForm, co ułatwia jej identyfikację.
    @RequestMapping(method = RequestMethod.GET)
    public String setupForm(Model model) {
	// Tworzenie obiektu message
        Message message = new Message();
	// Dodawanie obiektu message do modelu, co pozwala wyświetlić go w widoku
        model.addAttribute("message", message);
        return "messagePost";
    }

    @RequestMapping(method = RequestMethod.POST)
    public String onSubmit(@ModelAttribute("message") Message message, BindingResult result) { //, SessionStatus status) { 
        if (result.hasErrors()) {
	    // Wystąpiły błędy. Należy wrócić do widoku messagePost
            return "messagePost";
        } else {
            messageBoardService.postMessage(message);
            return "redirect:messageList";
        }
    }
}
