// Końcowa wersja
package com.apress.springrecipes.court.web;

import com.apress.springrecipes.court.domain.Reservation;
import com.apress.springrecipes.court.service.ReservationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;


@Controller
// Wiązanie kontrolera z adresem URL /reservationSummary
// Początkowy widok jest określany na podstawie nazwy zwracanej przez domyślną metodę obsługi żądań GET.
@RequestMapping("/reservationSummary*")
public class ReservationSummaryController {
    private ReservationService reservationService;

	// Podłączanie usługi dostępnej w kontekście aplikacji
    @Autowired
    public ReservationSummaryController(ReservationService reservationService) {
        this.reservationService = reservationService;
    }

	// Zauważ parametr z ustawieniem required="true" w pierwszej metodzie. Jeśli adres URL
	// nie pasuje do wzorca /reservationSummary*?date=*, metoda nie zostanie wykonana.
	// UWAGA: Ponieważ jest to domyślna (i jedyna) metoda obsługi żądań GET,
	//        niedopasowanie (brak daty w adresie URL) prowadzi do zgłoszenia błędu
    @RequestMapping(method = RequestMethod.GET)
    public String generateSummary(@RequestParam(required = true, value = "date")
    String selectedDate, Model model) {
		// Tworzenie pustej listy rezerwacji
        List<Reservation> reservations = java.util.Collections.emptyList();

        // Formatowanie daty
        try {
            Date summaryDate = new SimpleDateFormat("yyyy-MM-dd").parse(selectedDate);
            reservations = reservationService.findByDate(summaryDate);

			// Przechwytywanie błędu, jeśli data z żądania ma niewłaściwy format
        } catch (java.text.ParseException ex) {
			// Zgłaszanie niestandardowego błędu.
			// Zgodnie z odwzorowaniem exceptionMappings ten błąd jest kierowany do widoku reservationWebException,
			// wiązanego z plikiem /WEB-INF/jsp/error.jsp
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            throw new ReservationWebException("Błędny format daty w podsumowaniu rezerwacji", new Date(), sw.toString());
        }

		// Po przekazaniu daty należy dodać rezerwacje (jeśli takie istnieją).
		// Nalezy dodać obiekt reservations do modelu, aby móc go wyświetlić w widoku
        model.addAttribute("reservations", reservations);

        // Sprawdzanie rozszerzenia z żądania
        /**
        if(request.getServletPath().endsWith(".pdf")) {
            // Rozszerzenie PDF.
            // Zwracany widok to pdfSummary. Jest on wiązany z 
            // klasą PdfReservationSummary
            // na podstawie definicji z pliku views.properties
            return "pdfSummary";
        } else if(request.getServletPath().endsWith(".xls")) {
            // Rozszerzenie XLS.
            // Zwracany widok to xlsSummary. Jest on wiązany z 
            // klasą ExcelReservationSummary
            // na podstawie definicji z pliku views.properties
            return "excelSummary";
        } else {
            // Inne rozszerzenia powodują zwrócenie widoku reservationSummary,
            // wiązanego z plikiem /WEB-INF/jsp/reservationSummary.jsp
            return "reservationSummary";
            }*/
        return "reservationSummary";
    }
}
